 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Port object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: May 21, 1993 09:42
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_PortP_h_
#define _xvlang_PortP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvlang/Port.h>
#include <xvobjects/PixmapP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwPortGadgetClassPart
{
     XtPointer  extension;
} XvwPortGadgetClassPart;

typedef struct _XvwPortGadgetClassRec
{
    RectObjClassPart            rect_class;
    XvwManagerGadgetClassPart   manager_class;
    XvwPixmapGadgetClassPart    pixmap_class;
    XvwPortGadgetClassPart	port_class;
} XvwPortGadgetClassRec;

extern  XvwPortGadgetClassRec xvwPortGadgetClassRec;

typedef struct
{
   Boolean  dav;		/* whether data is available or not	      */
   Boolean  selected;		/* whether the object is selected or not      */
   Boolean  showdav;		/* whether objects should show dav	      */
   int	    type;		/* whether this is an input or output	      */
   kform_struct *selection;	/* the input/output kform selection	      */
   xvobject connection_parent;  /* the parent to create the connection on     */

   Pixmap   dav_pixmap;
   Pixmap   optional_pixmap;
   Pixmap   required_pixmap;
   Pixmap   selected_pixmap;

   int      num;
   Boolean  temporary;
   Boolean  connection_start;
   char	    *filename;
   xvobject *connections;
   Pixel    select_pixel;
   xvobject dav_obj;
   XtCallbackList dav_callback;
   XtCallbackList selected_callback;
   XtCallbackList filename_callback;

} XvwPortPart;


typedef struct _XvwPortGadgetRec
{
  ObjectPart          object;
  RectObjPart         rectobj;
  XvwManagerObjPart   manager;
  XvwPixmapPart       pixmap;
  XvwPortPart	      port;

} XvwPortGadgetRec;

typedef struct  _XvwPortGadgetClassRec  *XvwPortGadgetClass;
typedef struct  _XvwPortGadgetRec       *XvwPortGadget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Object Declaration XvwPortGadget
 */
extern XvwPortGadgetClassRec xvwPortGadgetClassRec;


#endif /* _xvlang_PortP_h_ */
/* Do not add after this line */
