 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: all #defines, structures, and global
   >>>>		       definitions used by the xvisual library
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Mar 02, 1995
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _xvisual_xvisual_h_
#define _xvisual_xvisual_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <xvgraphics/xvgraphics.h>

/*
 *  General graphics widget/gadget (used for subclassing)
 */
#include <xvisual/Graphics.h>
#include <xvisual/Color.h>

/*
 *  Layout Management widgets
 */
#include <xvisual/Area.h>

/*
 *  Image Display
 */
#include <xvisual/Image.h>
#include <xvisual/Animate.h>
#include <xvisual/Zoom.h>
#include <xvisual/ImageIcon.h>
#include <xvisual/PanIcon.h>

/*
 *  Color Display
 */
#include <xvisual/Palette.h>
#include <xvisual/Pseudo.h>
#include <xvisual/Threshold.h>
#include <xvisual/ColorCell.h>

/*
 *  Plotting Display
 */
#include <xvisual/Axis2D.h>
#include <xvisual/Axis.h>
#include <xvisual/Plot2D.h>
#include <xvisual/Plot3D.h>

/*
 *  Annotation Display
 */
#include <xvisual/Line.h>
#include <xvisual/Circle.h>
#include <xvisual/Date.h>
#include <xvisual/Timer.h>
#include <xvisual/Indicator.h>
#include <xvisual/Polyline.h>
#include <xvisual/Marker.h>
#include <xvisual/Rectangle.h>
#include <xvisual/String.h>
#include <xvisual/StringValue.h>
#include <xvisual/TextString.h>
#include <xvisual/AnnotateMenu.h>

/*
 *  General Information Display
 */
#include <xvisual/Position.h>
#include <xvisual/PrintPixel.h>
#include <xvisual/PrintMapVal.h>

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define SET_LABELED_INTERVAL    1
#define SET_NUMBER_STEPS        2
#define SET_INTERVAL_STEPS      3
#define SET_MAX_MIN             4
#define SET_DEFAULT_MODE        5

#define INSIDE                  1
#define CENTERED                2
#define OUTSIDE                 3

#define KGRAPHICS_NONPROP             1
#define KGRAPHICS_PROP_WINDOWED       2
#define KGRAPHICS_PROP_NONWINDOWED    3

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

int xvw_save_annotations       PROTO((xvobject, kfile *));
int xvw_restore_annotations    PROTO((xvobject, kfile *));
int xvw_getimage               PROTO((xvobject, int, int, kobject));

char **CreateVariableList      PROTO((char *, int, int *));
char *CreateFunctionDefinition PROTO((char *, char *, char **, int));
char *CreateFunctionCall       PROTO((int, int *, int, int, char *, double *));

/* keyboard (non-interactive) ROI extraction routines  */
kobject xvw_getroi_rectangle PROTO((xvobject, kobject, int, int, int, int));
kobject xvw_getroi_line      PROTO((xvobject, kobject, int, int, int, int));
kobject xvw_getroi_signal    PROTO((xvobject, kobject, int, int, int, int));
kobject xvw_getroi_circle    PROTO((xvobject, kobject, int, int, int));
kobject xvw_getroi_ellipse   PROTO((xvobject, kobject, int, int, int, int));
kobject xvw_getroi_polyline  PROTO((xvobject, kobject, XPoint *, int));


#endif /* _xvisual_xvisual_h_ */
/* Don't add after this point */
