 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical text annotation.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 14:42
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_TextString_h_
#define _xvisual_TextString_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for Text String Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:     XVW_TEXTSTRING_INSERTION
|
| Description:   The text string insertion attribute represents the current 
|                position in which the user will be inserting text.  The text 
|                string object has an event handler that when the user types 
|                new text is inserted or deleted.  The position in which that 
|                action is applied is dependent on the current text string 
|                insertion point.  The user uses the mouse in which to control
|                the insert position.  So be aware that setting this value can 
|                always be over ridden by the user selecting (Button Press) a 
|                new position.
|
| Type:          int
| Default:       0
| Legal Values:  values > 0
| Resource:      textstringInsertion
------------------------------------------------------------------------*/
#define XVW_TEXTSTRING_INSERTION	"textstringInsertion"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the TextString Object by.
 */
#define TextStringGadgetClass	xvwTextStringGadgetClass

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  XToolkit Widget Declaration for TextStringGadgetClass
 */
extern   WidgetClass     TextStringGadgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for Text String Visual Object
 */
xvobject xvw_create_textstring PROTO((xvobject, char *));


#endif /* _xvisual_TextString_h_ */
/* Don't add after this point */
