 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the graphical
   >>>>		       string annotation.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 14:48
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_StringP_h_
#define _xvisual_StringP_h_


    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvisual/GraphicsP.h>
#include <xvisual/String.h>

    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct _XvwStringGadgetClassPart
{
    XtPointer  extension;
} XvwStringGadgetClassPart;

typedef struct _XvwStringGadgetClassRec
{
    RectObjClassPart        rect_class;
    XvwManagerGadgetClassPart  manager_class;
    XvwGraphicsGadgetClassPart graphics_class;
    XvwStringGadgetClassPart   string_class;
} XvwStringGadgetClassRec;



typedef struct
{
    Coord   placement;
    Boolean emphasize;
    int     justification;
    String  string;

    String  *lines;
    int	    numlines;
    int     string_ascent;
    int     string_descent;
    Dimension string_width, string_height;
} XvwStringPart;


typedef struct _XvwStringGadgetRec
{
    ObjectPart	   	object;
    RectObjPart     	rectobj;
    XvwManagerObjPart	manager;
    XvwGraphicsPart	graphics;
    XvwStringPart  	string;
} XvwStringGadgetRec;


typedef struct  _XvwStringGadgetClassRec   *XvwStringGadgetClass;
typedef struct  _XvwStringGadgetRec        *XvwStringGadget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwStringGadget
 */
extern XvwStringGadgetClassRec xvwStringGadgetClassRec;


#endif /* _xvisual_StringP_h_ */
/* Don't add after this point */
