 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the graphical
   >>>>		       plot3d object.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 14:30
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Plot3DP_h_
#define _xvisual_Plot3DP_h_


    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvisual/ColorP.h>
#include <xvisual/Plot3D.h>

    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct _XvwPlot3DGadgetClassPart
{
    XtPointer  extension;
} XvwPlot3DGadgetClassPart;


typedef struct _Plot3DObjClassRec
{
    RectObjClassPart            rect_class;
    XvwManagerGadgetClassPart   manager_class;
    XvwGraphicsGadgetClassPart  graphics_class;
    XvwColorGadgetClassPart     color_class;
    XvwPlot3DGadgetClassPart    plot3d_class;
} XvwPlot3DGadgetClassRec;


typedef struct
{
    String  plot_name;

    Boolean reset_wc;
    double  data_max_x;
    double  data_max_y;
    double  data_max_z;
    double  data_min_x;
    double  data_min_y;
    double  data_min_z;

    kobject pobject;
    Coord   *points;
    int     plot_type;
    int     shade_type;
    int     plot_size;
    int     plot_width;
} XvwPlot3DPart;


typedef struct _XvwPlot3DGadgetRec
{
    ObjectPart		object;
    RectObjPart		rectangle;
    XvwManagerObjPart	manager;
    XvwGraphicsPart	graphics;
    XvwColorPart	color;
    XvwPlot3DPart	plot3d;
} XvwPlot3DGadgetRec;


typedef struct  _XvwPlot3DGadgetClassRec   *XvwPlot3DGadgetClass;
typedef struct  _XvwPlot3DGadgetRec        *XvwPlot3DGadget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwPlot3DGadget
 */
extern XvwPlot3DGadgetClassRec xvwPlot3DGadgetClassRec;


#endif /* _xvisual_Plot3DP_h_ */
/* Don't add after this point */
