 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       PanIcon widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Jun 29, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_PanIcon_h_
#define _xvisual_PanIcon_h_

    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

/*
 *  Attribute definitions for Pan Icon Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:     XVW_PANICON_SIZE
|
| Description:   The desired physical size of the pan icon.  Note that the 
|                actual size of the pan icon may be automatically modified 
|                to preserve proportionality in the event that a non-square 
|                image is displayed.
|
| Type:          int
| Default:       100
| Legal Values:  values > 50
| Resource:      paniconSize
------------------------------------------------------------------------*/
#define  XVW_PANICON_SIZE	 "paniconSize"

/*------------------------------------------------------------------------
| Attribute:     XVW_PANICON_XPOS
|
| Description:   The X position in the displayed image defining the 
|                region on which the panicon is panning (this region
|		 is outlined by a white window in the panicon).
|
| Type:          int
| Default:       0
| Legal Values:  0 - screen width
| Resource:      N/A
------------------------------------------------------------------------*/
#define  XVW_PANICON_XPOS	 "paniconXpos"

/*------------------------------------------------------------------------
| Attribute:     XVW_PANICON_YPOS
|
| Description:   The Y position in the displayed image defining the 
|                region on which the panicon is panning (this region
|		 is outlined by a white window in the panicon).
|
| Type:          int
| Default:       0
| Legal Values:  0 - screen height
| Resource:      N/A
------------------------------------------------------------------------*/
#define  XVW_PANICON_YPOS	 "paniconYpos"

/*------------------------------------------------------------------------
| Attribute:     XVW_PANICON_WIDTH
| Description:   The width in the displayed image defining the 
|		 region on which the panicon is panning (this region
|                is outlined by a white window in the panicon).
| Type:          int
| Default:       100
| Legal Values:  values > 50
| Resource:      N/A
------------------------------------------------------------------------*/
#define  XVW_PANICON_WIDTH	 "paniconWidth"

/*------------------------------------------------------------------------
| Attribute:     XVW_PANICON_HEIGHT
| Description:   The height in the displayed image defining the 
|                region on which the panicon is panning (this region
|                is outlined by a white window in the panicon).
| Type:          int
| Default:       100
| Legal Values:  values > 50
| Resource:      N/A
------------------------------------------------------------------------*/
#define  XVW_PANICON_HEIGHT	 "paniconHeight"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the PanIcon Object by.
 */
#define PanIconWidgetClass	xvwPanIconWidgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration for PanIconWidgetClass
 */
extern   WidgetClass     PanIconWidgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function definitions for Pan Icon Visual Object
 */
xvobject xvw_create_panicon  PROTO((xvobject, char *));

#endif /* _xvisual_PanIcon_h_ */
/* Don't add after this point */
