 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the image
   >>>>		       display widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 14:17
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_ImageP_h_
#define _xvisual_ImageP_h_


    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvisual/ColorP.h>
#include <xvisual/Image.h>

#if defined(KSHM_DEF) && (KOPSYS_LOCAL==KOPSYS_DYNIX)
typedef struct _quad { long val[2]; } quad;
typedef unsigned char   unchar;
typedef unsigned short  ushort;
typedef unsigned int    uint;
typedef unsigned long   ulong;
#endif /* KSHM_DEF && KOPSYS_DYNIX */

#ifdef KMITSHM_DEF

#if (KOPSYS_LOCAL == KOPSYS_FREEBSD || KOPSYS_LOCAL == KOPSYS_SOLARIS || KOPSYS_LOCAL == KOPSYS_SUNOS) &&KSTDC_DEF
#define ushort unsigned short
#define ulong  unsigned long
#define uint   unsigned int
#define uchar  unsigned char

#define u_short ushort
#define u_int   uint
#define u_long  ulong
#define u_char  uchar
#endif

#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>

#endif /* KMITSHM_DEF */


    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct _XvwImageWidgetClass
{
    XtPointer  extension;
} XvwImageWidgetClassPart;


typedef struct _XvwImageWidgetClassRec
{
    CoreClassPart		core_class;
    CompositeClassPart		composite_class;
    ConstraintClassPart		constraint_class;
    XvwManagerWidgetClassPart	manager_class;
    XvwGraphicsWidgetClassPart	graphics_class;
    XvwColorWidgetClassPart	color_class;
    XvwImageWidgetClassPart	image_class;
} XvwImageWidgetClassRec;


typedef struct
{
    /*  resources  */
    kobject	iobject;
    kobject	cobject;
    kobject	mobject;
    Pixel	pixel;
    double	value;
    Boolean	backing;
    int		xoffset;
    int		yoffset;
    int		xposition;
    int		yposition;

    kaddr	shminfo;
    XImage	*ximage;
    XImage	*xclip;
    XImage	*xcolormap;
    XImage	*xoverlay;
    Pixmap	pixmap;

    int		band_number;
    int		band_maxnum;
    int		region_num;
    int		region_width;
    int		region_height;
    int		complex_convert;
    int		band_dimensions;
    int		image_depth;
    int		wsize, hsize, esize, dsize, tsize;
    int		roi_shape;
    int         roi_policy;
    int		roi_presentation;
    Boolean     roi_multiband;
    Boolean     multiple_roi;

    Boolean     reload;
    Boolean     redisplay;
    Boolean     recolor;
    Boolean     resize;
    Boolean	has_alpha;
    int		reload_type;
    XtCallbackList  callbacks;

    kaddr	idata;
    kaddr	cdata;
    kaddr	mdata;
    kaddr	ldata;
    kaddr	alpha;
    double	alpha_offset;
    double	alpha_factor;
} XvwImagePart;


typedef struct _XvwImageWidgetRec
{
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    XvwManagerPart	manager;
    XvwGraphicsPart	graphics;
    XvwColorPart	color;
    XvwImagePart	image;
} XvwImageWidgetRec;


typedef struct  _XvwImageWidgetClassRec    *XvwImageWidgetClass;
typedef struct  _XvwImageWidgetRec         *XvwImageWidget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwImageWidget
 */
extern  XvwImageWidgetClassRec xvwImageWidgetClassRec;

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/
 
/* ImageUtil.c */
void ImageInit		 PROTO((Widget));
void ImageReloadXData    PROTO((Widget, int, int, int, int, int));
void ImageReload         PROTO((Widget, kdms_callback *));
void ImageSetPosition    PROTO((Widget, int, int, int));
void ImageUpdatePosition PROTO((xvobject, kaddr, XEvent *, int *));
int ImageGetRoi 	 PROTO((xvobject, char *, kaddr));
int ImageSetRoi 	 PROTO((xvobject, char *, kaddr));
int ImageGetName         PROTO((xvobject, char *, kaddr));
int ImageSetName         PROTO((xvobject, char *, kaddr));


#endif /* _xvisual_ImageP_h_ */
/* Don't add after this point */
