 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for graphics attributes that
   >>>>                control the viewport coordinate system.
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_GraphicsVP_h_
#define _xvisual_GraphicsVP_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_VIEWPORT_MIN_X
|
| Description:  This is the minimum viewport value for X.
|
| Type:         double
| Default:      0.0
| Legal Values: value <
|               .symbol index XVW_GRAPHICS_VIEWPORT_MAX_X
| Resource:     graphicsViewportMinX
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_VIEWPORT_MIN_X     "graphicsViewportMinX"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_VIEWPORT_MIN_Y
|
| Description:  This is the minimum viewport value for Y.
|
| Type:         double
| Default:      0.0
| Legal Values: value <
|               .symbol index XVW_GRAPHICS_VIEWPORT_MAX_Y
| Resource:     graphicsViewportMinY
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_VIEWPORT_MIN_Y     "graphicsViewportMinY"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_VIEWPORT_MIN_Z
|
| Description:  This is the minimum viewport value for Z.
|               Note that this attribute is only applicable to 3D objects.
|
| Type:         double
| Default:      0.0
| Legal Values: value <
|               .symbol index XVW_GRAPHICS_VIEWPORT_MAX_Z
| Resource:     graphicsViewportMinZ
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_VIEWPORT_MIN_Z     "graphicsViewportMinZ"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_VIEWPORT_MAX_X
|
| Description:  This is the maximum viewport value for X.
|
| Type:         double
| Default:      1.0
| Legal Values: value >
|               .symbol index XVW_GRAPHICS_VIEWPORT_MIN_X
| Resource:     graphicsViewportMaxX
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_VIEWPORT_MAX_X     "graphicsViewportMaxX"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_VIEWPORT_MAX_Y
|
| Description:  This is the maximum viewport value for Y.
|
| Type:         double
| Default:      1.0
| Legal Values: value >
|               .symbol index XVW_GRAPHICS_VIEWPORT_MIN_Y
| Resource:     graphicsViewportMaxY
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_VIEWPORT_MAX_Y     "graphicsViewportMaxY"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_VIEWPORT_MAX_Z
|
| Description:  This is the maximum viewport value for Z.
|               Note that this attribute is only applicable to 3D objects.
|
| Type:         double
| Default:      1.0
| Legal Values: value >
|               .symbol index XVW_GRAPHICS_VIEWPORT_MIN_Z
| Resource:     graphicsViewportMaxZ
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_VIEWPORT_MAX_Z     "graphicsViewportMaxZ"

#endif /* _xvisual_GraphicsVP_h_ */
/* Don't add after this point */
