 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for graphics attributes that
   >>>>                deal with clipping
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_GraphicsClip_h_
#define _xvisual_GraphicsClip_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_CLIPPING
| Description:  When TRUE, this attribute turns clipping on;  
|               FALSE causes clipping to be turned off.  When clipping
|               is on, any parts of a visual object that have X and Y 
|               world coordinates that lie outside the world coordinate maximum
|               and minimum values specified for X and Y will not be drawn. 
|               So, for example, an application might implement the capability
|               to "zoom in" and "zoom out" on a plot simply by changing 
|               the world coordinate maximums and minimums while clipping 
|               is on.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     graphicsClipping
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_CLIPPING           "graphicsClipping"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_DEPTH_CLIPPING
| Description:  When TRUE, this attribute allows a 3D visual object to be 
|               clipped with respect to depth. When depth clipping is on, 
|               any portions of a visual object that have Z world coordinates
|               outside the world coordinate maximum and minimum values for
|               Z will not be drawn.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     graphicsDepthClipping
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_DEPTH_CLIPPING     "graphicsDepthClipping"

#endif /* _xvisual_GraphicsClip_h_ */
/* Don't add after this point */
