 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the color color
   >>>>		       widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 15:05
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_ColorP_h_
#define _xvisual_ColorP_h_


    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvisual/GraphicsP.h>
#include <xvisual/Color.h>


    /*-------------------------------------*
    |       defines
    ---------------------------------------*/

#define XtInheritColorReload      ((void (*)())_XtInherit)

#define RED_COLOR   0
#define GREEN_COLOR 1
#define BLUE_COLOR  2

    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct
{
    Widget	  widget;
    Pixel         *pixels;
    XColor        *xcolors;
    int           *mapping;
    int		  ncolors;
    double	  *maps;
    double	  *red, *green, *blue;
    int		  map_width, map_height;
    char 	  *filename;

    double	  scale;
    long	  minval, maxval;
    unsigned long *histogram;

    int           initialized;
    int           references;
} ColorObjInfo;

typedef struct
{
    /*  resources  */
    Position       begin;
    Position       end;

    kobject        object;
    XtCallbackList color_callbacks;

    int            norm_type;
    int            norm_method;
    Boolean	   norm_ubyte;
    Boolean	   private_cmap;
    char           *red_function;
    char           *green_function;
    char           *blue_function;

    int            alloc_policy;
    double	   update_time;

    /*  private state  */
    Boolean  allocated;
    int	     visual_depth;
    int      rshift, gshift, bshift;
    unsigned long rmask, gmask, bmask;

    ColorObjInfo *info;
    int		 indx;
    XtIntervalId id;
    Boolean	 initialize_visual;

} XvwColorPart;


/*
 *  Declaration for the Color Gadget
 */
typedef struct _XvwColorGadgetClass
{
    kfunc_void color_reload;
} XvwColorGadgetClassPart;


typedef struct _XvwColorGadgetClassRec
{
    RectObjClassPart	       rect_class;
    XvwManagerGadgetClassPart  manager_class;
    XvwGraphicsGadgetClassPart graphics_class;
    XvwColorGadgetClassPart    color_class;
} XvwColorGadgetClassRec;


typedef struct _XvwColorGadgetRec
{
    ObjectPart		object;
    RectObjPart		rectobj;
    XvwManagerObjPart	manager;
    XvwGraphicsPart	graphics;
    XvwColorPart	color;
} XvwColorGadgetRec;

typedef struct  _XvwColorGadgetClassRec  *XvwColorGadgetClass;
typedef struct  _XvwColorGadgetRec       *XvwColorGadget;


/*
 *  Declaration for the Color Widget
 */
typedef struct _XvwColorWidgetClass
{
    kfunc_void color_reload;
} XvwColorWidgetClassPart;


typedef struct _XvwColorWidgetClassRec
{
    CoreClassPart                   core_class;
    CompositeClassPart              composite_class;
    ConstraintClassPart             constraint_class;
    XvwManagerWidgetClassPart       manager_class;
    XvwGraphicsWidgetClassPart      graphics_class;
    XvwColorWidgetClassPart	    color_class;
} XvwColorWidgetClassRec;


typedef struct _XvwColorWidgetRec
{
    CorePart                core;
    CompositePart           composite;
    ConstraintPart          constraint;
    XvwManagerPart	    manager;
    XvwGraphicsPart         graphics;
    XvwColorPart	    color;
} XvwColorWidgetRec;


typedef struct  _XvwColorWidgetClassRec  *XvwColorWidgetClass;
typedef struct  _XvwColorWidgetRec       *XvwColorWidget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwColorGadget
 */
extern  XvwColorGadgetClassRec xvwColorGadgetClassRec;

/*
 *  XToolkit Widget Declaration XvwColorWidget
 */
extern  XvwColorWidgetClassRec xvwColorWidgetClassRec;


        /*-------------------------------------*
        |       macros
        ---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* ColorUtil.c */
void         ColorInit     PROTO((Widget));
void         ColorReload   PROTO((Widget, int, int));
XvwColorPart *GetColorPart PROTO((Widget));
Pixel        ColorAllocate PROTO((Widget, register int));
void	     ColorFree     PROTO((Widget, int, int));
void	     ColorStore    PROTO((Widget, int, XColor *));
void	     ColorSort     PROTO((Widget, double *, int *, int, int));

void	      ColorReloadXData   PROTO((Widget));
Pixel         *ColorGetPixels    PROTO((Widget));
XColor        *ColorGetXColors   PROTO((Widget));
unsigned long *ColorGetHistogram PROTO((Widget));
int	      ColorSetUtil       PROTO((xvobject, char *, kaddr));
int	      ColorGetUtil       PROTO((xvobject, char *, kaddr));
int	      ColorFileDetect    PROTO((xvobject, char *, kaddr));
int	      ColorChangeMapCol  PROTO((xvobject, char *, kaddr));




#endif /* _xvisual_ColorP_h_ */
/* Don't add after this point */
