 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the graphical
   >>>>		       axis object.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 11:35
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_AxisP_h_
#define _xvisual_AxisP_h_

    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvisual/GraphicsP.h>
#include <xvisual/Axis.h>


    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct _tic_label_list
{
    xvobject stringvalue;
    char     name[80];
    struct   _tic_label_list *next;
} tic_label_list;

typedef struct _XvwAxisGadgetClassPart
{
    XtPointer  extension;
} XvwAxisGadgetClassPart;

typedef struct _XvwAxisGadgetClassRec
{
    RectObjClassPart		rect_class;
    XvwManagerGadgetClassPart	manager_class;
    XvwGraphicsGadgetClassPart	graphics_class;
    XvwAxisGadgetClassPart	axis_class;
} XvwAxisGadgetClassRec;


typedef struct
{
    Boolean		restore_labels;
    int			axis_mode;
    Boolean		show_box;
    XColor		box_color;
    Boolean		show_major_grid;
    Boolean		show_minor_grid;
    int			major_grid_line_type;
    int			minor_grid_line_type;
    int			major_grid_line_width;
    int			minor_grid_line_width;
    XColor		major_grid_color;
    XColor		minor_grid_color;
    Coord		begin_axis;
    Coord		end_axis;
    Coord		axis_direction;
    Boolean		show_axis;
    XColor		axis_color;
    Boolean		show_axis_label;
    Boolean		show_zero_line;
    int			number_minor_tics;
    int			tic_justification;
    Boolean		show_tics;
    int			labeling_mode;
    double		labeled_max;
    double		labeled_min;
    double		number_steps;
    double		labeled_interval;
    Boolean		nice_labels;
    char		*font_type;
    char		*label;
    Boolean		show_tic_labels;
    XColor		tic_labels_color;
    String		tic_labels_format;

    int			id;

    char		*old_tic_labels_format;
    XColor		old_tic_labels_color;
    Boolean		maximum_same;
    Boolean		minimum_same;
    tic_label_list	*list_head;
    tic_label_list	*list_tail;
    int			number_stringvalue_widgets;
    xvobject		axis_label;
    Boolean		axis_label_initialized;
    double		actual_max;
    double		actual_min;
} XvwAxisPart;

typedef struct _XvwAxisGadgetRec {
    ObjectPart		object;
    RectObjPart		rectobj;
    XvwManagerObjPart	manager;
    XvwGraphicsPart	graphics;
    XvwAxisPart		axis;
} XvwAxisGadgetRec;

typedef struct  _XvwAxisGadgetClassRec   *XvwAxisGadgetClass;
typedef struct  _XvwAxisGadgetRec        *XvwAxisGadget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwAxisGadget
 */
extern XvwAxisGadgetClassRec xvwAxisGadgetClassRec;


#endif /* _xvisual_Axis_h_ */
/* Do not add after this line */
