 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       2D axis widget
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 11:23
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Axis2D_h_
#define _xvisual_Axis2D_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attributes for Axis 2D Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS2D_AXIS_X
|
| Description:   This \fIread-only\fP attribute allows you to obtain
|                the axis object that serves as the X Axis.
|
| Type:          xvobject
| Default:       NULL
| Legal Values:  The axis object that is used as the X axis (read only).
| Resource:      N/A
------------------------------------------------------------------------*/
#define	XVW_AXIS2D_AXIS_X	"axis2dAxisX"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS2D_AXIS_Y
|
| Description:   This \fIread-only\fP attribute allows you to obtain
|                the axis object that serves as the Y Axis
|
| Type:          xvobject
| Default:       NULL
| Legal Values:  The axis object that is used as the Y axis (read only).
| Resource:      N/A
------------------------------------------------------------------------*/
#define	XVW_AXIS2D_AXIS_Y	"axis2dAxisY"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS2D_SHOW_AXIS_X
|
| Description:   The X axis is displayed when this attribute is set to TRUE;
|                it is not displayed when this attribute is set to FALSE.
|
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:      axis2dShowAxisX
------------------------------------------------------------------------*/
#define	XVW_AXIS2D_SHOW_AXIS_X	"axis2dShowAxisX"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS2D_SHOW_AXIS_Y
|
| Description:   The Y axis is displayed when this attribute is set to TRUE;
|                it is not displayed when this attribute is set to FALSE.
|
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:      axis2dShowAxisY
------------------------------------------------------------------------*/
#define	XVW_AXIS2D_SHOW_AXIS_Y	"axis2dShowAxisY"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Axis2D Object by.
 */
#define Axis2DGadgetClass	xvwAxis2DGadgetClass

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definition for Axis 2D Visual Object
 */
xvobject xvw_create_axis2d PROTO((xvobject, char *));


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration Axis2DGadgetClass
 */
extern   WidgetClass	Axis2DGadgetClass;


#endif /* _xvisual_Axis2D_h_ */
/* Don't add after this point */
