 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>       Purpose: All #defines, structures, and global      <<<<
   >>>>                definitions and routine declarations      <<<<
   >>>>                used by the xvforms library               <<<<
   >>>>                                                          <<<<
   >>>>    Written By: Danielle Argiro                           <<<<
   >>>>                                                          <<<<
   >>>>          Date: Jul 7, 1992 10:00                         <<<<
   >>>>                                                          <<<<
   >>>> Modifications: converted from xvforms.h in Khoros 1.0    <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvforms_xvforms_h_
#define _xvforms_xvforms_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvforms/xvformsP.h>


        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/
/*
 * #defines for extra calls
 */

#define XVF_CALL_FIRST      1
#define XVF_CALL_LAST       2
#define XVF_CALL_SUBSTITUTE 3

/*
 * #defines for GUI item elements
 */
#define XVF_BACKPLANE    1
#define XVF_OPT_OBJ      2
#define XVF_BUTTON_OBJ   3
#define XVF_LABEL_OBJ    4
#define XVF_TEXT_OBJ     5
#define XVF_SCROLL_OBJ   6
#define XVF_PIXMAP_OBJ   7

/*
 * #defines for controlling use of menuforms
 */
#define XVF_NO_EDIT      -1
#define XVF_PARTIAL_EDIT  0
#define XVF_FULL_EDIT     1

#define KFORM_ENTIRE_FORM   1
#define KFORM_FULL_SUBFORM  2
#define KFORM_PANE_ONLY     3

/*
 * #defines for GUI/UIS attributes
 */
#define XVF_ACTIVATE 		KVF_ACTIVATE
#define XVF_SELECTED 		KVF_SELECTED
#define XVF_OPTIONAL 		KVF_OPTIONAL
#define XVF_OPTSEL 		KVF_OPTSEL
#define XVF_LIVE 		KVF_LIVE
#define XVF_VARIABLE 		KVF_VARIABLE
#define XVF_DESCRIPTION 	KVF_DESCRIPTION
#define XVF_TITLE		KVF_TITLE
#define XVF_BUTTONTITLE		KVF_BUTTONTITLE
#define XVF_GUIDEPANETITLE	KVF_GUIDEPANETITLE
#define XVF_LITERAL		KVF_LITERAL
#define XVF_MODIFIED		KVF_MODIFIED
#define XVF_WIDTH		KVF_WIDTH
#define XVF_HEIGHT		KVF_HEIGHT
#define XVF_X			KVF_X
#define XVF_Y			KVF_Y
#define XVF_BUTTONWIDTH		KVF_BUTTONWIDTH
#define XVF_BUTTONHEIGHT	KVF_BUTTONHEIGHT
#define XVF_BUTTONX		KVF_BUTTONX
#define XVF_BUTTONY		KVF_BUTTONY
#define XVF_XPOS		KVF_XPOS
#define XVF_YPOS		KVF_YPOS

#define XVF_DELETE		KVF_DELETE
#define XVF_DISPLAY_SUBFORM	KVF_DISPLAY_SUBFORM
#define XVF_DISPLAY_PANE   	KVF_DISPLAY_PANE
#define XVF_CLIENTDATA   	KVF_CLIENTDATA

#define XVF_PRINT_UIS		KVF_PRINT_UIS
#define XVF_PRINT_PANE		KVF_PRINT_PANE
#define XVF_PRINT_SUBFORM	KVF_PRINT_SUBFORM

#define XVF_PANE_FILE           KVF_PANE_FILE
#define XVF_SUBFORM_FILE        KVF_SUBFORM_FILE
#define XVF_UIS_LOCATION        KVF_UIS_LOCATION

#define XVF_FILE_NAME 		KVF_FILE_NAME
#define XVF_FILE_CHECK   	KVF_FILE_CHECK
#define XVF_FILE_DEF 		KVF_FILE_DEF
#define XVF_STRING_VAL 		KVF_STRING_VAL
#define XVF_STRING_DEF 		KVF_STRING_DEF
#define XVF_STRING_MULTILINE 	KVF_STRING_MULTILINE

#define XVF_EXECTYPE 		KVF_EXECTYPE
#define XVF_ROUTINE 		KVF_ROUTINE
#define XVF_HELPPATH 		KVF_HELPPATH

#define XVF_TOGGLE_SIZE 	KVF_TOGGLE_SIZE
#define XVF_TOGGLE_MEMBERS 	KVF_TOGGLE_MEMBERS
#define XVF_TOGGLE_CONTENTS 	KVF_TOGGLE_CONTENTS
#define XVF_TOGGLE_NUM 		KVF_TOGGLE_NUM
#define XVF_TOGGLE_VAL 		KVF_TOGGLE_VAL
#define XVF_TOGGLE_TYPE 	KVF_TOGGLE_TYPE

#define XVF_LOGIC_VAL 		KVF_LOGIC_VAL
#define XVF_LOGIC_DEF 		KVF_LOGIC_DEF
#define XVF_LOGIC_1LABEL 	KVF_LOGIC_1LABEL
#define XVF_LOGIC_0LABEL 	KVF_LOGIC_0LABEL

#define XVF_LIST_SIZE 		KVF_LIST_SIZE
#define XVF_LIST_VAL 		KVF_LIST_VAL
#define XVF_LIST_LABEL 		KVF_LIST_LABEL
#define XVF_LIST_INDEX 		KVF_LIST_INDEX
#define XVF_LIST_START 		KVF_LIST_START
#define XVF_LIST_CHOICES 	KVF_LIST_CHOICES
#define XVF_LIST_CONTENTS 	KVF_LIST_CONTENTS
#define XVF_LIST_DOUBLECLICK 	KVF_LIST_DOUBLECLICK
#define XVF_LIST_ADD 	        KVF_LIST_ADD
#define XVF_LIST_DELETE 	KVF_LIST_DELETE
#define XVF_LIST_DELETEALL 	KVF_LIST_DELETEALL
#define XVF_VAL_LABELS    	KVF_VAL_LABELS

#define XVF_CYCLE_SIZE 		KVF_CYCLE_SIZE
#define XVF_CYCLE_VAL 		KVF_CYCLE_VAL
#define XVF_CYCLE_LABEL 	KVF_CYCLE_LABEL
#define XVF_CYCLE_INDEX 	KVF_CYCLE_INDEX
#define XVF_CYCLE_START 	KVF_CYCLE_START
#define XVF_CYCLE_CHOICES 	KVF_CYCLE_CHOICES
#define XVF_CYCLE_CONTENTS 	KVF_CYCLE_CONTENTS
#define XVF_CYCLE_ADD           KVF_CYCLE_ADD
#define XVF_CYCLE_DELETE        KVF_CYCLE_DELETE
#define XVF_CYCLE_DELETEALL     KVF_CYCLE_DELETEALL

#define XVF_INT_GT0_SEL         KVF_INT_GT0_SEL
#define XVF_INT_GE0_SEL         KVF_INT_GE0_SEL
#define XVF_INT_LT0_SEL         KVF_INT_LT0_SEL
#define XVF_INT_LE0_SEL         KVF_INT_LE0_SEL
#define XVF_INT_UPPER_SEL 	KVF_INT_UPPER_SEL
#define XVF_INT_LOWER_SEL	KVF_INT_LOWER_SEL
#define XVF_INT_BOUNDS_SEL      KVF_INT_BOUNDS_SEL
#define XVF_INT_NOBOUNDS_SEL    KVF_INT_NOBOUNDS_SEL
#define XVF_INT_UPPER 		KVF_INT_UPPER
#define XVF_INT_LOWER 		KVF_INT_LOWER
#define XVF_INT_DEF		KVF_INT_DEF
#define XVF_INT_VAL		KVF_INT_VAL
#define XVF_MECHANISM		KVF_MECHANISM

#define XVF_FLOAT_GT0_SEL       KVF_FLOAT_GT0_SEL
#define XVF_FLOAT_GE0_SEL       KVF_FLOAT_GE0_SEL
#define XVF_FLOAT_LT0_SEL       KVF_FLOAT_LT0_SEL
#define XVF_FLOAT_LE0_SEL       KVF_FLOAT_LE0_SEL
#define XVF_FLOAT_UPPER_SEL     KVF_FLOAT_UPPER_SEL
#define XVF_FLOAT_LOWER_SEL     KVF_FLOAT_LOWER_SEL
#define XVF_FLOAT_BOUNDS_SEL    KVF_FLOAT_BOUNDS_SEL
#define XVF_FLOAT_NOBOUNDS_SEL  KVF_FLOAT_NOBOUNDS_SEL
#define XVF_FLOAT_UPPER 	KVF_FLOAT_UPPER
#define XVF_FLOAT_LOWER 	KVF_FLOAT_LOWER
#define XVF_FLOAT_DEF		KVF_FLOAT_DEF
#define XVF_FLOAT_VAL		KVF_FLOAT_VAL
#define XVF_FLOAT_PREC		KVF_FLOAT_PREC

#define XVF_DOUBLE_GT0_SEL      KVF_DOUBLE_GT0_SEL
#define XVF_DOUBLE_GE0_SEL      KVF_DOUBLE_GE0_SEL
#define XVF_DOUBLE_LT0_SEL      KVF_DOUBLE_LT0_SEL
#define XVF_DOUBLE_LE0_SEL      KVF_DOUBLE_LE0_SEL
#define XVF_DOUBLE_UPPER_SEL    KVF_DOUBLE_UPPER_SEL
#define XVF_DOUBLE_LOWER_SEL    KVF_DOUBLE_LOWER_SEL
#define XVF_DOUBLE_BOUNDS_SEL   KVF_DOUBLE_BOUNDS_SEL
#define XVF_DOUBLE_NOBOUNDS_SEL KVF_DOUBLE_NOBOUNDS_SEL
#define XVF_DOUBLE_UPPER 	KVF_DOUBLE_UPPER
#define XVF_DOUBLE_LOWER 	KVF_DOUBLE_LOWER
#define XVF_DOUBLE_DEF		KVF_DOUBLE_DEF
#define XVF_DOUBLE_VAL		KVF_DOUBLE_VAL
#define XVF_DOUBLE_PREC		KVF_DOUBLE_PREC

        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
        |       macros
        ---------------------------------------*/


/************************************************************
*
*  Routine Name: xvf_set_attribute - set a single attribute of a GUI item
*
*       Purpose: sets a single attribute for a GUI item
*
*         Input: kformstruct - GUI item for which to set the attribute
*                attribute   - the attribute name
*                value       - the attribute value
*
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Value provided must be of the expected data type
*    Written By: Mark Young & Danielle Argiro
*          Date: Feb 1, 1994 
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvf_set_attribute(
*                !   kform_struct kformstruct,
*                !   char         *attribute,
*                !   data         value)
*
*************************************************************/

#define xvf_set_attribute(kformstruct, attribute, value) \
                xvf_set_attributes(kformstruct, attribute, value, NULL)


/************************************************************
*
*  Routine Name: xvf_get_attribute - get a single attribute of a GUI item
*
*       Purpose: gets a single attribute for a GUI item
*
*         Input: kformstruct - GUI item for which to get the attribute
*                attribute   - the attribute name
*                value       - pointer to the the attribute value
*
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Value pointer passed in must be of the expected data type
*    Written By: Mark Young & Danielle Argiro 
*          Date: Feb 1, 1994 
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: xvf_get_attribute(
*                !   kform_struct kformstruct,
*                !   char         *attribute,
*                !   data         *value)
*
*************************************************************/

#define xvf_get_attribute(kformstruct, attribute, value) \
                xvf_get_attributes(kformstruct, attribute, value, NULL)

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/* attributes.c */
int xvf_set_attributes  PROTO((kform_struct *, kvalist));
int xvf_get_attributes  PROTO((kform_struct *, kvalist));
int xvf_vset_attributes PROTO((kform_struct *, kva_list));
int xvf_vget_attributes PROTO((kform_struct *, kva_list));

/* attrib_cb.c */
int xvf_add_gui_callback    PROTO((kform_struct *, char *, kfunc_void, kaddr));
int xvf_remove_gui_callback PROTO((kform_struct *, char *, kfunc_void, kaddr));

/* init.c */
void xvf_initialize PROTO((void));

/* clear.c */
void xvf_clear_selections PROTO((kform *));

/* createtree.c */
kform *xvf_create_form PROTO((char *, int, kfunc_void, kaddr, int, int, int));

/* runform.c */
void xvf_run_form PROTO((void));

/* change.c */
int xvf_change_gui PROTO((kform_struct *, int, char *));

/* extra.c */
int xvf_add_extra_call    PROTO((kform_struct *, kfunc_void, char *, int));
int xvf_remove_extra_call PROTO((kform_struct *, kfunc_void, char *));

/* destroy.c */
void xvf_destroy_allforms PROTO((void));
void xvf_destroy_form     PROTO((kform *));
void xvf_destroy_subform  PROTO((ksubform *));

/* get.c */
xvobject      xvf_get_xvobject    PROTO((kform_struct *, int, int));
kform_struct *xvf_get_kformstruct PROTO((kform *, xvobject));


	/* Ghostwriter Prototypes:  Do Not Erase This Comment */

#endif /* _xvforms_xvforms_h_ */
/* Don't add after this line */
