#include <xvinclude.h>

void main(
   int  argc,
   char **argv,
   char **envp)
{
	xvobject manager, destroy, pane, run, error, input, input_dav,
		 output, output_dav, label;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "example", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	manager = xvw_create_manager(NULL, "");
	xvw_set_attributes(manager,
	    XVW_SELECTABLE, TRUE,
	    XVW_MENUABLE, TRUE,
	    XVW_RESIZABLE, TRUE,
	    XVW_WIDTH, 100,
	    XVW_HEIGHT, 100,
	    NULL);

	destroy = xvw_create_button(manager, "destroy");
	xvw_set_attributes(destroy,
            XVW_PIXMAP_FILENAME, "$DESIGN/objects/library/xvlang/misc/glyph/destroy.xpm",
            XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,
            XVW_RESIZABLE,       TRUE,
            XVW_SELECTABLE,      TRUE,
            XVW_BELOW,           NULL,
            XVW_RIGHT_OF,        NULL,
	    XVW_BORDER_WIDTH,    1,
            NULL);

	run = xvw_create_button(manager, "run");
	xvw_set_attributes(run,
            XVW_PIXMAP_FILENAME, "$DESIGN/objects/library/xvlang/misc/glyph/on.xpm",
            XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,
            XVW_RESIZABLE,       TRUE,
            XVW_SELECTABLE,      TRUE,
            XVW_BELOW,           NULL,
            XVW_LEFT_OF,         NULL,
	    XVW_BORDER_WIDTH,    1,
            NULL);

	pane = xvw_create_button(manager, "pane");
	xvw_set_attributes(pane,
            XVW_PIXMAP_FILENAME, "$DESIGN/objects/library/xvlang/misc/glyph/pane.xpm",
            XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,
            XVW_RESIZABLE,       TRUE,
            XVW_SELECTABLE,      TRUE,
            XVW_BELOW,           NULL,
            XVW_LEFT_OF,         run,
            XVW_RIGHT_OF,        destroy,
	    XVW_BORDER_WIDTH,    1,
            NULL);

	error = xvw_create_button(manager, "error");
	xvw_set_attributes(error,
            XVW_PIXMAP_FILENAME, "$DESIGN/objects/library/xvlang/misc/glyph/error.xpm",
            XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,
            XVW_RESIZABLE,       TRUE,
            XVW_SELECTABLE,      TRUE,
            XVW_BELOW,           pane,
            XVW_RIGHT_OF,        NULL,
            XVW_LEFT_OF,         NULL,
	    XVW_BORDER_WIDTH,    1,
            NULL);

	input = xvw_create_button(manager, "input");
	xvw_set_attributes(input,
            XVW_PIXMAP_FILENAME, "$DESIGN/objects/library/xvlang/misc/glyph/io_selected.xpm",
            XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,
            XVW_RESIZABLE,       TRUE,
            XVW_SELECTABLE,      TRUE,
            XVW_BELOW,           error,
            XVW_RIGHT_OF,        NULL,
            NULL);

	input_dav = xvw_create_button(manager, "idav");
	xvw_set_attributes(input_dav,
            XVW_PIXMAP_FILENAME, "$DESIGN/objects/library/xvlang/misc/glyph/dav.xpm",
            XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,
            XVW_RESIZABLE,       TRUE,
            XVW_SELECTABLE,       TRUE,
            XVW_BELOW,           error,
            XVW_RIGHT_OF,        input,
            NULL);

	output = xvw_create_button(manager, "output");
	xvw_set_attributes(output,
            XVW_PIXMAP_FILENAME, "$DESIGN/objects/library/xvlang/misc/glyph/io_selected.xpm",
            XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,
            XVW_RESIZABLE,       TRUE,
            XVW_SELECTABLE,       TRUE,
            XVW_BELOW,           error,
            XVW_LEFT_OF,         NULL,
            NULL);

	output_dav = xvw_create_button(manager, "odav");
	xvw_set_attributes(output_dav,
            XVW_PIXMAP_FILENAME, "$DESIGN/objects/library/xvlang/misc/glyph/dav.xpm",
            XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,
            XVW_RESIZABLE,       TRUE,
            XVW_SELECTABLE,       TRUE,
            XVW_BELOW,           error,
            XVW_LEFT_OF,         output,
            NULL);

        label = xvw_create_label(manager, "manager");
        xvw_set_attributes(label,
            XVW_LABEL,        "Glyph",
            XVW_ABOVE,        NULL,
            XVW_LEFT_OF,      NULL,
            XVW_RIGHT_OF,     NULL,
            XVW_BORDER_WIDTH, 0,
            NULL);

	/*
	 * display & run program
	 */
	xvf_run_form();
}
