#include <xvinclude.h>

/*
 *  This variation on the relative layout example (see 11.relative_layout)
 *  illustrates how the rootwindow object can be used as a parent to other
 *  objects, to make the children objects appear directly on the root window.
 */
static void button_cb PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        /*
         * note that widgets should be displayed in the same configuration
         * as they are declared below
         */
        xvobject rootwindow;
        xvobject fl_top,       l_top,     c_top,      r_top,     fr_top,
                 fl_umiddle,   l_umiddle, c_umiddle,  r_umiddle, fr_umiddle,
                 fl_middle,    l_middle,  center,     r_middle,  fr_middle,
                 fl_lmiddle,   l_lmiddle, c_lmiddle,  r_lmiddle, fr_lmiddle,
                 fl_bottom,    l_bottom,  c_bottom,   r_bottom,  fr_bottom;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

        /* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  using the root window on which to create buttons;
         *  a special case where a manager backplane is not used.
	 */
	rootwindow = xvw_create_rootwindow("rootwindow", NULL, NULL);


        /* lay out at exact center */
	center = xvw_create_button(rootwindow, "center");
	xvw_set_attributes(center,
		XVW_LABEL,		   "Center",
		XVW_ABOVE, NULL,
		XVW_BELOW, NULL,
		XVW_RIGHT_OF, NULL,
		XVW_LEFT_OF, NULL,
		NULL);

	xvw_add_callback(center, XVW_BUTTON_SELECT, button_cb, NULL);
        /* lay out at center top */
	c_top = xvw_create_button(rootwindow, "c top");
	xvw_set_attributes(c_top,
		XVW_LABEL,		   "Center Top",
		XVW_BELOW, NULL,
		XVW_LEFT_OF, NULL,
		XVW_RIGHT_OF, NULL,
		NULL);
	xvw_add_callback(c_top, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at center bottom */
	c_bottom = xvw_create_button(rootwindow, "c bottom");
	xvw_set_attributes(c_bottom,
		XVW_LABEL,		   "Center Bottom",
		XVW_ABOVE, NULL,
		XVW_LEFT_OF, NULL,
		XVW_RIGHT_OF, NULL,
		NULL);
	xvw_add_callback(c_bottom, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at far left middle */
	fl_middle = xvw_create_button(rootwindow, "fl middle");
	xvw_set_attributes(fl_middle,
		XVW_LABEL,		   "Far Left Middle",
		XVW_ABOVE, NULL,
		XVW_BELOW, NULL,
		XVW_RIGHT_OF, NULL,
		NULL);
	xvw_add_callback(fl_middle, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at far right middle */
	fr_middle= xvw_create_button(rootwindow, "fr middle");
	xvw_set_attributes(fr_middle,
		XVW_LABEL,		   "Far Right Middle",
		XVW_ABOVE, NULL,
		XVW_BELOW, NULL,
		XVW_LEFT_OF, NULL,
		NULL);
	xvw_add_callback(fr_middle, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at far left top */
	fl_top = xvw_create_button(rootwindow, "fl top");
	xvw_set_attributes(fl_top,
		XVW_LABEL,		   "Far Left Top",
		XVW_BELOW, NULL,
		XVW_RIGHT_OF, NULL,
		NULL);
	xvw_add_callback(fl_top, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at far right top */
	fr_top = xvw_create_button(rootwindow, "fr top");
	xvw_set_attributes(fr_top,
		XVW_LABEL,		   "Far Right Top",
		XVW_BELOW, NULL,
		XVW_LEFT_OF, NULL,
		NULL);
	xvw_add_callback(fr_top, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at far left bottom */
	fl_bottom = xvw_create_button(rootwindow,"fl bottom");
	xvw_set_attributes(fl_bottom,
		XVW_LABEL,		   "Far Left Bottom",
		XVW_ABOVE, NULL,
		XVW_RIGHT_OF, NULL,
		NULL);
	xvw_add_callback(fl_bottom, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at far right bottom */
	fr_bottom = xvw_create_button(rootwindow, "fr bottom");
	xvw_set_attributes(fr_bottom,
		XVW_LABEL,		   "Far Right Bottom",
		XVW_ABOVE, NULL,
		XVW_LEFT_OF, NULL,
		NULL);
	xvw_add_callback(fr_bottom, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at center upper middle */
	c_umiddle = xvw_create_button(rootwindow, "cu mid");
	xvw_set_attributes(c_umiddle,
		XVW_LABEL,		   "Center Upper Middle",
		XVW_ABOVE, center,
		XVW_BELOW, c_top,
		XVW_RIGHT_OF, NULL,
		XVW_LEFT_OF, NULL,
		NULL);
	xvw_add_callback(c_umiddle, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at center lower middle */
	c_lmiddle = xvw_create_button(rootwindow, "c lmid");
	xvw_set_attributes(c_lmiddle,
		XVW_LABEL,		   "Center Lower Middle",
		XVW_ABOVE, c_bottom,
		XVW_BELOW, center,
		XVW_RIGHT_OF, NULL,
		XVW_LEFT_OF, NULL,
		NULL);
	xvw_add_callback(c_lmiddle, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at right middle */
	r_middle = xvw_create_button(rootwindow, "r middle");
	xvw_set_attributes(r_middle,
		XVW_LABEL,		   "Right Middle",
		XVW_ABOVE, NULL,
		XVW_BELOW, NULL,
		XVW_RIGHT_OF, center,
		XVW_LEFT_OF, fr_middle,
		NULL);
	xvw_add_callback(r_middle, XVW_BUTTON_SELECT, button_cb, NULL);

        /* lay out at left middle */
	l_middle = xvw_create_button(rootwindow, "l middle");
	xvw_set_attributes(l_middle,
		XVW_LABEL,		   "Left Middle",
		XVW_ABOVE, NULL,
		XVW_BELOW, NULL,
		XVW_RIGHT_OF, fl_middle,
		XVW_LEFT_OF, center,
		NULL);
	xvw_add_callback(l_middle, XVW_BUTTON_SELECT, button_cb, NULL);

	/* display & run program */
	xvf_run_form();
}

/*
 *  the simple callback used for all buttons simply prints to
 *  the tty which button was pressed.
 */
static void button_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	char *label;
 
	xvw_get_attribute(object, XVW_LABEL, &label);
	kfprintf(kstderr, "I'm the button at the %s\n", label);
}
