#include <xvinclude.h>

/*
 *  This example creates an info object to display information.
 *
 *  IMPORTANT NOTE: in general, the info object should *not* be created
 *                  directly;  use of kinfo() is the conventional way to
 *                  create messages in Khoros, so that there is standard
 *                  formatting enforced.  this example is really only for
 *                  academic purposes.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject info;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  Create the info object. Note that since the parent is NULL, a
	 *  toplevel window will be created and the info object placed
	 *  inside.  Set the label, the information message, and the button 
         *  label.
	 */
	info = xvw_create_info(NULL, "Info Message");
	xvw_set_attributes(info,
		XVW_INFO_MESSAGE,   "When a child asks, \"why is it raining\"? I think a cute thing to say is, \"Because God is crying\".  And when the child asks why God is crying, I think a cute thing to say is, \"Probably because of something you did\".",
		XVW_INFO_LABEL, "Random information below",
		NULL);

	/* display & run the program */
	xvf_run_form();
}
