#include <xvinclude.h>

/*
 *  This example creates a simple textinput GUI object, which may
 *  be used for allowing the user to enter text. 
 *
 *  A callback is installed on the textinput object so that when the 
 *  user changes the text, the current text is printed to the tty.
 *
 *  Note that the textinput object should *not* be created directly in an 
 *  xvroutine, as use of the String (-s) UIS line in the *.form file is 
 *  both easier to use and a more standard use of the Khoros system.  
 *  However, the textinput object is provided for use with hybrid xvroutines, 
 *  (such as this example) which do not use a "formalized" GUI as defined 
 *  in a *.form file.
 */
static void textinput_cb PROTO((xvobject, kaddr, kaddr));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
	xvobject object;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane */
	manager = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(manager,
			   XVW_WIDTH,       300,
		           XVW_HEIGHT,      100,
			   NULL);

	/*
         *  Create the textinput object.  give it a label.
         *  tack it horizontally to the parent so that it spans the
         *  width of the manager backplane.  center it in the middle of
         *  the parent.
	 */
	object = xvw_create_textinput(manager, "textinput");
	xvw_set_attributes(object,
		XVW_TEXTINPUT_LABEL,     "Sample Text",
		XVW_TEXTINPUT_TEXT,      "here is the exciting text",
		XVW_TACK_EDGE,           KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	         NULL,
		XVW_BELOW,	         NULL,
		NULL);
	xvw_add_callback(object, XVW_TEXTINPUT_CALLBACK, textinput_cb, NULL);

	/* display & run the program */
	xvf_run_form();
}

/*
 *  the callback for the textinput will be fired when the user changes the
 *  value of the text & hits <cr>. this callback simply prints the text.
 */
static void textinput_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	char *text;

	xvw_get_attribute(object, XVW_TEXTINPUT_TEXT, &text);
	kfprintf(kstderr, "Text reads as follows:\n%s\n", text);
}

