#include <xvinclude.h>

/*
 *  This is a simple canvas program that creates three nodes
 *  according to the GUI's defined in the "images.pane", "putimage.pane",
 *  and "kadd.pane" UIS files in this directory.
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int gridsize = 10;
	xvobject canvas, node;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  Create the image display.  Note since the parent is NULL a
	 *  toplevel window will be created and the image display placed
	 *  inside.  The xvw_set_attribute() call is used to specify the
	 *  image file to be displayed.
	 */
	canvas = xvw_create_canvas(NULL, "canvas");
	xvw_set_attributes(canvas,
		XVW_CANVAS_GRIDSIZE, gridsize,
		XVW_WIDTH,  512,
		XVW_HEIGHT, 512,
		NULL);

	node = xvw_create_node(canvas, "node0");
	xvw_set_attributes(node,
		XVW_NODE_NAME, "Clipboard",
                XVW_XPOSITION, 100,
                XVW_YPOSITION, 100,
		XVW_NODE_PIXMAPFILE, "clipboard.xpm",
		NULL);
	node = xvw_create_node(canvas, "node1");
	xvw_set_attributes(node,
		XVW_NODE_NAME, "Duplicate",
                XVW_XPOSITION, 200,
                XVW_YPOSITION, 100,
		XVW_NODE_PIXMAPFILE, "duplicate.xpm",
		NULL);
	node = xvw_create_node(canvas, "node2");
	xvw_set_attributes(node,
		XVW_NODE_NAME, "Clear",
                XVW_XPOSITION, 200,
                XVW_YPOSITION, 200,
		XVW_NODE_PIXMAPFILE, "clear.xpm",
		NULL);

	/* display & run */
	xvf_run_form();
}
