#include <xvinclude.h>

static void quit_cb PROTO((xvobject, kaddr, kaddr));

/*
 *  This program creates a workspace with a commandbar and quit button.
 *  You may provide a workspace to be restored, as in:
 *
 *  % example $SAMPLEDATA/examples/workspaces/simple_arith.wk
 *
 *  By default, the color arithmetic workspace is restored
 *  (workspaces:ColorArith1)
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject parent, workspace, commandbar, quit;
	char  *filename = "workspaces:ColorArith1";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	if (argc > 1)
	   filename = argv[1];

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "unable to open display");
	   kexit(1);
	}

	/*
	 *  Create the manager.  Note that since the parent is NULL, a
	 *  toplevel window will be created and the manager display placed
	 *  inside.
	 */
	parent = xvw_create_manager(NULL, "Parent");

	/*
	 *  Create the quit button so that the user can quit
	 */
        quit = xvw_create_button(parent, "Quit");
        xvw_set_attributes(quit,
                XVW_LABEL, "Quit",
                XVW_BELOW, NULL,
                XVW_LEFT_OF, NULL,
                XVW_CHAR_WIDTH, 6.0,
                XVW_CHAR_HEIGHT, 1.2,
                NULL);

        /*
         *  Create the commandbar
         */
        commandbar = xvw_create_commandbar(parent, "CommandBar");
        xvw_set_attributes(commandbar,
                XVW_RIGHT_OF, NULL,
                XVW_LEFT_OF, quit,
                XVW_TACK_EDGE, KMANAGER_TACK_HORIZ,
                NULL);

	/*
	 *  Create the workspace.  The XVW_WORKSPACE_RESTORE attribute is
	 *  used to specify the workspace file to be restored.
	 */
	workspace = xvw_create_workspace(parent, "workspace");
	xvw_set_attributes(workspace,
		XVW_BELOW,             commandbar,
		XVW_WIDTH,             750,
		XVW_HEIGHT,            750,
		XVW_WORKSPACE_RESTORE, filename,
		NULL);
	xvw_set_attribute(commandbar, XVW_COMMANDBAR_WORKSPACE, workspace);
	xvw_add_callback(quit, XVW_BUTTON_SELECT, quit_cb, parent);

	/* display & run the program */
	xvf_run_form();
}

/* ARGSUSED */
static void quit_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
        xvobject parent = (xvobject) client_data;
        xvw_destroy(parent);
}
