#include <xvinclude.h>

/*
 *
 */
void  new_options PROTO((xvobject, kaddr, XEvent *));


main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject canvas, glyph;
	char *formfile = "kadd.pane";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	if (argc > 1)
	   formfile = argv[1];

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "unable to open display");
	   kexit(1);
	}

	canvas = xvw_create_canvas(NULL, "canvas");
	xvw_set_attributes(canvas,
		XVW_CANVAS_GRIDSIZE, 20,
		XVW_CANVAS_GRID,     KMANAGER_GRID_ON,
		XVW_WIDTH,           512,
		XVW_HEIGHT,          512,
		NULL);

	glyph = xvw_create_glyph(canvas, "glyph");
	xvw_set_attributes(glyph, 
			   XVW_GLYPH_FORMFILE, formfile,
			   NULL);

	xvw_add_action(glyph, "<Key>O", new_options, NULL, TRUE);
	
	/* display and run */
	xvf_run_form();
}

/*
 *  action handler to get new options program on Key Press 'O'
 */
void  new_options(
   xvobject object,       /* the image visual object */
   kaddr    client_data,  /* not used */ 
   XEvent   *event)       /* also not used - we know what the event was. */
{
	int   len;
	kform *form = NULL;
	char  *string, command[KLENGTH];

	xvw_get_attribute(object, XVW_GLYPH_FORM, &form);
	if (!form)
	{
	   kinfo(KSTANDARD, "Unable to retrieve menu form for glyph '%s'",
			xvw_name(object));
	}
	kprintf("please enter a new command...");
	if ((string = kgets(command)) != NULL)
	{
	   len = kstrlen(string);
	   string[len-1] = '\0';
	   xvf_modify_form_from_cmd(form, command);
	}
}
