#include <xvinclude.h>

void  relayout_manager PROTO((xvobject, kaddr, XEvent *));

/*
 * Similar to 04.layout/, this example uses scrollbars rather
 * than buttons.
 */
void main(
   int  argc,
   char **argv,
   char **envp)
{
	xvobject manager, left, right, top, bottom;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "example", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the manager backplane, 512x512 (pixels) */
	manager = xvw_create_manager(NULL, "manager");
	xvw_set_attributes(manager,
	      XVW_WIDTH,  512,
	      XVW_HEIGHT, 512,
	      NULL);

	left   = xvw_create_scrollbar(manager, "left");
	right  = xvw_create_scrollbar(manager, "right");
	top    = xvw_create_scrollbar(manager, "top");
	bottom = xvw_create_scrollbar(manager, "bottom");

	/*
	 *  create the first vertical scrollbar, values 0 to 100,
         *  2 characters wide, tacked to top & bottom, & centered
	 */
        xvw_set_attributes(left,
              XVW_ORIENTATION,  KSCROLLBAR_ORIENT_VERT,
              XVW_TACK_EDGE,    KMANAGER_TACK_VERT,
	      XVW_WIDTH,        15,
              XVW_SCROLL_MIN,   0.0,
              XVW_SCROLL_MAX,   100.0,
              XVW_SCROLL_VALUE, 10.0,
              XVW_RIGHT_OF,     NULL,
              XVW_BELOW,        top,
              XVW_ABOVE,        bottom,
	      XVW_VERT_DIST,    0,
	      XVW_HORIZ_DIST,   0,
              NULL);

	/*
	 *  create the first vertical scrollbar, values 0 to 100,
         *  2 characters wide, tacked to top & bottom, & centered
	 */
        xvw_set_attributes(right,
              XVW_ORIENTATION,  KSCROLLBAR_ORIENT_VERT,
              XVW_TACK_EDGE,    KMANAGER_TACK_VERT,
	      XVW_WIDTH,        15,
              XVW_SCROLL_MIN,   0.0,
              XVW_SCROLL_MAX,   100.0,
              XVW_SCROLL_VALUE, 10.0,
              XVW_LEFT_OF,      NULL,
              XVW_BELOW,        top,
              XVW_ABOVE,        bottom,
	      XVW_VERT_DIST,    0,
	      XVW_HORIZ_DIST,   0,
              NULL);

	/*
	 *  create the second horizontal scrollbar, values 0 to 100,
         *  2 characters wide, tacked to top & bottom, & centered
	 */
        xvw_set_attributes(top,
              XVW_ORIENTATION,  KSCROLLBAR_ORIENT_HORIZ,
              XVW_TACK_EDGE,    KMANAGER_TACK_HORIZ,
	      XVW_HEIGHT,       15,
              XVW_SCROLL_MIN,   0.0,
              XVW_SCROLL_MAX,   100.0,
              XVW_SCROLL_VALUE, 10.0,
              XVW_BELOW,        NULL,
              XVW_LEFT_OF,      right,
              XVW_RIGHT_OF,     left,
	      XVW_VERT_DIST,    0,
	      XVW_HORIZ_DIST,   0,
              NULL);

	/*
	 *  create the second horizontal scrollbar, values 0 to 100,
         *  2 characters wide, tacked to top & bottom, & centered
	 */
        xvw_set_attributes(bottom,
              XVW_ORIENTATION,  KSCROLLBAR_ORIENT_HORIZ,
              XVW_TACK_EDGE,    KMANAGER_TACK_HORIZ,
	      XVW_HEIGHT,       15,
              XVW_SCROLL_MIN,   0.0,
              XVW_SCROLL_MAX,   100.0,
              XVW_SCROLL_VALUE, 10.0,
              XVW_ABOVE,        NULL,
              XVW_LEFT_OF,      right,
              XVW_RIGHT_OF,     left,
	      XVW_VERT_DIST,    0,
	      XVW_HORIZ_DIST,   0,
              NULL);

	xvw_add_event(manager, ButtonPressMask, relayout_manager, NULL);

	/* display & run program */
	xvf_run_form();
}

/*
 * event handler allowing the user to relayout manager
 */
void  relayout_manager(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	xvw_set_attribute(object, XVW_MANAGER_RELAYOUT, TRUE);
}
