 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Mindless interface to Glue Layer
   >>>>
   >>>>  Private:
   >>>>                 _kdms_glue_input
   >>>>                 _kdms_glue_output
   >>>>                 _kdms_glue_destroy
   >>>>                 _kdms_glue_order
   >>>>                 _kdms_glue_copy_resources
   >>>>                 _kdms_glue_identifier
   >>>>
   >>>>   Static:
   >>>>             
   >>>>   Public:
   >>>>             
   >>>>             
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

/*
 *  Internal structures for the following data services can be found in
 *  the following files:
 *
 *              viff       -  Viff.c
 *              xvimage    -  Xvimage.c
 *              pnm        -  Pnm.c
 *              rast       -  Rast.c
 *              avs image  -  Avs.c
 *              xbm        -  Xbm.c
 *              xpm        -  Xpm.c
 */

extern DataServiceInformation viff_format[];
extern DataServiceInformation xvimage_format[];
extern DataServiceInformation pnm_format[];
extern DataServiceInformation rast_format[];
extern DataServiceInformation avs_format[];
extern DataServiceInformation xbm_format[];
extern DataServiceInformation xpm_format[];
extern DataServiceInformation xwd_format[];
extern DataServiceInformation arf_format[];
extern DataServiceInformation eps_format[];

extern DataServiceInformation ascii_format[];
extern DataServiceInformation raw_format[];

/*
 *  If the user doesn't specify any data format the default format is
 *  defined below.
 */
#define DefaultDataService viff_format

/*
 *  List of currently supported kdataman....
 *
 *  To add a new data service format please see supporting documentation
 *  kdataman.3  NOTE:  The headerless format should *NOT* be in the
 *  services array!!!!!!!!!!!!!!!
 */
static DataServiceInformation *service_list[] =
{
   viff_format,
   xvimage_format,
   pnm_format,
   rast_format,
   xbm_format,
   xpm_format,
   xwd_format,
   avs_format,
   arf_format,
   ascii_format,
   eps_format,  /* last because its output only */
};

/*
 *  define for figuring out the number of data services in the array list
 */
static int NumDataServices = ((int)sizeof(service_list) / 
			      sizeof(service_list[0]));

/*
 * This is the array that will actually be used.  The array above is
 * what is initialized.  This one will grow when users add their
 * own formats.
 */
DataServiceInformation **services = NULL;
int kdms_num_data_formats = 0;

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_init_formats
|       Purpose:
|         Input:
|        Output:
|       Returns:
|    Written By: Jeremy Worley
|          Date: Dec 07, 1994 13:36
| Modifications:
|
------------------------------------------------------------*/

void
_kdms_init_formats(void)
{
   int i;
   
   for (i = 0; i < NumDataServices; i++)
   {
      if (service_list[i] != NULL)
      {
	 services = (DataServiceInformation **) karray_add(
	    (char **) services, (kaddr) service_list[i],
	    kdms_num_data_formats++);
      }
   }
   return;
}

/*-----------------------------------------------------------
|
|  Routine Name: (static) _kdms_glue_service - find the appropriate data 
|                services
|
|       Purpose: This function is used to find the appropriate data
|                services information.
|
|         Input: fid - is the file containing the desired service routines.
|                filename - the filename
|
|        Output: Returns: the desired data service routines on success,
|                         NULL otherwise
|
|    Written By: Jeremy Worley
|          Date: Jan 04, 1995 16:31
| Modifications:
|
------------------------------------------------------------*/

/*ARGSUSED */
static DataServiceInformation *
_kdms_glue_service(int fid, int headerless)
{
   int i;
   int check;

   /*
    * Check to see if the name matches any of the currently listed types.
    */
   for (i = 0; i < kdms_num_data_formats; i++)
   {
      if (services[i] == NULL)
         continue;
      else if (services[i]->check != NULL)
      {

         /*
          * Check to see if this is the data service routines that correspond
          * to the data.  If so then return the data service routine
          * structure.  But first rewind the transport to that when we read
          * the transport we can read it properly.
          */
         check = services[i]->check(fid);
	 klseek(fid, KSEEK_SET, 0);

         if (check == TRUE)
            return (services[i]);
      }
   }

   if (!headerless)
   {
      _kdms_set_error(KDMS_EOBJ_SUPPORT);
      return (NULL);
   }
   else
   {
      return (raw_format);
   }
}


/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_routines - find the appropriate data services
|
|       Purpose: This function is used to find the appropriate data
|                services information.
|
|                If the environment variable "KHOROS_KDMS_FORMAT"
|                if defined, and the identifier argument is NULL, 
|                then use that format instead.
|
|         Input: identifier - is the string containing the type of
|                             object for the desired service routines.
|
|        Output: Returns: the desired data service routines on success,
|                         NULL otherwise
|
|    Written By: Mark Young, Steve Jorgensen & Jeremy Worley
|          Date: Jul 13, 1992 16:09
| Modifications:
|
------------------------------------------------------------*/

DataServiceInformation *
_kdms_glue_routines(char *identifier)
{
   int i;

   if (identifier == NULL)
   {
      identifier = kgetenv("KHOROS_KDMS_FORMAT");

      if (identifier == NULL && DefaultDataService != NULL)
         return (DefaultDataService);
   }

   /*
    * Check to see if the name matches any of the currently listed types.
    */
   for (i = 0; i < kdms_num_data_formats; i++)
   {
      if (services[i] != NULL)
      {
         if (identifier == NULL)
            return (services[i]);
         else if (kstrcmp(identifier, services[i]->identifier) == 0)
            return (services[i]);
      }
   }

   /*
    * If they requested raw, then go ahead and return it.
    */
   if (kstrcmp(identifier, KRAW) == 0)
      return (raw_format);
   
   _kdms_set_error(KDMS_EOBJ_SUPPORT);
   return (NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_input
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Jul 15, 1993 09:15
| Modifications:
|
------------------------------------------------------------*/

int 
_kdms_glue_input(kobject object, char *filename, int flags)
{
   int kflags;
   int fid;
   int status = FALSE;

   kflags = _kdms2kfile_flags(flags);

   if ((fid = kopen(filename, kflags | KOPEN_LOCK,
		    0666)) < 0)
      return (FALSE);

/*    kflock(fid, KLOCK_SH); */

   object->phys->routines = _kdms_glue_service(fid, flags & KOBJ_HEADERLESS);

   /*
    * if the resulting routines were for raw/headerless data, then
    * make sure to set the headerless field in the object before
    * calling the input routine, or else the segments will get
    * set to locked.
    */
   if (object->phys->routines == raw_format)
      object->phys->headerless = TRUE;
   
   if (object->phys->routines && object->phys->routines->input)
      status = object->phys->routines->input(object, fid, flags);

   return (status);

}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_output
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Jul 15, 1993 09:16
| Modifications:
|
------------------------------------------------------------*/

int 
_kdms_glue_output(kobject object, char *filename, int flags)
{
   int fid;
   flags = KOPEN_RDWR | KOPEN_CREAT | KOPEN_TRUNC | KOPEN_LOCK;

      if ((fid = kopen(filename, flags,
		    0666)) < 0)
      return (FALSE);

   if (object->phys->routines && object->phys->routines->output)
   {
      if (object->phys->routines->output(object, fid, flags) == FALSE)
      {
	 if (errno == 13)
	    kerror("kdataman", "kdms_close", "Couldn't open the output data "
		   "file (%s).  This is probably because you don't have "
		   "permission to write into the directory you specified.\n",
		   filename);
	 else
	    kerror("kdataman", "kdms_close", "The output data file (%s) could "
		   "not be written.\n", filename);
	 return(FALSE);
      }
      else
	 return(TRUE);
   }
   else
      return (FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_destroy
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Jul 15, 1993 09:46
| Modifications:
|
------------------------------------------------------------*/

int 
_kdms_glue_destroy(kobject object)
{
   if (object->phys->routines && object->phys->routines->destroy &&
       object->phys->resources != NULL)
      return (object->phys->routines->destroy(object));
   else
      return (FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_order
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Jul 15, 1993 09:51
| Modifications:
|
------------------------------------------------------------*/

int 
_kdms_glue_order(kobject object, char *segment, int *order)
{
   if (object->phys->routines && object->phys->routines->order)
      return (object->phys->routines->order(segment, order));
   else
      return (FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_identifier
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Jul 15, 1993 09:59
| Modifications:
|
------------------------------------------------------------*/

char *
_kdms_glue_identifier(kobject object)
{
   if (object->phys->routines)
      return (object->phys->routines->identifier);
   else
   {
      _kdms_set_error(KDMS_EINTERNAL);

      return (NULL);
   }
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_read_data
|
|       Purpose: Reads data from the transport associated
|                with the object and returns it.
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 01, 1993 11:30
| Modifications:
|
------------------------------------------------------------*/

kaddr 
_kdms_glue_read_data(
                       kobject object,
                       int segment,
                       kaddr * data,
                       int *x0,
                       int *x1)
{
   if (object->phys->resources == NULL)
      return (FALSE);

   if (object->phys->routines->read != NULL)
      return (object->phys->routines->read(object, segment, data, x0, x1));
   else
      kinfo(KDEBUG, "Internal:  _kdms_glue_read_data - null reader\n");

   return (FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_write_data
|
|       Purpose: Reads data from the transport associated
|                with the object and returns it.
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 01, 1993 11:30
| Modifications:
|
------------------------------------------------------------*/

int 
_kdms_glue_write_data(
                        kobject object,
                        int segment,
                        kaddr data,
                        int *x0,
                        int *x1)
{
   if (object->phys->resources == NULL)
      return (FALSE);

   if (object->phys->routines->write != NULL)
      return (object->phys->routines->write(object, segment, data, x0, x1));
   else
      kinfo(KDEBUG, "Internal:  _kdms_glue_write_data - null writer\n");

   return (FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: 
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 01, 1993 11:55
| Modifications:
|
------------------------------------------------------------*/

kaddr 
_kdms_glue_read_segment_data(
                               kaddr transport,
                               int machtype,
                               kfunc_int reader,
                               kfunc_int seeker,
                               int offset,
                               int datatype,
                               int dimension,
                               int *size,
			       int *offsets,
                               kaddr * data,
                               int *x0,
                               int *x1)
{
   return (_kdms_transport_segment_data(
                                         transport, machtype, reader, seeker,
                   offset, datatype, dimension, size, offsets,
					 data, x0, x1));
}

/*-----------------------------------------------------------
|
|  Routine Name: 
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 01, 1993 11:55
| Modifications:
|
------------------------------------------------------------*/

int 
_kdms_glue_write_segment_data(
                                kaddr transport,
                                int machtype,
                                kfunc_int writer,
                                kfunc_int seeker,
                                int offset,
                                int datatype,
                                int dimension,
                                int *size,
				int *offsets,
                                kaddr data,
                                int *x0,
                                int *x1)
{
   return (_kdms_transport_segment_data(transport, machtype, writer,
                                       seeker, offset, datatype,
                                       dimension, size, offsets, &data,
                                       x0, x1) != NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_set_resources
|
|       Purpose: Sets the resource pointer for the object to
|                a specified address.
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 08, 1993 07:51
| Modifications:
|
------------------------------------------------------------*/

int 
_kdms_glue_set_resources(kobject object, kaddr res)
{
   object->phys->resources = res;
   return (TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_get_resources
|
|       Purpose: Sets the resource pointer for the object to
|                a specified address.
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 08, 1993 07:51
| Modifications:
|
------------------------------------------------------------*/

kaddr 
_kdms_glue_get_resources(kobject object)
{
   return (object->phys->resources);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_get_architecture
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 15, 1993 08:53
| Modifications:
|
------------------------------------------------------------*/

int 
_kdms_glue_get_architecture(kobject object)
{
   if (object->phys->routines->get_architecture != NULL)
      return (object->phys->routines->get_architecture(object));
   else
      return (KMACH_LOCAL);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_set_architecture
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 15, 1993 08:53
| Modifications:
|
------------------------------------------------------------*/

int 
_kdms_glue_set_architecture(kobject object, int mach)
{
   if (object->phys->routines->set_architecture != NULL)
      return (object->phys->routines->set_architecture(object, mach));
   else
      return (FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_support
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Oct 18, 1993 11:49
| Modifications:
|
------------------------------------------------------------*/

char **
_kdms_glue_support(int *num)
{
   char **tmp;
   int i;

   tmp = kmalloc(kdms_num_data_formats * sizeof(char *));
   if (tmp == NULL)
      return (NULL);

   for (i = 0; i < kdms_num_data_formats; i++)
      tmp[i] = kstring_copy(services[i]->identifier, NULL);

   if (num)
      *num = kdms_num_data_formats;

   return (tmp);
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_glue_lock
|       Purpose:
|         Input:
|        Output:
|       Returns:
|    Written By: Steve Kubica
|          Date: Aug 23, 1994 16:52
| Modifications:
|
------------------------------------------------------------*/

int _kdms_glue_lock(kobject object, int operation)
{
   if (object->phys->routines->lock != NULL)
      return (object->phys->routines->lock(object, operation));
   else
      return (FALSE);
}

      
