 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Geometry Internals Include
   >>>>
   >>>>    Written By: Steven Kubica
   >>>>
   >>>>          Date: Feb 04, 1993 15:34
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _geom_internals_h_
#define _geom_internals_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/

#include "internals.h"

	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

/* Polymorphic Data Segment Names */
#define KGEOM_SEGMENT_LOCATION		KPDS_SEGMENT_LOCATION
#define KGEOM_SEGMENT_MAP		KPDS_SEGMENT_MAP
#define KGEOM_SEGMENT_WIDTH		KPDS_SEGMENT_WIDTH
#define KGEOM_SEGMENT_HEIGHT		KPDS_SEGMENT_HEIGHT
#define KGEOM_SEGMENT_DEPTH		KPDS_SEGMENT_DEPTH

/* Geometry Specific Data Segment Names */
#define KGEOM_SEGMENT_COLOR    		"color"
#define KGEOM_SEGMENT_NORMAL          	"normal"
#define KGEOM_SEGMENT_RADIUS      	"radius"
#define KGEOM_SEGMENT_TEXTURE_COORD     "textureCoords"
#define KGEOM_SEGMENT_STRING          	"string"

        /*
         *   Dimensionality Defines
         */

/* -- maximum dimensionality is large enough to handle octmesh vectors -- */
#define KGEOM_MAX_DIM		 4

#define KGEOM_COLOR_DIM          4
#define KGEOM_NORMAL_DIM         4  
#define KGEOM_TEXTURE_COORD_DIM  4
#define KGEOM_RADIUS_DIM         2

        /*
         *   Management Defines
         */

/* primitive list internal management */
#define _INTERNAL_PRIMITIVE_POSITION	"internalGeometryPrimitivePosition"
#define _INTERNAL_GEOM_INC_STATE	"internalGeometryIncrementState"

/* mesh primitive manangement */
#define KGEOM_REGION			"region"
#define _INTERNAL_GEOM_SIZE		"internalGeomSize"
#define _INTERNAL_GEOM_REGION_SIZE	"internalGeomRegionSize"

/* mesh primitive manangement */
#define _INTERNAL_LOCATION_DATA_TYPE 	   "locationDataType"
#define _INTERNAL_COLOR_DATA_TYPE	   "colorDataType"
#define _INTERNAL_NORMAL_DATA_TYPE	   "normalDataType"
#define _INTERNAL_RADIUS_DATA_TYPE	   "radiusDataType"
#define _INTERNAL_TEXTURE_COORD_DATA_TYPE  "textureCoordDataType"
#define _INTERNAL_LOCATION_SIZE  	   "locationSize"
#define _INTERNAL_TEXTURE_COORD_SIZE  	   "textureCoordSize"

/* geometry attributes */
#define _INTERNAL_BOUNDING_BOX   	   "boundingBox"
#define _INTERNAL_CENTER         	   "center"
#define _INTERNAL_COLOR                    "color"
#define _INTERNAL_MATRIX	       	   "matrix"

/* values for _INTERNAL_GEOM_INC_STATE */
#define KGEOM_NO_PRIMITIVE_POSITION  -10
#define KGEOM_INC_STATE_OK       0 
#define KGEOM_INC_STATE_FAIL     1 
#define KGEOM_INC_STATE_NUDGE    2 

#define KGEOM_MAGIC_COOKIE       "geometryCookie" 

/* transcript of the primitive manifest */
#define KGEOM_MANIFEST		  	"manifest"
#define KGEOM_MANIFEST_TRANSCRIPT  	"internalTranscript"
#define KGEOM_MANIFEST_TEXTURE  	"internalTranscriptText"
#define KGEOM_MANIFEST_TYPE  	 	"internalTranscriptType"
#define KGEOM_MANIFEST_WIDTH  	 	"internalTranscriptWidth"

/* attribute used to mark how much of a segment is in use */
#define KGEOM_USED	  		"internalUsed"

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

/*
 *   Geometry Services Data Component and Primitive structures
 *  .........................................................................
 */
typedef struct _kgeom_component {

   int   present;

   int   begin_point;
   int   size[2];
   
} kgeom_component;


typedef struct _kgeom_primitive {

   int   primitive;

   int   number;

   /* -- per primitive attributes -- */
   char *texture;
   int   type;
   int   width;

   /* -- primitive components -- */
   int               num_components;
   kgeom_component **components;
   
} kgeom_primitive;

typedef struct _kgeom_manifest {

   int   num_primitives;
   
   kgeom_primitive  **primitives;
   
} kgeom_manifest;
   

   

/*
 *   Geometry Services Data Component and Primitive Definitions
 *  .........................................................................
 */
typedef struct _kgeom_component_defin {

   char *segment;
   int   required;

   int   (*presentation)  PROTO((kobject,int,char *,int **,int *));

   kaddr (*get)   PROTO((kobject,char *,int,int,int *,int,int *,int,kaddr));
   int   (*put)   PROTO((kobject,char *,int,int,int *,int,int *,kaddr));

} kgeom_component_defin;


typedef struct _kgeom_primitive_defin {

   int   primitive;
   char *name;

   int                     num_components;
   kgeom_component_defin **components;

} kgeom_primitive_defin;


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/

/*
 *  a nifty macro to issue a message in addition to setting errno 
 *  when debug is defined
 */
#define kgeom_fail_error(num) \
   { \
     errno = num; \
     kinfo(KDEBUG,"%s:%d\t%s\n",__FILE__,__LINE__,kerrno_lookup(num)); \
     return(FALSE);	\
   }

/*
 *  same nifty macro, but without the return(FALSE)
 */
#define kgeom_error(num) \
   { \
     errno = num; \
     kinfo(KDEBUG,"%s:%d\t%s\n",__FILE__,__LINE__,kerrno_lookup(num)); \
   }


/*
 * generate a traceback message
 */
#define _kgeom_traceback(a) \
        kinfo(KDEBUG,"%s:%s()\tline %d\n",__FILE__,a,__LINE__)

/* 
 *  utility macros --
 *     these are very sensitive to the values of the defines in kgeometry.h!
 */
#define is_quadmesh(prim) \
 ( ((prim >= KGEOM_QUADMESH_LOCATION_ALL) &&  \
    (prim <= KGEOM_QUADMESH_TEXTURE_COORD_COLUMN)) ? TRUE : FALSE)
 
#define is_octmesh(prim) \
 ( ((prim >= KGEOM_OCTMESH_LOCATION_ALL) &&  \
    (prim <= KGEOM_OCTMESH_TEXTURE_COORD_PLANE)) ? TRUE : FALSE)
 
#define is_texture2d(prim) \
 ( ((prim >= KGEOM_TEXTURE2D_ALL) &&  \
    (prim <= KGEOM_TEXTURE2D_COLUMN)) ? TRUE : FALSE)
 
#define is_texture3d(prim) \
 ( ((prim >= KGEOM_TEXTURE3D_ALL) &&  \
    (prim <= KGEOM_TEXTURE3D_PLANE)) ? TRUE : FALSE)
 
	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* geom_attrib.c */
void kgeom_define_attributes PROTO((void));

/* geom_data.c */
int kgeom_define_primitives PROTO((void));
int kgeom_get_primitive     PROTO((kobject, int, kva_list *));
int kgeom_put_primitive     PROTO((kobject, int, kva_list *));
int kgeom_close_hook        PROTO((kobject));

/* geom_defin.c */
kgeom_primitive_defin *kgeom_locate_primitive_defin PROTO((int));

/* geom_fest.c */
kgeom_component *kgeom_construct_component PROTO((int, int, int *));

int  kgeom_establish_manifest_primitive   PROTO((kgeom_manifest *, int,
						 kgeom_primitive_defin *));
int  kgeom_verify_manifest_primitive      PROTO((kgeom_manifest *, int, int,
						 kgeom_primitive_defin *));
int *kgeom_get_manifest_primitive_list    PROTO((kgeom_manifest *));
int  kgeom_set_manifest_primitive_list    PROTO((kgeom_manifest *, int *));
int  kgeom_get_manifest_number_primitives PROTO((kgeom_manifest *));
int  kgeom_set_manifest_number_primitives PROTO((kgeom_manifest *, int));

int             kgeom_write_transcript    PROTO((kobject, kgeom_manifest *));
kgeom_manifest *kgeom_read_transcript     PROTO((kobject));
kgeom_manifest *kgeom_get_manifest        PROTO((kobject));
int             kgeom_destroy_manifest    PROTO((kobject));

/* geom_mesh.c */
kaddr kgeom_get_uniform_mesh PROTO((kobject, kaps_primitive *, kaddr));
int   kgeom_put_uniform_mesh PROTO((kobject, kaps_primitive *, kaddr));
int   kgeom_get_mesh PROTO((kobject, int, kva_list *));
int   kgeom_put_mesh PROTO((kobject, int, kva_list *));
void  kgeom_define_meshes PROTO((void));

/* geom_seg.c */
int kgeom_define_segments PROTO((void));

/* geom_utils.c */
int kgeom_init PROTO((void));
int kgeom_layout     PROTO((kobject));
int kgeom_color_size PROTO((kobject, char *));
char *kgeom_attribute_name PROTO((char *, int));

#endif /* _geom_internals_h_ */
/* Don't add after this point */
