 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgdbm_dump.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgdbm_dump_get_args
| 
|       Purpose: Gets command line args for kgdbm_dump
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgdbm_dump
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgdbm_dump_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgdbm_dump is out of sync with arguments specified in kgdbm_dump's *.pane file; please rerun ghostwriter on kgdbm_dump.";


	/*
	 * allocate the kgdbm_dump structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kgdbm_dump_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "n",
			  &(clui_info->n_int),
			  &(clui_info->n_flag))))
	{
	    kerror(NULL, "kgdbm_dump_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "all",
			  &(clui_info->all_flag))))
	{
	    kerror(NULL, "kgdbm_dump_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "key",
			  &(clui_info->key_string),
			  &(clui_info->key_flag))))
	{
	    kerror(NULL, "kgdbm_dump_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



