 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: The "xwd" format describes the conversion
   >>>>		       used for the format:
   >>>>
   >>>>			   X11 Window Dump File Format
   >>>>
   >>>>	               The format was orignially developed by the
   >>>>		       company/persons:
   >>>>
   >>>>			   MIT Project Athena
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Sep 30, 1992 17:53
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdatafmt_xwd_h_
#define _kdatafmt_xwd_h_

/*
 *	The "xwd" image file format describes the format used by
 *	the X11 Window Dump File Format  conversion routines.  The format was
 *      developed by MIT Project Athena
 *
 *	The following structure is used by the conversion routines to read
 *	and write the xwd files.  This format is not a standard, just an
 *	intermediate format used by the Khoros routines to do convert xwd
 *	files to and from the format.
 */

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/
#undef  XWD_FILE_VERSION
#define XWD_FILE_VERSION 7

#undef  LSBFirst
#define LSBFirst 0

#undef  MSBFirst
#define MSBFirst 1

#undef ZPixmap
#define ZPixmap 2

/* Display classes  used in opening the connection
 * Note that the statically allocated ones are even numbered and the
 * dynamically changeable ones are odd numbered */
#undef  StaticGray
#undef  GrayScale
#undef  StaticColor
#undef  PseudoColor
#undef  TrueColor
#undef  DirectColor

#define StaticGray              0
#define GrayScale               1
#define StaticColor             2
#define PseudoColor             3
#define TrueColor               4
#define DirectColor             5

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _xwdcolor {
        unsigned long   pixel;
        unsigned short  red;
	unsigned short	green;
	unsigned short	blue;
        unsigned char	flags;
        unsigned char	pad;
} xwdcolor;

typedef struct _xwd {
	unsigned long header_size;      /* Size of entire file header (bytes) */
	unsigned long file_version;	/* XWD_FILE_VERSION */
	unsigned long pixmap_format;	/* Pixmap format */
	unsigned long pixmap_depth;	/* Pixmap depth */
	unsigned long pixmap_width;	/* Pixmap width */
	unsigned long pixmap_height;	/* Pixmap height */
	unsigned long xoffset;		/* Bitmap x offset */
	unsigned long byte_order;	/* MSBFirst, LSBFirst */
	unsigned long bitmap_unit;	/* Bitmap unit */
	unsigned long bitmap_bit_order;	/* MSBFirst, LSBFirst */
	unsigned long bitmap_pad;	/* Bitmap scanline pad */
	unsigned long bits_per_pixel;	/* Bits per pixel */
	unsigned long bytes_per_line;	/* Bytes per scanline */
	unsigned long visual_class;	/* Class of colormap */
	unsigned long red_mask;		/* Z red mask */
	unsigned long green_mask;	/* Z green mask */
	unsigned long blue_mask;	/* Z blue mask */
	unsigned long bits_per_rgb;	/* Log2 of distinct color values */
	unsigned long colormap_entries;	/* Number of entries in colormap */
	unsigned long ncolors;		/* Number of Color structures */
	unsigned long width;		/* Window width */
	unsigned long height;		/* Window height */
	long x;				/* Window upper left X coordinate */
	long y;				/* Window upper left Y coordinate */
	unsigned long bdrwidth;		/* Window border width */

	xwdcolor *maps;			/* pointers to store the maps	  */
	kaddr    data;			/* image data			  */
} xwd;

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* xwd.c */
xwd *xwd_readheader PROTO((int));
xwd *xwd_read PROTO((char *));
int xwd_write PROTO((char *, xwd *));
xwd *xwd_fdread PROTO((int));
int xwd_fdwrite PROTO((int, xwd *));
int xwd_writeheader PROTO((int, xwd *));
int xwd_free PROTO((xwd *));
xwd *xwd_create PROTO((void));

#endif /* _kdatafmt_xwd_h_ */
/* Don't add after this point */
