 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Geometry Application Services
   >>>>
   >>>>    Written By: Steve Kubica
   >>>>
   >>>>          Date: Jul 08, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kappserv_kgeometry_h_
#define _kappserv_kgeometry_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <kappserv/kpolymorphic.h>
#include <kappserv/kcolor.h>

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/


	/*
	 *   Initialization Function for Geometry Services 
	 */

int     kgeom_init                       PROTO((void));
#define KGEOM_INIT                       kgeom_init()


/* ################################################################## */

	/*
	 *   Geometry Primitives
	 */

/* Object Level Primitive */
#define KGEOM_OBJECT		 0
#define KNULL_PRIMITIVE 	 0


/* Quadmesh Primitives */
#define KGEOM_QUADMESH				1
#define KGEOM_OCTMESH				2
#define KGEOM_TEXTURE2D				3
#define KGEOM_TEXTURE3D				4

#define KGEOM_QUADMESH_LOCATION_ALL	 	11
#define KGEOM_QUADMESH_LOCATION_VERTEX	 	12
#define KGEOM_QUADMESH_LOCATION_ROW	 	13
#define KGEOM_QUADMESH_LOCATION_COLUMN	 	14

#define KGEOM_QUADMESH_LOCATION_MINIMUM		15
#define KGEOM_QUADMESH_LOCATION_MAXIMUM		16

#define KGEOM_QUADMESH_LOCATION_WIDTH_ALL	21
#define KGEOM_QUADMESH_LOCATION_WIDTH_POINT	22
#define KGEOM_QUADMESH_LOCATION_HEIGHT_ALL	23
#define KGEOM_QUADMESH_LOCATION_HEIGHT_POINT	24

#define KGEOM_QUADMESH_COLOR_ALL	 	31
#define KGEOM_QUADMESH_COLOR_VERTEX	 	32
#define KGEOM_QUADMESH_COLOR_ROW	 	33
#define KGEOM_QUADMESH_COLOR_COLUMN	 	34

#define KGEOM_QUADMESH_NORMAL_ALL	 	41
#define KGEOM_QUADMESH_NORMAL_VERTEX	 	42
#define KGEOM_QUADMESH_NORMAL_ROW	 	43
#define KGEOM_QUADMESH_NORMAL_COLUMN	 	44

#define KGEOM_QUADMESH_TEXTURE_COORD_ALL	51
#define KGEOM_QUADMESH_TEXTURE_COORD_VERTEX	52
#define KGEOM_QUADMESH_TEXTURE_COORD_ROW	53 
#define KGEOM_QUADMESH_TEXTURE_COORD_COLUMN	54

/* Octmesh Primitives */
#define KGEOM_OCTMESH_LOCATION_ALL	 	111
#define KGEOM_OCTMESH_LOCATION_VERTEX	 	112
#define KGEOM_OCTMESH_LOCATION_ROW	 	113
#define KGEOM_OCTMESH_LOCATION_COLUMN	 	114
#define KGEOM_OCTMESH_LOCATION_PLANE	 	115

#define KGEOM_OCTMESH_LOCATION_MINIMUM		127
#define KGEOM_OCTMESH_LOCATION_MAXIMUM		128

#define KGEOM_OCTMESH_LOCATION_WIDTH_ALL	131
#define KGEOM_OCTMESH_LOCATION_WIDTH_POINT	132
#define KGEOM_OCTMESH_LOCATION_HEIGHT_ALL	133
#define KGEOM_OCTMESH_LOCATION_HEIGHT_POINT	134
#define KGEOM_OCTMESH_LOCATION_DEPTH_ALL	135
#define KGEOM_OCTMESH_LOCATION_DEPTH_POINT	136

#define KGEOM_OCTMESH_COLOR_ALL	 		141
#define KGEOM_OCTMESH_COLOR_VERTEX	 	142
#define KGEOM_OCTMESH_COLOR_ROW	 		143
#define KGEOM_OCTMESH_COLOR_COLUMN	 	144
#define KGEOM_OCTMESH_COLOR_PLANE	 	145

#define KGEOM_OCTMESH_NORMAL_ALL	 	151
#define KGEOM_OCTMESH_NORMAL_VERTEX	 	152
#define KGEOM_OCTMESH_NORMAL_ROW	 	153
#define KGEOM_OCTMESH_NORMAL_COLUMN	 	154
#define KGEOM_OCTMESH_NORMAL_PLANE	 	155

#define KGEOM_OCTMESH_TEXTURE_COORD_ALL		161
#define KGEOM_OCTMESH_TEXTURE_COORD_VERTEX	162
#define KGEOM_OCTMESH_TEXTURE_COORD_ROW		163 
#define KGEOM_OCTMESH_TEXTURE_COORD_COLUMN	164
#define KGEOM_OCTMESH_TEXTURE_COORD_PLANE	165


/* Texture Primitives */
#define KGEOM_TEXTURE2D_ALL			211
#define KGEOM_TEXTURE2D_VERTEX			212
#define KGEOM_TEXTURE2D_ROW			213
#define KGEOM_TEXTURE2D_COLUMN			214

#define KGEOM_TEXTURE3D_ALL			221
#define KGEOM_TEXTURE3D_VERTEX			222
#define KGEOM_TEXTURE3D_ROW			223
#define KGEOM_TEXTURE3D_COLUMN			224
#define KGEOM_TEXTURE3D_PLANE			225

/* Geometric Primitives */
#define KGEOM_POLYLINE_DISJOINT  		501
#define KGEOM_POLYLINE_CONNECTED		502
#define KGEOM_TRIANGLES_DISJOINT		503
#define KGEOM_TRIANGLES_CONNECTED		504
#define KGEOM_SPHERES		  		505	
#define KGEOM_CYLINDERS		 		506	
#define KGEOM_DIRECTED_POINTS	 		507	

/* Annotation Primitives */
#define KGEOM_TEXT				550
#define KGEOM_MARKERS				551
#define KGEOM_POLYGON	 			552	
#define KGEOM_RECTANGLES			553
#define KGEOM_ELLIPSES				554


/*	
 *  All primitives numbers below the KGEOM_MAXIMUM_RESERVED_KHOROS_PRIMITIVE 
 *  are reserved for future Khoros expansion ---
 *
 *  	If creating your own primitives, please define them with numbers 
 * 	greater than the KGEOM_MAXIMUM_RESERVED_KHOROS_PRIMITIVE.
 */
#define KGEOM_MAXIMUM_RESERVED_KHOROS_PRIMITIVE    	1024

/* 
 *  All primitives above this number are considered to be geometric
 *  primitives below this number are considered to be meshes or textures
 */
#define KGEOM_MINIMUM_GEOMETRIC_PRIMITIVE   	500


/* ################################################################## */

	/*
	 *   String Versions of Geometry Primitives
         * 
         *      These can be retreived from the primitive number 
	 * 	via the call :  kgeom_primitive_name() 
	 */

/* Mesh Primitives */
#define KGEOM_QUADMESH_STRING			"quadmesh"
#define KGEOM_OCTMESH_STRING		  	"octmesh"
#define KGEOM_TEXTURE2D_STRING		  	"texture2d"
#define KGEOM_TEXTURE3D_STRING		  	"texture3d"


/* Geometric Primitives */
#define KGEOM_POLYLINE_DISJOINT_STRING  	"polylineDisjoint"
#define KGEOM_POLYLINE_CONNECTED_STRING		"polylineConnected"
#define KGEOM_TRIANGLES_DISJOINT_STRING		"trianglesDisjoint"
#define KGEOM_TRIANGLES_CONNECTED_STRING	"trianglesConnected"
#define KGEOM_SPHERES_STRING		  	"spheres"
#define KGEOM_CYLINDERS_STRING		 	"cylinders"
#define KGEOM_DIRECTED_POINTS_STRING	 	"directedPoints"

/* Annotation Primitives */
#define KGEOM_TEXT_STRING			"text"
#define KGEOM_MARKERS_STRING			"markers"
#define KGEOM_POLYGON_STRING	 		"polygon"
#define KGEOM_RECTANGLES_STRING			"rectangles"
#define KGEOM_ELLIPSES_STRING			"ellipses"


/* ################################################################## */

	/*
	 * Attribute Definitions
	 */

/*------------------------------------------------------------------------
| Attribute:	KGEOM_AMBIENT
| Type:		double ambient
| Category:     object
| Default:      0.25
| Legal Values: 0.0 < 1.0
|		
| Description:	This ambient attribute is a real number between 
|		0.0 and 1.0 where 0.0 is complete absorbtion of all 
|		ambient light.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_AMBIENT			"ambient"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_ARCHITECTURE
| Type:		int architecture
| Category:     object
| Default:      
| Legal Values: KMACH_UNKNOWN
|               KMACH_I80x86
|               KMACH_NS32000
|               KMACH_MIPSEL
|               KMACH_I860
|               KMACH_SPARC
|               KMACH_IBMRT
|               KMACH_RS6000
|               KMACH_POWERPC
|               KMACH_MC680x0
|               KMACH_M88x00
|               KMACH_MIPSEB
|               KMACH_PARISC
|               KMACH_CONVEX
|               KMACH_APOLLO
|               KMACH_ALPHA
|               KMACH_CYBER
|               KMACH_CRAY
|               KMACH_VAX
|		
| Description:	This attribute is an integer value which encodes a 
|		description of the floating point and integer representation
|		for the machine which what used to generate the object.
|		For input objects, this attribute is set to reflect the
|		architecture on which the dataset was generated. 
|		For output objects, this attribute is set to the local 
|		architecture.
|		The encoding scheme and specific values for these defines 
|		can be found in 
|		.symbol noindex "$BOOTSTRAP/include/machine/kmachine.h" .
| Access:      
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_ARCHITECTURE              KDMS_ARCHITECTURE

/*------------------------------------------------------------------------
| Attribute:	KGEOM_BOUNDING_BOX
| Type:		float box_min[3], box_max[3]
| Category:     object
| Default:      
| Legal Values: 
|		
| Description:  This attribute defines the bounding box
|               encompassing an object's primitives.  The attribute
|               contains two arrays which define opposing corners
|               of the bounding box.  If this attribute has not yet 
|		been set on a data object, calls to 
|		\f(CWkgeom_get_attribute\fP will be unable
|               to retrieve the attribute.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_BOUNDING_BOX		"geomBoundingBox"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_CENTER
| Type:		float center[3]
| Category:     object
| Default:      
| Legal Values: 
|		
| Description: This attribute is used to store a center point at which
|              to base transformations.  If this attribute has not yet been 
|              set on a data object, calls to \f(CWkgeom_get_attribute\fP 
|              will be unable to retrieve the attribute.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_CENTER			"geomCenter"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_COLOR
| Type:		float color[3]
| Category:     object
| Default:      
| Legal Values: 
|		
| Description:  Color vector. This attribute can be used to apply
|               to all primitives in a geom object and is provided
|               as an alternative of per primitive color data.  If
|               this attribute has not yet been set on a data
|               object, calls to \f(CWkgeom_get_attribute\fP will be
|               unable to retrieve the attribute.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_COLOR			"geomColor"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_COLORSPACE
| Type:		kaddr colorspace
| Category:     object
| Default:      KRGB
| Legal Values: KNONE
|               KGREY
|               KRGB
|               KCMY
|               KYIQ
|               KHSV
|               KHLS
|               KIHS
|               KXYZ
|               KUVW
|               KUCSUVW
|               KUCSSOW
|               KUCSLab
|               KUCSLuv
|
| Description:  The color space coordinate system and model of the
|               value data is set by the
|               .symbol noindex KGEOM_COLORSPACE
|               attribute.  This attribute, in conjunction with the 
|               .symbol noindex KGEOM_HAS_ALPHA 
|               attribute determines the length of a color vector.
|               .symbol noindex KNONE 
|               and 
|               .symbol noindex KGREY 
|               imply a color vector of length one.  All other
|               colorspaces imply a color vector of length three.  If
|               the attribute
|               .symbol noindex KGEOM_HAS_ALPHA 
|               is set, then the color vector will contain an
|               additional element for the alpha channel.  Color space
|               models can be generic, or meet a specific standard.
|               .br
|               The following acronyms are used in the attribute value 
|               naming conventions and their definitions.
|               .br
|               NTSC - national television systems committee
|               .br
|               CIE -  Commission Internationale de L'Eclairage
|               .br
|               UCS -  universal chromaticity scale
|               .br
|               RGB -  red, green, blue (both NTSC & CIE)
|               .br
|               CMY -  NTSC cyan, magenta, yellow
|               .br
|               YIQ -  NTSC luminance, I and Q represent chrominance
|               .br
|               HSV - hue, saturation, value
|               .br
|               HLS -  hue, ligntness, saturation
|               .br
|               IHS -  intensity, hue, saturation
|               .br
|               XYZ, UVW, UCSUVW, UCSSOW, USCLab, and UCULuv are all CIE 
|               models.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_COLORSPACE                KCOLOR_COLORSPACE

/*------------------------------------------------------------------------
| Attribute:	KGEOM_COLOR_DATA_TYPE
| Type:		int datatype
| Category:     object
| Default:      KFLOAT
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG               
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
|		
| Description:  These data type attributes specify the numerical
|               representation of color vertex data.
|               .br
|               When the application programmer specifies a
|               presentation data type different than the actual data
|               type of the stored data, the get functions will cast
|               the data to return the requested data type.  The put
|               functions "put" the data type as it is currently
|               specified.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_COLOR_DATA_TYPE	 	"geomColorDataType"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_COMMENT
| Type:		char *comment
| Category:     object
| Default:      NULL
| Legal Values: 
|		
| Description:  This attribute is a comment string.
|
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_COMMENT                   KPDS_COMMENT

/*------------------------------------------------------------------------
| Attribute:	KGEOM_DATE
| Type:		char *date
| Category:     object
| Default:      NULL
| Legal Values: 
|		
| Description:  This attribute represents the date when the object 
|               was created.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_DATE                      KPDS_DATE

/*------------------------------------------------------------------------
| Attribute:	KGEOM_DIFFUSE
| Type:		double diffuse
| Category:     object
| Default:      0.5
| Legal Values: 0.0 < 1.0 
|		
| Description:	This diffusion attribute is a real number between 
|		0.0 and 1.0 where 0.0 is complete absorbtion of all 
|		diffuse light.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_DIFFUSE			"diffuse"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_FILE_NAME
| Type:		char * filename
| Category:     object
| Default:      
| Legal Values: 
|		
| Description:	This attribute specifies the filename for the data 
|               object.  It can not be set.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_FILE_NAME                 KPDS_NAME

#define KGEOM_FORMAT                    KPDS_FORMAT

/*------------------------------------------------------------------------
| Attribute:	KGEOM_HAS_ALPHA
| Type:		int has_alpha
| Category:     object
| Default:      FALSE
| Legal Values: TRUE 
|               FALSE
|		
| Description:	If this boolean attribute is set to \f(CWTRUE\fP, then
|               an alpha value is included at the end of each color
|               vector.  For example, if the
|               .symbol noindex KGEOM_COLORSPACE 
|               attribute was \f(CWRGB\fP and the
|               .symbol noindex KGEOM_HAS_ALPHA 
|               was \f(CWTRUE\fP, then
|               the size of the color vector would be four.  The first
|               three components would constitute the RGB values, and
|               the fourth would be the alpha value.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_HAS_ALPHA                 KCOLOR_HAS_ALPHA 

/*------------------------------------------------------------------------
| Attribute:	KGEOM_HISTORY
| Type:		char * history
| Category:     object
| Default:      NULL
| Legal Values: 
|		
| Description:	Setting this attribute with a string will append the
|               string to the end of the object's history providing
|               that the 
|               .symbol index KHOROS_HISTORY 
|               environment variable is set.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_HISTORY                   KPDS_HISTORY

/*------------------------------------------------------------------------
| Attribute:	KGEOM_LAYOUT
| Type:		int layout
| Category:     object
| Default:      NULL
| Legal Values: KPER_VERTEX
|		KPER_LINE
|               KPER_FACE
|               KPER_CELL
|
| Description:	The primitives in the object can have per vertex,
|               per face, or per line data.  The attribute value,
|               \f(CWlayout\fP, specifies if color and normal vectors
|               are associated with a vertex, face or edge.  This
|               layout controls how color and vertex data is presented
|               for an existing geom object and how it is stored for a
|               new geom object.  For example, if an existing 
|               object had stored per face colors, setting this
|               attribute to \f(CWKPER_VERTEX\fP would cause
|               \f(CWkgeom_get_data()\fP to return the data as if it
|               had been stored per vertex.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_LAYOUT			"layout"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_LOCATION_DATA_TYPE
| Type:		int datatype
| Category:     object
| Default:      KFLOAT
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG               
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
|		
| Description:  These data type attributes specify the numerical
|               representation of location vertex data.
|               .br
|               When the application programmer specifies a
|               presentation data type different than the actual data
|               type of the stored data, the get functions will cast
|               the data to return the requested data type.  The put
|               functions "put" the data type as it is currently
|               specified.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_LOCATION_DATA_TYPE 	"geomLocationDataType"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_LOCATION_SIZE
| Type:		int loc_size
| Category:     object
| Default:      3
| Legal Values: > 1
|		
| Description:  This attribute specifies the dimensionality of the location
|               vertices.  A dimension of 2 would imply a 2D space with
|               locations specified in x and y.  A dimension size of 3
|               would imply a 3D space with locations specified in x,
|               y, and z.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_LOCATION_SIZE		"geomLocationSize"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_MAP
| Type:		kaddr * map
| Category:     object
| Default:      
| Legal Values: 
|		
| Description:  This attribute is the object's colormap.  It will
|               consist of a number of color vectors where the number
|               of vectors is determined by the
|               .symbol index KGEOM_MAP_LENGTH 
|               attribute and the color vector length is determined by the
|               .symbol noindex KGEOM_COLORSPACE 
|               and 
|               .symbol noindex KGEOM_HAS_ALPHA 
|               attributes.  The data type of the map is determined by the 
|               .symbol noindex KGEOM_COLOR_DATA_TYPE 
|               attribute.  If this attribute has not yet been set on
|               a data object, calls to \f(CWkgeom_get_attribute\fP
|               will be unable to retrieve the attribute.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_MAP                	"geomMap"

#define KGEOM_MAPPING_MODE 		KPDS_MAPPING_MODE

/*------------------------------------------------------------------------
| Attribute:	KGEOM_MAP_LENGTH
| Type:	        int map_length
| Category:     object
| Default:      255
| Legal Values: 
|		
| Description:  The value of this attribute specifies the length, or
|               the number of color vectors, in the colormap.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_MAP_LENGTH                "geomMapLength"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_MATRIX
| Type:	        float matrix[16]
| Category:     object
| Default:      
| Legal Values: 
|		
| Description:  This attribute can be used to store a transformation
|		matrix fo the data object.  If this attribute has not 
|		yet been set on a data object, calls to 
|		\f(CWkgeom_get_attribute\fP will be unable
|               to retrieve the attribute.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_MATRIX                    "geomMatrix"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_METAL
| Type:		double metal
| Category:     object
| Default:      0.0
| Legal Values: 0.0 < 1.0 
|		
| Description:	The metalness attribute is a real number between 
|		0.0 and 1.0 where 0.0 implies that the specular
|               reflectance is equal to the light color,
|               and 1.0 implies that the 
|               specular reflectance is equal to the object color. 
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_METAL			"metal"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_MODELING_SPACE
| Type:		double mspace
| Category:     object
| Default:      KWORLD_SPACE
| Legal Values: KWORLD_SPACE
|               KNDC_SPACE
| Description:	The modeling space attribute defines the coordinate space
|		in which the location data is defined.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_MODELING_SPACE		"modelingSpace"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_NAME
| Type:		char * name
| Category:     object
| Default:      NULL
| Legal Values: 
|               
| Description:	The value of this attribute is a null terminated string.
|
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_NAME			"objectName"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_NORMAL_DATA_TYPE
| Type:		int datatype
| Category:     object
| Default:      KFLOAT
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG               
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
|		
| Description:  These data type attributes specify the numerical
|               representation of normal vertex data.
|               .br
|               When the application programmer specifies a
|               presentation data type different than the actual data
|               type of the stored data, the get functions will cast
|               the data to return the requested data type.  The put
|               functions "put" the data type as it is currently
|               specified.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_NORMAL_DATA_TYPE		"geomNormalDataType"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_OPACITY
| Type:		double opacity
| Category:     object
| Default:      1.0
| Legal Values: 0.0 < 1.0 
|		
| Description:	The opacity attribute is a real number between 
|		0.0 and 1.0 where 0.0 implies that the object
|               is completely transparent.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_OPACITY			"opacity"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_RADIUS_DATA_TYPE
| Type:		int datatype
| Category:     object
| Default:      KFLOAT
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG               
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
|		
| Description:  These data type attributes specify the numerical
|               representation of radius data.
|               .br
|               When the application programmer specifies a
|               presentation data type different than the actual data
|               type of the stored data, the get functions will cast
|               the data to return the requested data type.  The put
|               functions "put" the data type as it is currently
|               specified.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_RADIUS_DATA_TYPE		"geomRadiusDataType"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_SPECULAR_COEFFICIENT
| Type:		double spec_coef
| Category:     object
| Default:      0.25
| Legal Values: 0.0 < 1.0 
|		
| Description:	The specular coefficient is a real number between 
|		0.0 and 1.0 where 0.0 implies no specular reflection.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_SPECULAR_COEFFICIENT   	"specularCoefficient"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_SPECULAR_EXPONENT
| Type:		double spec_exp
| Category:     object
| Default:      10.0
| Legal Values: 0.0 < 200.0 
|		
| Description:	The specular exponent attribute is a real number 
|		between 0.0 and 200.0 where 0.0 implies a rough surface.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_SPECULAR_EXPONENT		"specularExponent"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_TEXTURE_COORD_DATA_TYPE
| Type:		int datatype
| Category:     object
| Default:      KFLOAT
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG               
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
|		
| Description:  These data type attributes specify the numerical
|               representation of texture coordinate vertex data.
|               .br
|               When the application programmer specifies a
|               presentation data type different than the actual data
|               type of the stored data, the get functions will cast
|               the data to return the requested data type.  The put
|               functions "put" the data type as it is currently
|               specified.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_TEXTURE_COORD_DATA_TYPE	"geomTextureCoordDataType"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_TEXTURE_COORD_SIZE
| Type:		int size
| Category:     object
| Default:      2
| Legal Values: > 1
|		
| Description:  This attribute specifies the dimensionality of the texture
|               coordinate vertices.  A dimension of 2 would imply a 2D 
|               space with locations specified in u and v.  A dimension 
|               size of 3 would imply a 3D space with locations specified 
|               in u, v, and w.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_TEXTURE_COORD_SIZE	"geomTextureCoordSize"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_VISIBLE
| Type:		int visible
| Category:     object
| Default:      TRUE
| Legal Values: TRUE 
|               FALSE
|		
| Description:	The boolean attribute is a flag which specifies whether
|		the object is visible or not.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_VISIBLE	        	"visible"


/*------------------------------------------------------------------------
| Attribute:	KGEOM_PRIMITIVE_LIST
| Type:		int * primlist
| Category:     list
| Default:      
| Legal Values: 
|		
| Description:	The primitive list is an array of primitive types as 
|               defined in Table 1. This is simply the list of the 
|               types of primitives contained inside the data object.
| 		Before accessing this attribute on an input object,
|		the existence of the primitive list should be ascertained
|		with the \f(CWkgeom_query_primitive_list()\fP function.
| 		Before setting this attribute on an output object,
|		the primitive list must be created with the 
|		\f(CWkgeom_create_primitive_list()\fP function.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_PRIMITIVE_LIST		"geomPrimitiveList"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_NUMBER_PRIMITIVES
| Type:		int numprims
| Category:     list
| Default:      
| Legal Values: 
|		
| Description:	This attribute specifies how many primitives are
|               stored in the data object; i.e. it is the size of the
|		primitive list. 
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_NUMBER_PRIMITIVES		"geomNumberPrimitives"

/*------------------------------------------------------------------------
| Attribute:	KGEOM_PRIMITIVE_POSITION
| Type:		int position
| Category:     list
| Default:      
| Legal Values: 
|		
| Description:	This attribute specifies the position in the primitive 
|               list which is currently being acceessed.  Its value ranges
|		from 0 to 
|	        .symbol noindex KGEOM_NUMBER_PRIMITIVES
|	        - 1.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KGEOM_PRIMITIVE_POSITION	"geomPrimitivePosition"

/* Mesh Attributes */ 
#define KGEOM_OCTMESH_SIZE           		"geomOctmeshize"
#define KGEOM_OCTMESH_LOCATION_POSITION       	"geomOctmeshLocationPosition"
#define KGEOM_OCTMESH_COLOR_POSITION  		"geomOctmeshColorPosition"
#define KGEOM_OCTMESH_NORMAL_POSITION           "geomOctmeshNormalPosition"
#define KGEOM_OCTMESH_TEXTURE_COORD_POSITION    "geomOctmeshTCoordPosition"

#define KGEOM_QUADMESH_SIZE           		"geomQuadmeshSize"
#define KGEOM_QUADMESH_LOCATION_POSITION        "geomQuadmeshLocationPosition"
#define KGEOM_QUADMESH_COLOR_POSITION  	      	"geomQuadmeshColorPosition"
#define KGEOM_QUADMESH_NORMAL_POSITION        	"geomQuadmeshNormalPosition"
#define KGEOM_QUADMESH_TEXTURE_COORD_POSITION 	"geomQuadmeshTCoordPosition"

#define KGEOM_MESH_TYPE                 KPDS_LOCATION_GRID


/* Texture Attributes */ 
#define KGEOM_TEXTURE2D_SIZE       	"geomTexture2DSize"
#define KGEOM_TEXTURE2D_POSITION       	"geomTexture2DPosition"
#define KGEOM_TEXTURE3D_SIZE       	"geomTexture3DSize"
#define KGEOM_TEXTURE3D_POSITION       	"geomTexture3DPosition"


/* Geometry Primitive Attributes */
#define KGEOM_NUMBER_VERTICES     	"geomNumberVertices"
#define KGEOM_LINE_TYPE     		"geomLineType"
#define KGEOM_LINE_WIDTH    		"geomLineWidth"
#define KGEOM_TEXTURE    		"geomTexture"
#define KGEOM_MESH_TEXTURE    		"geomMeshTexture"
#define KGEOM_MARKER_TYPE		"geomMarkerType"

/* ################################################################## */

/*
 * defines for the different modeling types
 */
#define KWORLD_SPACE 	0
#define KNDC_SPACE 	1

/*
 * defines for different layouts 
 */
#define KPER_VERTEX 	0
#define KPER_LINE 	1
#define KPER_FACE 	2
#define KPER_CELL 	3

/* 
 * defines for view parameters.
 */
#define KPROJECTION_PERSPECTIVE 0
#define KPROJECTION_PARALLEL    1

/* ################################################################## */

	/*
	 *  Attribute DEFAULT VALUES 
	 */

/* Polymorphic Attributes */
#define KGEOM_COMMENT_DEFAULT            NULL
#define KGEOM_DATE_DEFAULT               NULL
#define KGEOM_FORMAT_DEFAULT             KVIFF
#define KGEOM_HISTORY_DEFAULT            NULL
#define KGEOM_NAME_DEFAULT               NULL


/* Data Types */
#define KGEOM_LOCATION_DATA_TYPE_DEFAULT        KFLOAT
#define KGEOM_COLOR_DATA_TYPE_DEFAULT           KFLOAT
#define KGEOM_RADIUS_DATA_TYPE_DEFAULT          KFLOAT
#define KGEOM_TEXTURE_COORD_DATA_TYPE_DEFAULT   KFLOAT
#define KGEOM_NORMAL_DATA_TYPE_DEFAULT		KFLOAT


/* General GEOM OBJECT Attributes */
#define KGEOM_AMBIENT_DEFAULT			0.25
#define KGEOM_DIFFUSE_DEFAULT           	0.5 
#define KGEOM_LOCATION_SIZE_DEFAULT     	3 
#define KGEOM_LAYOUT_DEFAULT			KPER_VERTEX
#define KGEOM_METAL_DEFAULT             	0.0 
#define KGEOM_MODELING_SPACE_DEFAULT           	KWORLD_SPACE
#define KGEOM_OPACITY_DEFAULT           	1.0 
#define KGEOM_SPECULAR_COEFFICIENT_DEFAULT	0.25 
#define KGEOM_SPECULAR_EXPONENT_DEFAULT		10.0
#define KGEOM_TEXTURE_COORD_SIZE_DEFAULT	2
#define KGEOM_VISIBLE_DEFAULT          		TRUE 
#define KGEOM_TEXTURE_DEFAULT			NULL

/* Primitive List */
#define KGEOM_PRIMITIVE_LIST_DEFAULT            NULL
#define KGEOM_PRIMITIVE_POSITION_DEFAULT        0 
#define KGEOM_NUMBER_PRIMITIVES_DEFAULT         0 


/* Meshes and Textures */
#define KGEOM_SIZE_DEFAULT			0
#define KGEOM_POSITION_DEFAULT			0

/* Meshes */
#define KGEOM_OCTMESH_SIZE_DEFAULT      	KGEOM_SIZE_DEFAULT
#define KGEOM_QUADMESH_SIZE_DEFAULT     	KGEOM_SIZE_DEFAULT
#define KGEOM_OCTMESH_POSITION_DEFAULT      	KGEOM_POSITION_DEFAULT
#define KGEOM_QUADMESH_POSITION_DEFAULT      	KGEOM_POSITION_DEFAULT

#define KGEOM_MESH_TYPE_DEFAULT                 KCURVILINEAR

/* Textures  */
#define KGEOM_TEXTURE2D_SIZE_DEFAULT		KGEOM_SIZE_DEFAULT
#define KGEOM_TEXTURE3D_SIZE_DEFAULT		KGEOM_SIZE_DEFAULT
#define KGEOM_TEXTURE2D_POSITION_DEFAULT	KGEOM_POSITION_DEFAULT
#define KGEOM_TEXTURE3D_POSITION_DEFAULT	KGEOM_POSITION_DEFAULT


/* Specific Primitive Attributes */
#define KGEOM_NUMBER_VERTICES_DEFAULT   	0 
#define KGEOM_LINE_TYPE_DEFAULT                 1
#define KGEOM_LINE_WIDTH_DEFAULT                1
#define KGEOM_TEXTURE_TYPE_DEFAULT              NULL
#define KGEOM_MARKER_TYPE_DEFAULT               1


/* Colorspace and Autocolor Defaults */
#define KGEOM_COLORSPACE_DEFAULT         KRGB
#define KGEOM_HAS_ALPHA_DEFAULT          FALSE

/* Map Attributes Defaults */
#define KGEOM_MAP_COMPLEX_CONVERT_DEFAULT    	KREAL
#define KGEOM_MAP_DATA_TYPE_DEFAULT          	KUBYTE
#define KGEOM_MAP_INTERPOLATE_DEFAULT   	KPAD
#define KGEOM_MAP_NORM_MAX_DEFAULT       	1
#define KGEOM_MAP_NORM_MIN_DEFAULT       	0
#define KGEOM_MAP_PAD_VALUE_DEFAULT      	0.0
#define KGEOM_MAP_POSITION_DEFAULT       	0
#define KGEOM_MAP_SCALING_DEFAULT        	KNONE
#define KGEOM_MAP_SCALE_FACTOR_DEFAULT   	1.0
#define KGEOM_MAP_SCALE_OFFSET_DEFAULT   	0.0
#define KGEOM_MAP_SIZE_DEFAULT           	1


/* ################################################################## */


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

extern int
   KGEOM_EINTERNAL,
   KGEOM_ELIMITATION,
   KGEOM_EINTERNAL_GET_ATTRIBUTES,
   KGEOM_EINTERNAL_SET_ATTRIBUTES,
   KGEOM_ENO_PRIMITIVE_LIST,
   KGEOM_EFAILED_PRIMITIVE_LIST_SET,
   KGEOM_ENULL_PRIMITIVE_LIST_PROVIDED,
   KGEOM_EINVALID_NUMBER_PRIMITIVES,
   KGEOM_EINVALID_PRIMITIVE_POSITION,
   KGEOM_EUNABLE_TO_ESTABLISH_PRIMITIVE,
   KGEOM_EPRIMITIVE_REDEFINED,
   KGEOM_EPRIMITIVE_NO_DEFINITION,
   KGEOM_EPRIMITIVE_NO_MATCH_POSITION,
   KGEOM_EINVALID_PRESENTATION,
   KGEOM_EUNABLE_TO_PROVIDE_PRESENTATION,
   KGEOM_EMUST_PROVIDE_PRESENTATION_HANDLER,
   KGEOM_EMISSING_REQUIRED_COMPONENT,
   KGEOM_EINVALID_PRIMITIVE,
   KGEOM_EOBJ_INVALID,
   KGEOM_ERECREATE_QUADMESH,
   KGEOM_ERECREATE_OCTMESH,
   KGEOM_ERECREATE_TEXTURE2D,
   KGEOM_ERECREATE_TEXTURE3D,
   KGEOM_ERECREATE_MAP,
   KGEOM_EHAS_QUADMESH,
   KGEOM_EHAS_OCTMESH,
   KGEOM_EHAS_TEXTURE2D,
   KGEOM_EHAS_TEXTURE3D,
   KGEOM_ENO_QUADMESH,
   KGEOM_ENO_OCTMESH,
   KGEOM_ENO_TEXTURE2D,
   KGEOM_ENO_TEXTURE3D,
   KGEOM_ENO_MAP;


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


/************************************************************
*
*  Routine Name: kgeom_close_object - close a data object.
*
*       Purpose: This function is called on an object when all
*		 interaction with the object is completed.
*		 In addition to freeing resources that were
*		 used to manage the object, this function also
*		 will write out the data and attributes of an
*		 output object to its permanent transport. 
*
*         Input: object - the object to be closed
*
*        Output: 
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions:
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 16, 1993 17:22
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kgeom_close_object(
*		!   kobject object)
*
*************************************************************/

#define kgeom_close_object(object) \
	(KGEOM_INIT ? kdms_close(object) : FALSE)

/************************************************************
*
*  Routine Name: kgeom_copy_data - copy all the data from
*                one data object to another.
*
*       Purpose: kgeom_copy_data is part of Geometry Data Services.
*                This function copies all the data associated with
*                source_object to the destination_object.  This means
*                that all the data will be copied not just the value,
*                mask and map data.  For example, the source object may
*                contain data that one of the other services (geometry,
*                numerical, etc.) use.  These will also be copied.
*
*                This routine will create all the data in the
*                destination_object that do not exist.  It will
*                initialize some of the presentation and physical
*                attributes to those of the copied data.  It will
*                remove and replace any source object that already
*                exist in the destination object.  In this case, the
*                copy will not change the physical attributes of the
*                data, but will automatically translate the data.
*                For example, if the original size of the
*                data in the destination_object is different than the
*                size in the source_object then subsampling or
*                supersampling will be performed to resize the data
*                so that it fits.
*
*                Geometry Services attempts to minimize the number of
*                attributes that are copied with the data, as there
*                is another function for that purpose (kgeom_copy_attributes).
*                However, as mentioned above, there are cases when it
*                is necessary to copy certain attributes that are
*                critical to the interpretation of the data.  However,
*                this will only occur when the destination does not
*                have the data being copied.
*
*         Input: source_object - the object that serves as a source
*                                for the data.
*
*        Output: destination_object - the object that will serve as
*                                     a destination in the copy
*                                     operation.
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions:
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 20, 1993 14:28
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kgeom_copy_data(
*               !   kobject source_object,
*               !   kobject destination_object)
*
*************************************************************/

#define kgeom_copy_data(source, destination) \
    (KGEOM_INIT ? kdms_copy_object(source,destination,TRUE,TRUE) : FALSE)

/************************************************************
*
*  Routine Name: kgeom_create_attribute - create an attribute
*                associated the data object.
*
*       Purpose: kgeom_create_attribute is part of Geometry Data Services.
*                The purpose of this routine is to provide the programmer
*                with a mechanism for creating attributes that
*                are specific to the program being written.  The attribute
*                created will be associated with the data object
*                itself and not with the value, mask or map data.
*
*                The second argument to this function is the name
*                of the attribute to be created.  If the attribute
*                specified already exists then this function will
*                return FALSE.
*
*                The type argument indicates the data type of all the
*                elements associated with the attribute.  It
*                take on any of the following values: KBIT, KUBYTE,
*                KBYTE, KUSHORT, KSHORT, KUINT, KINT, KULONG, KLONG,
*                KFLOAT, KDOUBLE, KCOMPLEX, or KDCOMPLEX.  Any other
*                value is considered illegal.  Passing this argument
*                with an illegal value will force this function to
*                return FALSE.
*
*                The num argument indicates how many of elements of
*                the type "type" will be contained in the attribute.
*                This information is necessary so that Geometry Services
*                can allocate sufficient memory to store the attribute.
*                A negative or 0 value passed in will force this function to
*                return FALSE.
*
*                The length argument indicates the size of each element,
*                i.e. you could be passing in a pointer to an array of
*                integers or several arrays if num greater than 1.
*                This information is necessary so that Geometry Services
*                can allocate sufficient memory to store the attribute.
*                This argument specifies the length of the array that
*                needs to be allocated.  A negative or 0 value passed in
*                will force this function to return FALSE.
*
*                The last argument, permanence indicates whether the
*                attribute should be saved when the data object is
*                closed and being stored in a permanent transport.  It
*                should be set to TRUE if the attribute is permanent
*                and FALSE if the attribute is transient.
*
*        Input:  object     - the object that will acquire the new attribute.
*                name       - the name of the attribute to create.
*                num        - number of elements in the attribute.
*                length     - number of elements being passed in per
*                             attribute.
*                type       - the data type for all the elements
*                             of the attribute.
*                permanent  - TRUE if the attribute should be saved
*                             with the object when it is closed.
*                shared     - TRUE if changes to the attribute should
*                             be seen by all reference objects.
*
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: The length variable indicates the length of all
*                the attribute elements.  If different size length
*                are desired, different attributes must be created.
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 20, 1993 13:22
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kgeom_create_attribute(
*               !   kobject object,
*               !   char *name,
*               !   int num,
*               !   int length,
*               !   int type,
*               !   int permanence,
*		!   int shared)
*
*************************************************************/

#define kgeom_create_attribute(object,name,num,length,type,permanent,shared) \
 (KGEOM_INIT ? kdms_create_attribute(object,KDMS_OBJECT,name,num,length,type,permanent,shared) : FALSE)

/************************************************************
*
*  Routine Name: kgeom_destroy_attribute - destroy an attribute
*                associated with the data object.
*
*       Purpose: kgeom_destroy_object_attr is part of Geometry Data Services.
*                The purpose of this routine is to provide the programmer
*                with a mechanism for deleting attributes that
*                were previously created with a call to 
*                kgeom_create_object_attr.
*
*                The name argument specifies the name of the
*                attribute to be destroyed.  If the specified
*                attribute does not exist, or cannot be destroyed
*                (i.e. it makes no sense to destroy the KGEOM_COMPLEX_CONVERT
*                attribute), then this function will return
*                FALSE.
*
*        Input:  object   - the object that contains the attribute.
*                name     - the name of the attribute to destroy.
*
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions:
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 20, 1993 13:04
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kgeom_destroy_attribute(
*               !   kobject source_object,
*               !   char *name)
*
*************************************************************/

#define kgeom_destroy_attribute(source, name) \
 (KGEOM_INIT ? kdms_destroy_attribute(source, KDMS_OBJECT, name) : FALSE)

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* geometry.c */
kobject kgeom_open_object            PROTO((char *, int));
kobject kgeom_open_input_object      PROTO((char *));
kobject kgeom_open_output_object     PROTO((char *));
kobject kgeom_create_object          PROTO((void));
int     kgeom_get_data               PROTO((kobject, int, kvalist ));
int     kgeom_put_data               PROTO((kobject, int, kvalist ));
int     kgeom_set_attribute          PROTO((kobject, int, char *, kvalist ));
int     kgeom_set_attributes         PROTO((kobject, int, kvalist ));
int     kgeom_get_attribute          PROTO((kobject, int, char *, kvalist ));
int     kgeom_get_attributes         PROTO((kobject, int, kvalist ));
int     kgeom_create_primitive_list  PROTO((kobject));
int     kgeom_query_primitive_list   PROTO((kobject));
int     kgeom_destroy_primitive_list PROTO((kobject));
int     kgeom_copy_attributes        PROTO((kobject, kobject));

/* geom_list.c */
int     kgeom_define_primitive       PROTO((int, char *, int, kvalist));
int     kgeom_undefine_primitive     PROTO((int));
char   *kgeom_primitive_name         PROTO((int));


#endif /* _kappserv_kgeometry_h_ */
/* Don't add after this point */
