#! /bin/sh

object_name="kunmask"
file_name="test1.sh"

echo "running "$file_name" for "$object_name" ... process ($$)"


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  byte value replace 
# ------------------------------------------------------------------------
test_num=1
descr="byte value replace"
kunmask -i $dpath/3x4masked.byte.viff -o $tmpdir/out.$$ -real 39 -replace
report $test_num "$tmpdir/out.$$" "test1.results/2x3unmasked.byte.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2:  float value replace 
# ------------------------------------------------------------------------
test_num=2
descr="float value replace"
kunmask -i $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -real 32.3 -replace
report $test_num "$tmpdir/out.$$" "test1.results/4x2masked.float.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  float value propagate 
# ------------------------------------------------------------------------
test_num=3
descr="float value propagate"
kunmask -i $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -prop
report $test_num "$tmpdir/out.$$" "test1.results/4x2prop.float.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  4:  integer value replace (with map)
# ------------------------------------------------------------------------
test_num=4
descr="integer value replace (with map)"
kunmask -i $dpath/2x3ival_mask_6x3fmap.viff -o $tmpdir/out.$$ -real 37 -replace
report $test_num "$tmpdir/out.$$" "test1.results/2x3unmasked.with.map" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  5:  no value data propagate 
# ------------------------------------------------------------------------
test_num=5
descr="no value data propagate"
kunmask -i $dpath/2x3mask.byte.viff -o $tmpdir/out.$$ -prop
report $test_num "$tmpdir/out.$$" "test1.results/2x3mask.prop" "$descr"
/bin/rm -f $tmpdir/out.$$ 

# ------------------------------------------------------------------------
# Test  6:  output mask to different object
# ------------------------------------------------------------------------
test_num=6a
descr1="output mask to different object's mask"
descr2="propagate input with output mask to mask"
kunmask -i $dpath/4x2masked.float.viff -o $tmpdir/out2.$$ -prop -omask $tmpdir/out1.$$ -mask
report $test_num "$tmpdir/out1.$$" "test1.results/4x2omask" "$descr1"
test_num=6b
report $test_num "$tmpdir/out2.$$" "test1.results/4x2prop.float.viff" "$descr2"
/bin/rm -f $tmpdir/out1.$$ $tmpdir/out2.$$

# ------------------------------------------------------------------------
# Test  7:  output mask to different object
# ------------------------------------------------------------------------
test_num=7a
descr1="output mask to different object's value"
descr2="propagate input with output mask to value"
kunmask -i $dpath/4x2masked.float.viff -o $tmpdir/out2.$$ -prop -omask $tmpdir/out1.$$ -val
report $test_num "$tmpdir/out1.$$" "test1.results/4x2ovalue" "$descr1"
test_num=7b
report $test_num "$tmpdir/out2.$$" "test1.results/4x2prop.float.viff" "$descr2"
/bin/rm -f $tmpdir/out1.$$ $tmpdir/out2.$$

# ------------------------------------------------------------------------
# Test  8:  complex value replace
# ------------------------------------------------------------------------
test_num=8
descr="complex value replace" 
kunmask -i $dpath/4x3cmplx.masked.viff -o $tmpdir/out.$$ -real 69 -imag 96 -replace 
report $test_num "$tmpdir/out.$$" "test1.results/4x3masked.complex.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  9:  complex data using objects attributes (use original)
# ------------------------------------------------------------------------
test_num=9
descr="complex data using objects attributes (use original)"

ksetdattr -i $dpath/4x3cmplx.masked.viff -o $tmpdir/out.$$ -maskpres 0 
kunmask -i $tmpdir/out.$$ -o $tmpdir/out.$$ -attr
report $test_num "$tmpdir/out.$$" "test1.results/4x3mc.attr.orig" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test 10:  complex data use object attributes (subst 10.2, -5.7)
# ------------------------------------------------------------------------
test_num=10
descr="complex data use object attributes (subst 10.2, -5.7)"

ksetdattr -i $dpath/4x3cmplx.masked.viff -o $tmpdir/out.$$ -maskpres 1 -rmasksub 10.2 -imasksub -5.7
kunmask -i $tmpdir/out.$$ -o $tmpdir/out.$$ -attr
report $test_num "$tmpdir/out.$$" "test1.results/4x3mc.attr.sub" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run from command line
# ksetdattr -i ~/datamanip/data/testdata/4x3cmplx.masked.viff -o junk1 -maskpres 1 -rmasksub 10.2 -imasksub -5.7
# kunmask -i junk1 -o junk2

exit $status
