#! /bin/sh

echo "running test2.sh for kresample ... process ($$)"

# 8-29-94 - changed tolerance on test 1 from 1e-5 to 1e-3
# 8-29-94 - changed tolerance on test 2, 4, 5 from 1e-5 to 1e-4
# 8-29-94 - changed tolerance on test 3 from 1e-5 to 1e-2 (yech! but the output 
#           of kresample is identical on different systems.  kstats sucks!)
# See discussion in header of karith2/test2.sh. - dk


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
tolerance="$5"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tolerance" -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/images"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  mandril.254.xv, -wmag .5 -hmag .5, compare stats
# ------------------------------------------------------------------------
test_num=1
descr="mandril.254.xv, -wmag .5 -hmag .5, compare stats"
kresample -i $dpath/mandril.254.xv -o $tmpdir/out.$$ -wmag .5 -hmag .5
kstats -i $tmpdir/out.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/stats-mandril.254_w.5h.5" "$descr" "1e-3"
/bin/rm -f $tmpdir/out.$$ $tmpdir/stats.$$

# ------------------------------------------------------------------------
# Test  2:  mandril.254.xv, wmag and hmag = .33333333333, compare stats
# ------------------------------------------------------------------------
test_num=2
descr="mandril.254.xv, wmag and hmag = .33333333333, compare statistics"
kresample -i $dpath/mandril.rgb.xv -o $tmpdir/out.$$ -wmag .33333333333 -hmag .33333333333
kstats -i $tmpdir/out.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/stats-mandril.rgb.33333333333" "$descr" "1e-4"
/bin/rm -f $tmpdir/out.$$ $tmpdir/stats.$$

# to run from command line
# kresample -i ~/khoros_core/data/images/mandril.rgb.xv -o junk -wmag .33333333333 -hmag .33333333333
# kstats -i junk -o stats
# ksegcmp -i1 stats -i2 test2.results/stats-mandril.rgb.33333333333

# ------------------------------------------------------------------------
# Test  3:  head.xv, -wc 27 -hc 60 -wmag 2 -hmag 3 -resize 0, compare stats
# ------------------------------------------------------------------------
test_num=3
descr="head.xv, -wc 27 -hc 60 -wmag 2 -hmag 3 -resize 0, compare stats"
kresample -i $dpath/head.xv -o $tmpdir/out.$$ -wc 27 -hc 60 -wmag 2 -hmag 3 -resize 0
kstats -i $tmpdir/out.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/stats-head_wc27hc60w2h3resize0" "$descr" "1e-2"
/bin/rm -f $tmpdir/out.$$ $tmpdir/stats.$$

# ------------------------------------------------------------------------
# Test  4:  head.xv, -wmag .5 -hmag .5, compare stats
# ------------------------------------------------------------------------
test_num=4
descr="head.xv, -wmag .5 -hmag .5, compare stats"
kresample -i $dpath/head.xv -o $tmpdir/out.$$ -wmag .5 -hmag .5 
kstats -i $tmpdir/out.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/stats-head_w.5h.5" "$descr" "1e-4"
/bin/rm -f $tmpdir/out.$$ $tmpdir/stats.$$
# to run from command line
# kresample -i ~/khoros_core/data/images/head.xv -o junk -wmag .5 -hmag .5

# ------------------------------------------------------------------------
# Test  5:  head.xv, -wmag .2 -hmag .2, compare stats
# ------------------------------------------------------------------------
test_num=5
descr="head.xv, -wmag .2 -hmag .2, compare stats"
kresample -i $dpath/head.xv -o $tmpdir/out.$$ -wmag .2 -hmag .2 
kstats -i $tmpdir/out.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/stats-head_w.2h.2" "$descr" "1e-4"
/bin/rm -f $tmpdir/out.$$ $tmpdir/stats.$$
# to run from command line
# kresample -i ~/khoros_core/data/images/head.xv -o junk -wmag .2 -hmag .2

exit $status
