#! /bin/sh

echo "running test1.sh for kresample ... process ($$)"


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  3x4 double, width and time factors 2
# ------------------------------------------------------------------------
test_num=1
descr="3x4 double, width and height factors 2"
kresample -i $dpath/3x4.double.viff -o $tmpdir/out.$$ -wmag 2 -tmag 2
report $test_num "$tmpdir/out.$$" "test1.results/3x4dv_w2_t2" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kresample -i ~/datamanip/data/testdata/3x4.double.viff -o junk -wmag 2 -tmag 2

# ------------------------------------------------------------------------
# Test  2:  3x4 int, width, height, elements factors 2
# ------------------------------------------------------------------------
test_num=2
descr="3x4 int, width, height, elements factors 2"
kresample -i $dpath/3x4.int.viff -o $tmpdir/out.$$ -wmag 2 -hmag 2 -emag 2
report $test_num "$tmpdir/out.$$" "test1.results/3x4iv_w2_h2_e2" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kresample -i ~/datamanip/data/testdata/3x4.int.viff -o junk -wmag 2 -hmag 2 -emag 2

# ------------------------------------------------------------------------
# Test  3:  4x2masked.float.viff wmag=hmag=dmag=tmag=emag=3
# ------------------------------------------------------------------------
test_num=3
descr="4x2masked.float.viff wmag=hmag=dmag=tmag=emag=3"
kresample -i $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -wmag 3 -hmag 3 -dmag 3 -tmag 3 -emag 3
report $test_num "$tmpdir/out.$$" "test1.results/4x2mkfv_factor3" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kresample -i ~/datamanip/data/testdata/4x2masked.float.viff -o junk -wmag 3 -hmag 3 -dmag 3 -tmag 3 -emag 3

# ------------------------------------------------------------------------
# Test  4:  4x2masked.float.viff wmag=hmag=dmag=tmag=emag=2 -resize 0
# ------------------------------------------------------------------------
test_num=4
descr="4x2masked.float.viff wmag=hmag=dmag=tmag=emag=2 -resize 0"
kresample -i $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0
report $test_num "$tmpdir/out.$$" "test1.results/4x2mkfv_factor2_resize0" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kresample -i ~/datamanip/data/testdata/4x2masked.float.viff -o junk -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0

# ------------------------------------------------------------------------
# Test  5:  4x2masked.float.viff wmag=hmag=dmag=tmag=emag=2 -resize 0 -wc 0 -hc 2
# ------------------------------------------------------------------------
test_num=5
descr="4x2masked.float.viff wmag=hmag=dmag=tmag=emag=2 -resize 0 -wc 0 -hc 2"
kresample -i $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0 -wc 0 -hc 2
report $test_num "$tmpdir/out.$$" "test1.results/4x2mkfv_factor2_resize0_w0_h2" "$descr"
/bin/rm -f $tmpdir/out.$$

# to run, use following command line
# kresample -i ~/datamanip/data/testdata/4x2masked.float.viff -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0 -o junk -wc 0 -hc 2

# ------------------------------------------------------------------------
# Test  6:  4x2masked.float.viff wmag=hmag=dmag=tmag=emag=2 -resize 0 -wc 0 -hc 0
# ------------------------------------------------------------------------
test_num=6
descr="4x2masked.float.viff wmag=hmag=dmag=tmag=emag=2 -resize 0 -wc 0 -hc 0"
kresample -i $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0 -wc 0 -hc 0
report $test_num "$tmpdir/out.$$" "test1.results/4x2mkfv_factor2_resize0_w0_h0" "$descr"
/bin/rm -f $tmpdir/out.$$

# to run, use following command line
# kresample -i ~/datamanip/data/testdata/4x2masked.float.viff -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0 -o junk -wc 0 -hc 0

# ------------------------------------------------------------------------
# Test  7:  3x4.int.viff wmag=hmag=dmag=tmag=emag=2 -resize 0 -wc 3 -hc 2
# ------------------------------------------------------------------------
test_num=7
descr="3x4.int.viff wmag=hmag=dmag=tmag=emag=2 -resize 0 -wc 3 -hc 2"
kresample -i $dpath/3x4.int.viff -o $tmpdir/out.$$ -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0 -wc 3 -hc 2
report $test_num "$tmpdir/out.$$" "test1.results/3x4iv_factor2_resize0_w3_h2" "$descr"
/bin/rm -f $tmpdir/out.$$

# to run, use following command line
# kresample -i ~/datamanip/data/testdata/3x4.int.viff -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0 -o junk -wc 3 -hc 2

# ------------------------------------------------------------------------
# Test  8:  3x4.int.viff wmag=hmag=dmag=tmag=emag=2 -resize 0 -center
# ------------------------------------------------------------------------
test_num=8
descr="3x4.int.viff wmag=hmag=dmag=tmag=emag=2 -resize 0 -center"
kresample -i $dpath/3x4.int.viff -o $tmpdir/out.$$ -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0 -center
report $test_num "$tmpdir/out.$$" "test1.results/3x4iv_factor2_resize0_center" "$descr"
/bin/rm -f $tmpdir/out.$$

# to run, use following command line
# kresample -i ~/datamanip/data/testdata/3x4.int.viff -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -resize 0 -center -o junk

# ------------------------------------------------------------------------
# Test  9:  3x4 int, -wmag 2.3 -hmag 1.7
# ------------------------------------------------------------------------
test_num=9
descr="3x4 int, -wmag 2.3 -hmag 1.7"
kresample -i $dpath/3x4.int.viff -o $tmpdir/out.$$ -wmag 2.3 -hmag 1.7
report $test_num "$tmpdir/out.$$" "test1.results/3x4iv_w2.3_h1.7" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kresample -i ~/datamanip/data/testdata/3x4.int.viff -o junk -wmag 2.3 -hmag 1.7


# ------------------------------------------------------------------------
# Test 10:  resample 3x4 int by wmag = 2, then by wmag = .5
# ------------------------------------------------------------------------
test_num=10
descr="resample 3x4 int by wmag = 2, then by wmag = .5"
kresample -i $dpath/3x4.int.viff -o $tmpdir/out.$$ -wmag 2
kresample -i $tmpdir/out.$$ -o $tmpdir/out.$$ -wmag .5
report $test_num "$tmpdir/out.$$" "$dpath/3x4.int.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test 11:  resample 2x3.ival_6x3fm, factors 2, then factor .5
# ------------------------------------------------------------------------
test_num=11
descr="resample 2x3.ival_6x3fm, factors 2, then factors .5"
kresample -i $dpath/2x3ival_6x3fmap.viff -o $tmpdir/out.$$ -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2
kresample -i $tmpdir/out.$$ -o $tmpdir/out.$$ -wmag .5 -hmag .5 -dmag .5 -tmag .5 -emag .5
report $test_num "$tmpdir/out.$$" "$dpath/2x3ival_6x3fmap.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# to run, use following command line
# kresample -i ~/datamanip/data/testdata/2x3ival_6x3fmap.viff -o junk -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2
# kresample -i junk -o junk -wmag .5 -hmag .5 -dmag .5 -tmag .5 -emag .5

# ------------------------------------------------------------------------
# Test 12:  1 point in data set, wmag=hmag=dmag=tmag=emag=2
# ------------------------------------------------------------------------
test_num=12
descr="1 point in data set, wmag=hmag=dmag=tmag=emag=2"
kresample -i $dpath/1pt.float.xv -o $tmpdir/out.$$ -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2
report $test_num "$tmpdir/out.$$" "test1.results/1pt_factor2" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kresample -i ~/datamanip/data/testdata/1pt.float.xv -wmag 2 -hmag 2 -dmag 2 -tmag 2 -emag 2 -o junk

# ------------------------------------------------------------------------
# Test 13:  1 point in data set, wmag=hmag=dmag=tmag=emag=.7
# ------------------------------------------------------------------------
test_num=13
descr="1 point in data set, wmag=hmag=dmag=tmag=emag=.7"
kresample -i $dpath/1pt.float.xv -o $tmpdir/out.$$ -wmag .7 -hmag .7 -dmag .7 -tmag .7 -emag .7
report $test_num "$tmpdir/out.$$" "$dpath/1pt.float.xv" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kresample -i ~/datamanip/data/testdata/1pt.float.xv -wmag .7 -hmag .7 -dmag .7 -tmag .7 -emag .7 -o junk

# ------------------------------------------------------------------------
# Test 14:  w6h5d4t3e2.val.float factors .3333333 except -emag 2
# ------------------------------------------------------------------------
test_num=14
descr="w6h5d4t3e2.val.float factors .3333333 except -emag 2"
kresample -i $dpath/w6h5d4t3e2.val.float.viff -o $tmpdir/out.$$ -wmag .3333333 -hmag .3333333 -dmag .3333333 -tmag .3333333 -emag 2
report $test_num "$tmpdir/out.$$" "test1.results/w6h5d4t3e2_factor.3333333e2" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kresample -i ~/datamanip/data/testdata/w6h5d4t3e2.val.float.viff -wmag .3333333 -hmag .3333333 -dmag .3333333 -tmag .3333333 -emag 2 -o junk

# ------------------------------------------------------------------------
# Test 15:  w4h5d6t3e2.val.float factors .3333333 except -emag 2
# ------------------------------------------------------------------------
test_num=15
descr="w4h5d6t3e2.val.float factors .3333333 except -emag 2"
kaxis -wd -i $dpath/w6h5d4t3e2.val.float.viff -o $tmpdir/out.$$
kresample -i $tmpdir/out.$$ -o $tmpdir/out.$$ -wmag .3333333 -hmag .3333333 -dmag .3333333 -tmag .3333333 -emag 2
report $test_num "$tmpdir/out.$$" "test1.results/w4h5d6t3e2_factor.3333333e2" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kaxis -wd -i ~/datamanip/data/testdata/w6h5d4t3e2.val.float.viff -o w4h5d6t3e2
# kresample -i w4h5d6t3e2 -wmag .3333333 -hmag .3333333 -dmag .3333333 -tmag .3333333 -emag 2 -o junk

exit $status
