#! /bin/sh

# Replace oname and file.sh in the two lines below with the name 
# of the program you are testing and the file name of this test 
# (for example, test1.sh).

object_name="kreal2cmplx"
file_name="test1.sh"

# ---------------------------------------------------------------
# ADD TESTS BETWEEN the  "Add tests below this" and "End of test 
# suite" comment lines (line 60).
# ---------------------------------------------------------------

echo "running "$file_name" for "$object_name" ... process ($$)"

# report utility
# ---------------------------------------------------------------
# Usage:  report  test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output 
# data object ($2) against the correct result ($3), and reports 
# success or failure of the test.  If the result of ksegcmp is 
# false, status is set to 1.
#
# Input Arguments: test_num - test number
#                  test_obj - the object generated by the test
#                  cntrl_obj - known result to compare against
#                  test_descr - a string describing the test
#                  tol - tolerance allowed when comparing object 
#                        data values. Recommended tolerance 1e-5
# ---------------------------------------------------------------
report()
{
   test_num="$1"
   test_obj="$2"
   cntrl_obj="$3"
   test_descr="$4"
   tol="$5"

   ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tol" -sat 1 -s -rt 1 -all
   if [ $? = 0 ]
   then
      echo "Passed:  Test  $test_num --> "$test_descr""
   else
      echo "FAILED:  Test  $test_num --> "$test_descr""
      status=1
   fi
}

# Initialize status to be success (ie. 0).  Upon failure, status 
# is initialized to 1.  Set the tmpdir variable.  Script will 
# use /tmp if $TMPDIR is not defined.
status=0
tmpdir=${TMPDIR:-/tmp}

# ---------------------------------------------------------------
#  Add tests below this
# ---------------------------------------------------------------

# ---------------------------------------------------------------
# test 2
# ---------------------------------------------------------------
 
kreal2cmplx -i1 image:ball -i2 image:moon -o $tmpdir/out.$$
kcmplx2real -i $tmpdir/out.$$ -or $tmpdir/ball.$$ -oi $tmpdir/moon.$$
kconvert -i $tmpdir/ball.$$ -o $tmpdir/ball.$$ -val -type "Unsigned Byte"
kconvert -i $tmpdir/moon.$$ -o $tmpdir/moon.$$ -val -type "Unsigned Byte"
 
test_num=1a
descr="-i1 image:ball -i2 image:moon, testing real part"
report $test_num "$tmpdir/ball.$$" "image:ball" "$descr" "1e-5"
test_num=1b
descr="-i1 image:ball -i2 image:moon, testing imaginary part"
report $test_num "$tmpdir/moon.$$" "image:moon" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ball.$$ $tmpdir/moon.$$
 
# ---------------------------------------------------------------
# test 2
# ---------------------------------------------------------------

test_num=2
descr="combining byte and float into complex"
 
cat <<EOF > $tmpdir/ascii.$$
-1 1
57 -120
36 -18
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type byte -o $tmpdir/real.$$
 
cat <<EOF > $tmpdir/ascii.$$
1 1
57 1e20
65536 1.12345e-38
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type float -o $tmpdir/imag.$$
 
kreal2cmplx -i1 $tmpdir/real.$$ -i2 $tmpdir/imag.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(-1, 1) (1, 1)
(57, 57) (-120, 1e20)
(36, 65536) (-18, 1.12345e-38)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type complex -o $tmpdir/ans.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/real.$$ $tmpdir/imag.$$

# ---------------------------------------------------------------
# test 3
# ---------------------------------------------------------------

cat <<EOF > $tmpdir/ascii.$$
-1 1
57 -120
36 -18
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type byte -o $tmpdir/input.$$
 
# ---------------------------------------------------------------
test_num=3a
descr="only i1, -real 70"
kreal2cmplx -i1 $tmpdir/input.$$ -real 70 -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(-1, 0) (1, 0)
(57, 0) (-120, 0)
(36, 0) (-18, 0)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type complex -o $tmpdir/ans.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
kreal2cmplx -i1 $tmpdir/input.$$ -real 70 -o $tmpdir/out.$$
 
# ---------------------------------------------------------------
test_num=3b
descr="only i1, -imag 70"
kreal2cmplx -i1 $tmpdir/input.$$ -imag 70 -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(-1, 70) (1, 70)
(57, 70) (-120, 70)
(36, 70) (-18, 70)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type complex -o $tmpdir/ans.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
# ---------------------------------------------------------------
test_num=3c
descr="only i2, -real 70"
kreal2cmplx -i2 $tmpdir/input.$$ -real 70 -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(70, -1) (70, 1)
(70, 57) (70, -120)
(70, 36) (70, -18)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type complex -o $tmpdir/ans.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
# ---------------------------------------------------------------
test_num=3d
descr="only i2, -imag 70"
kreal2cmplx -i2 $tmpdir/input.$$ -imag 70 -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(0, -1) (0, 1)
(0, 57) (0, -120)
(0, 36) (0, -18)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type complex -o $tmpdir/ans.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$ $tmpdir/input.$$

# ---------------------------------------------------------------
# test 4
# ---------------------------------------------------------------

cat <<EOF > $tmpdir/ascii.$$
-1 1
57 -120
36 -18
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type byte -o $tmpdir/input.$$
 
# ---------------------------------------------------------------
test_num=4a
descr="test with only i1"
kreal2cmplx -i1 $tmpdir/input.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(-1, 0) (1, 0)
(57, 0) (-120, 0)
(36, 0) (-18, 0)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type complex -o $tmpdir/ans.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
# ---------------------------------------------------------------
test_num=4b
descr="test with only i2"
kreal2cmplx -i2 $tmpdir/input.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(0, -1) (0, 1)
(0, 57) (0, -120)
(0, 36) (0, -18)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type complex -o $tmpdir/ans.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"

/bin/rm -r $tmpdir/input.$$ $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/out.$$

# ---------------------------------------------------------------
# test 5
# ---------------------------------------------------------------
 
test_num=5
descr="i1 is unsigned byte, i2 is double"
 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 3 \
         -type "unsigned byte" -o $tmpdir/input1.$$
 
cat <<EOF > $tmpdir/ascii.$$
-1.1 2.2 -3.3
-4.4 5.5 -6.6
-7.7 8.8 -9.9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 3 \
         -type "double" -o $tmpdir/input2.$$
 
kreal2cmplx -i1 $tmpdir/input1.$$ -i2 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(1, -1.1) (2, 2.2) (3, -3.3)
(4, -4.4) (5, 5.5) (6, -6.6)
(7, -7.7) (8, 8.8) (9, -9.9)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 3 \
         -type "double complex" -o $tmpdir/ans.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/input1.$$ $tmpdir/input2.$$

# ---------------------------------------------------------------
# test 6
# ---------------------------------------------------------------

test_num=6
descr="input1 and input2 have masks"
 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 3 \
         -type "unsigned byte" -o $tmpdir/input1.$$
cat <<EOF > $tmpdir/ascii.$$
1 1 1
1 0 0
1 0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input1.$$ -wsize 1 -hsize 3 \
          -esize 3 -type "unsigned byte" -o $tmpdir/input1.$$
 
cat <<EOF > $tmpdir/ascii.$$
-1.1 2.2 -3.3
-4.4 5.5 -6.6
-7.7 8.8 -9.9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 3 \
         -type "double" -o $tmpdir/input2.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 1
0 0 1
1 1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input2.$$ -wsize 1 -hsize 3 \
          -esize 3 -type "unsigned byte" -o $tmpdir/input2.$$
 
kreal2cmplx -i1 $tmpdir/input1.$$ -i2 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(1, -1.1) (2, 2.2) (3, -3.3)
(4, -4.4) (5, 5.5) (6, -6.6)
(7, -7.7) (8, 8.8) (9, -9.9)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 3 \
         -type "double complex" -o $tmpdir/ans.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 1
0 0 0
1 0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/ans.$$ -wsize 1 -hsize 3 \
          -esize 3 -type "unsigned byte" -o $tmpdir/ans.$$
 
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/input1.$$ $tmpdir/input2.$$

# ---------------------------------------------------------------
# test 7
# ---------------------------------------------------------------

cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 3 -type "unsigned byte" \
         -o $tmpdir/input1.$$
cat <<EOF > $tmpdir/ascii.$$
1 1 1
1 0 0
1 0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input1.$$ -wsize 3 -hsize 3 \
          -type "unsigned byte" -o $tmpdir/input1.$$
 
cat <<EOF > $tmpdir/ascii.$$
-1.1 2.2 -3.3
-4.4 5.5 -6.6
-7.7 8.8 -9.9
11 22 33
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 4 -type "double" \
         -o $tmpdir/input2.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 1
0 0 1
1 1 1
0 1 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input2.$$ -wsize 3 -hsize 4 \
          -type "unsigned byte" -o $tmpdir/input2.$$
 
kreal2cmplx -i1 $tmpdir/input1.$$ -i2 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(1, -1.1) (2, 2.2) (3, -3.3)
(4, -4.4) (5, 5.5) (6, -6.6)
(7, -7.7) (8, 8.8) (9, -9.9)
(0, 11)   (0, 22)  (0, 33)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 4 -type "double complex" \
         -o $tmpdir/ans.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 1
0 0 0
1 0 0
0 1 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/ans.$$ -wsize 3 -hsize 4 \
          -type "unsigned byte" -o $tmpdir/ans.$$
 
test_num=7a
descr="input2 larger than input1, both have masks"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
kreal2cmplx -i2 $tmpdir/input1.$$ -i1 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(-1.1, 1) (2.2, 2) (-3.3, 3)
(-4.4, 4) (5.5, 5) (-6.6, 6)
(-7.7, 7) (8.8, 8) (-9.9, 9)
(11, 0)   (22, 0)  (33, 0)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -i2 $tmpdir/ans.$$ -wsize 3 -hsize 4 \
         -type "double complex" -o $tmpdir/ans.$$
 
test_num=7b
descr="input1 larger than input2, both have masks"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/input1.$$ $tmpdir/input2.$$

# ---------------------------------------------------------------
# test 8
# ---------------------------------------------------------------

cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 3 -type "unsigned byte" \
         -o $tmpdir/input1.$$
cat <<EOF > $tmpdir/ascii.$$
1 1 1
1 0 0
1 0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input1.$$ -wsize 3 -hsize 3 \
          -type "unsigned byte" -o $tmpdir/input1.$$
 
cat <<EOF > $tmpdir/ascii.$$
-1.1 2.2 -3.3
-4.4 5.5 -6.6
-7.7 8.8 -9.9
11 22 33
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 4 -type "double" \
         -o $tmpdir/input2.$$
 
kreal2cmplx -i1 $tmpdir/input1.$$ -i2 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(1, -1.1) (2, 2.2) (3, -3.3)
(4, -4.4) (5, 5.5) (6, -6.6)
(7, -7.7) (8, 8.8) (9, -9.9)
(0, 11)   (0, 22)  (0, 33)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 4 -type "double complex" \
         -o $tmpdir/ans.$$
cat <<EOF > $tmpdir/ascii.$$
1 1 1
1 0 0
1 0 0
1 1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/ans.$$ -wsize 3 -hsize 4 \
          -type "unsigned byte" -o $tmpdir/ans.$$
 
test_num=8a
descr="input2 larger than input1, input1 has mask"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
kreal2cmplx -i2 $tmpdir/input1.$$ -i1 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(-1.1, 1) (2.2, 2) (-3.3, 3)
(-4.4, 4) (5.5, 5) (-6.6, 6)
(-7.7, 7) (8.8, 8) (-9.9, 9)
(11, 0)   (22, 0)  (33, 0)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -i2 $tmpdir/ans.$$ -wsize 3 -hsize 4 \
         -type "double complex" -o $tmpdir/ans.$$
 
test_num=8b
descr="input1 larger than input2, input2 has mask"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/input1.$$ $tmpdir/input2.$$

# ---------------------------------------------------------------
# test 9
# ---------------------------------------------------------------
 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 3 -type "unsigned byte" \
         -o $tmpdir/input1.$$
cat <<EOF > $tmpdir/ascii.$$
1 1 1
1 0 0
1 0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input1.$$ -wsize 3 -hsize 3 \
          -type "unsigned byte" -o $tmpdir/input1.$$
 
kreal2cmplx -i1 $tmpdir/input1.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(1, 0) (2, 0) (3, 0)
(4, 0) (5, 0) (6, 0)
(7, 0) (8, 0) (9, 0)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 3 -type "complex" \
         -o $tmpdir/ans.$$
cat <<EOF > $tmpdir/ascii.$$
1 1 1
1 0 0
1 0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/ans.$$ -wsize 3 -hsize 3 \
          -type "unsigned byte" -o $tmpdir/ans.$$
 
test_num=9a
descr="input1 only, has mask"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
kreal2cmplx -i2 $tmpdir/input1.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(0, 1) (0, 2) (0, 3)
(0, 4) (0, 5) (0, 6)
(0, 7) (0, 8) (0, 9)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -i2 $tmpdir/ans.$$ -wsize 3 -hsize 3 \
         -type "complex" -o $tmpdir/ans.$$
 
test_num=9b
descr="input2 only, has mask"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/input1.$$ 

# ---------------------------------------------------------------
# test 10
# ---------------------------------------------------------------
 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 1 -type "unsigned byte" \
         -o $tmpdir/input1.$$
cat <<EOF > $tmpdir/ascii.$$
0.1 0.2 0.3
1.1 1.2 1.3
2.1 2.2 2.3
3.1 3.2 3.3
4.1 4.2 4.3
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input1.$$ -wsize 3 -hsize 5 \
          -type "double" -o $tmpdir/input1.$$
 
kreal2cmplx -i1 $tmpdir/input1.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(0.1, 0) (0.2, 0) (0.3, 0)
(1.1, 0) (1.2, 0) (1.3, 0)
(2.1, 0) (2.2, 0) (2.3, 0)
(3.1, 0) (3.2, 0) (3.3, 0)
(4.1, 0) (4.2, 0) (4.3, 0)
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input1.$$ -wsize 3 -hsize 5 \
          -type "double complex" -o $tmpdir/ans.$$
 
test_num=10a
descr="input1 only, has map"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
kreal2cmplx -i2 $tmpdir/input1.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(0, 0.1) (0, 0.2) (0, 0.3)
(0, 1.1) (0, 1.2) (0, 1.3)
(0, 2.1) (0, 2.2) (0, 2.3)
(0, 3.1) (0, 3.2) (0, 3.3)
(0, 4.1) (0, 4.2) (0, 4.3)
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input1.$$ -wsize 3 -hsize 5 \
          -type "double complex" -o $tmpdir/ans.$$
 
test_num=10b
descr="input2 only, has map"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/input1.$$

# ---------------------------------------------------------------
# test 11
# ---------------------------------------------------------------
 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 1 -type "unsigned byte" \
         -o $tmpdir/input1.$$
cat <<EOF > $tmpdir/ascii.$$
0.1 0.2 0.3
1.1 1.2 1.3
2.1 2.2 2.3
3.1 3.2 3.3
4.1 4.2 4.3
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/input1.$$ -wsize 3 -hsize 5 \
          -type "double" -o $tmpdir/input1.$$
 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
5 6 7
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type "unsigned byte" \
         -o $tmpdir/input2.$$
 
kreal2cmplx -i1 $tmpdir/input1.$$ -i2 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(1.1, 1) (1.2, 0) (1.3, 0)
(2.1, 2) (2.2, 0) (2.3, 0)
(3.1, 3) (3.2, 0) (3.3, 0)
(0, 5) (0, 0) (0, 0)
(0, 6) (0, 0) (0, 0)
(0, 7) (0, 0) (0, 0)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -esize 3 -windex 2 -hindex 3 \
         -dindex 4 -tindex 5 -eindex 1 -type "double complex" -o $tmpdir/ans.$$
 
test_num=11a
descr="input1 has map and value, input2 has value"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
kreal2cmplx -i2 $tmpdir/input1.$$ -i1 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(1, 1.1) (0, 1.2) (0, 1.3)
(2, 2.1) (0, 2.2) (0, 2.3)
(3, 3.1) (0, 3.2) (0, 3.3)
(5, 0) (0, 0) (0, 0)
(6, 0) (0, 0) (0, 0)
(7, 0) (0, 0) (0, 0)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -esize 3 -windex 2 -hindex 3 \
         -dindex 4 -tindex 5 -eindex 1 -type "double complex" -o $tmpdir/ans.$$
 
test_num=11b
descr="input2 has map and value, input1 has value"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/input1.$$ $tmpdir/input2.$$

# ---------------------------------------------------------------
# test 12
# ---------------------------------------------------------------
 
cat <<EOF > $tmpdir/ascii.$$
0.1 0.2 0.3
1.1 1.2 1.3
2.1 2.2 2.3
3.1 3.2 3.3
4.1 4.2 4.3
EOF
kasc2map -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 5 -type "double" \
         -o $tmpdir/input1.$$
 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
5 6 7
EOF
kasc2map -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type "unsigned byte" \
         -o $tmpdir/input2.$$
 
kreal2cmplx -i1 $tmpdir/input1.$$ -i2 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(0.1, 1) (0.2, 2) (0.3, 3)
(1.1, 5) (1.2, 6) (1.3, 7)
(2.1, 0) (2.2, 0) (2.3, 0)
(3.1, 0) (3.2, 0) (3.3, 0)
(4.1, 0) (4.2, 0) (4.3, 0)
EOF
kasc2map -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 5 -type "double complex" \
         -o $tmpdir/ans.$$
 
test_num=12a
descr="2 inputs, maps only"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
kreal2cmplx -i2 $tmpdir/input1.$$ -i1 $tmpdir/input2.$$ -o $tmpdir/out.$$
 
cat <<EOF > $tmpdir/ascii.$$
(1, 0.1) (2, 0.2) (3, 0.3)
(5, 1.1) (6, 1.2) (7, 1.3)
(0, 2.1) (0, 2.2) (0, 2.3)
(0, 3.1) (0, 3.2) (0, 3.3)
(0, 4.1) (0, 4.2) (0, 4.3)
EOF
kasc2map -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 5 -type "double complex" \
         -o $tmpdir/ans.$$
 
test_num=12b
descr="2 inputs, maps only (inputs switcthed)"
report $test_num "$tmpdir/out.$$" "$tmpdir/ans.$$" "$descr" "1e-5"
 
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ans.$$
/bin/rm -f $tmpdir/input1.$$ $tmpdir/input2.$$
 
# ---------------------------------------------------------------
# other things that need to be tested
# 1 input with location
# 2 input with location (should fail)
# ---------------------------------------------------------------
 
# ---------------------------------------------------------------
#  End of test suite
# ---------------------------------------------------------------

exit $status
