#! /bin/sh
 
echo "running test4.sh for klinearop ... process ($$)"
echo " "
 
# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test outcput data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
 
ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-4 -sat 1  -s -rt 1 -all -cast
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}
 
#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0
 
# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}
bpath=`kecho -tb DATAMANIP -echo path`/bin
tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/"

#------------------------------------------------------------------------
# clean up tmp directory
#------------------------------------------------------------------------
/bin/rm -f $tmpdir/outc.*
/bin/rm -f $tmpdir/const.*

# ------------------------------------------------------------------------
# Test  1: convolution data type Double 2D - time segment present 
# ------------------------------------------------------------------------
test_num=1
descr="convolution 2D - Time" 

kgconst -o $tmpdir/const.$$ -wsize 4 -hsize 4 -real 1 -imag 1 -type 2 

kcpfromval -i $tmpdir/const.$$ -time -o $tmpdir/const.$$ 

kinsertseg -i2 $dpath/images/gull.viff -time -i1 $tmpdir/const.$$ -o $tmpdir/const.$$ 

$bpath/klinearop -i1 $tmpdir/const.$$ -i2 ./testdata/ident2D.viff -w -h -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "$tmpdir/const.$$" "$descr"

/bin/rm -f $tmpdir/outc.$$
/bin/rm -f $tmpdir/const.*

# ------------------------------------------------------------------------
# Test  2: convolution data type Double 2D - map segment present
# ------------------------------------------------------------------------
test_num=2
descr="convolution 2D - MAP"

$bpath/klinearop -i1 $dpath/images/vero.255.xv -i2 ./testdata/ident2D.viff -w -h -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -real 0 -imag 0

kmapdata -i $dpath/images/vero.255.xv -o $tmpdir/map.$$
report $test_num "$tmpdir/outc.$$" "$tmpdir/map.$$" "$descr"

/bin/rm -f $tmpdir/outc.$$
/bin/rm -f $tmpdir/map.$$

# ------------------------------------------------------------------------
# Test  3: convolution data type Double 2D - location segment present 
# ------------------------------------------------------------------------
test_num=3
descr="convolution 2D - Location" 

kgconst -o $tmpdir/const.$$ -wsize 256 -hsize 256 -real 1 -imag 1 -type 3 

kcpfromval -i $tmpdir/const.$$ -loc -o $tmpdir/const.$$ 

kinsertseg -i2 $dpath/images/gull.viff -loc -i1 $tmpdir/const.$$ -o $tmpdir/const.$$ 

$bpath/klinearop -i1 $tmpdir/const.$$ -i2 ./testdata/ident2D.viff -w -h -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "$tmpdir/const.$$" "$descr"

/bin/rm -f $tmpdir/outc.$$
/bin/rm -f $tmpdir/const.*


# ------------------------------------------------------------------------
# Test  4: convolution data type Double 2D XYZ image 
# ------------------------------------------------------------------------
test_num=4
descr="convolution Double 2D - XYZ image"

$bpath/klinearop -i1 $dpath/images/moon.512.pbm -i2 ./testdata/ident2D.viff -w -h -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "$dpath/images/moon.512.pbm" "$descr"

/bin/rm -f $tmpdir/outc.$$

# ------------------------------------------------------------------------
# Test  5: convolution data type Double 2D RGB image 
# ------------------------------------------------------------------------
test_num=5
descr="convolution Double 2D - RGB image"

$bpath/klinearop -i1 $dpath/images/lizard.rgb.xv -i2 ./testdata/ident2D.viff -w -h -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "$dpath/images/lizard.rgb.xv" "$descr"

/bin/rm -f $tmpdir/outc.$$

exit $status
