#! /bin/sh
 
echo "running test3.sh for klinearop ... process ($$)"
echo " "
 
# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test outcput data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
 
ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-4 -sat 1 -s -rt 1 -all -cast
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}
 
#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0
 
# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}
dpath="./testdata"
bpath=`kecho -tb DATAMANIP -echo path`/bin
vdpath=`kecho -tb SAMPLEDATA -echo path`/data/volumes/

#------------------------------------------------------------------------
# clean up tmp directory
#------------------------------------------------------------------------
/bin/rm -f $tmpdir/outc*


# ------------------------------------------------------------------------
# Test  1: Width-convolution data type Double 2D sweet spot w = 0 truncated
# ------------------------------------------------------------------------
test_num=1
descr="width-convolution Double 2D sweet spot w = 0 truncated"

$bpath/klinearop -i1 $dpath/seq2D.ascii -i2 $dpath/kernel1D.ascii  -w -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test3.results/wconv2D_truc_0.ascii" "$descr"
# ------------------------------------------------------------------------
# Test  2: Width-convolution data type Double 2D sweet spot w = 0 extended
# ------------------------------------------------------------------------
test_num=2
descr="width-convolution Double 2D sweet spot w = 0 extended"

$bpath/klinearop -i1 $dpath/seq2D.ascii -i2 $dpath/kernel1D.ascii  -w -o $tmpdir/outc.$$ -flip 0 -size 1 -l -w0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test3.results/wconv2D_ext_0.ascii" "$descr"
# ------------------------------------------------------------------------
# Test  3: Height-convolution data type Double 2D sweet spot w = 0 truncated
# ------------------------------------------------------------------------
test_num=3
descr="height-convolution Double 2D sweet spot w = 0 truncated"

$bpath/klinearop -i1 $dpath/seq2D.ascii -i2 $dpath/kernel1D.ascii -h -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test3.results/hconv2D_truc_0.viff" "$descr"

# ------------------------------------------------------------------------
# Test  4: Height-convolution data type Double 2D sweet spot w = 0 extended
# ------------------------------------------------------------------------
test_num=4
descr="height-convolution Double 2D sweet spot w = 0 extended"

$bpath/klinearop -i1 $dpath/seq2D.ascii -i2 $dpath/kernel1D.ascii -h -o $tmpdir/outc.$$ -flip 0 -size 1 -l -w0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test3.results/hconv2D_ext_0.viff" "$descr"

# ------------------------------------------------------------------------
# Test  5: Height-convolution data type Double 2D sweet spot w = 2 truncated
# ------------------------------------------------------------------------
test_num=5
descr="height-convolution Double 2D sweet spot w = 2 truncated"

$bpath/klinearop -i1 $dpath/seq2D.ascii -i2 $dpath/kernel1D.ascii  -h -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 2 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test3.results/hconv2D_truc_2.viff" "$descr"

 
# ------------------------------------------------------------------------
# Test  6: Height-convolution data type Double 2D sweet spot w = 2 extended
# ------------------------------------------------------------------------
test_num=6
descr="height-convolution Double 2D sweet spot w = 2 extended"

$bpath/klinearop -i1 $dpath/seq2D.ascii -i2 $dpath/kernel1D.ascii -h -o $tmpdir/outc.$$ -flip 0 -size 1 -l -w0 2 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test3.results/hconv2D_ext_2.viff" "$descr"

#------------------------------------------------------------------------
# Test 7: 3D-convolution data type Double sweet spot (0,0,0) truncated
#-------------------------------------------------------------------------
test_num=7
descr="convolution Double 3D sweet spot (0,0,0) truncated"

$bpath/klinearop -i1 $dpath/seq3D.viff -i2 $dpath/kernel3D.viff -w -h -d -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -d0 0 -real 0 -imag 0 -upcast

report $test_num "$tmpdir/outc.$$" "./test3.results/dconv3D_t_000.viff" "$descr"

#------------------------------------------------------------------------
# Test 8: 3D-convolution data type Long byte sweet spot (0,0,0) truncated
#-------------------------------------------------------------------------
test_num=8
descr="convolution Long 3D sweet spot (0,0,0) truncated"

$bpath/klinearop -i1 $dpath/seq3D.viff -i2 $dpath/kernel3D.viff -w -h -d -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -d0 0 -real 0 -imag 0 

report $test_num "$tmpdir/outc.$$" "./test3.results/dconv3D_t_000.viff" "$descr"

#------------------------------------------------------------------------
# Test 9: 3D-convolution data type Double complex sweet spot (0,0,0) truncated
#-------------------------------------------------------------------------
test_num=9
descr="convolution Dcomplex 3D sweet spot (0,0,0) truncated"

kconvert -i $dpath/seq3D.viff -o $tmpdir/seq.$$ -type 13 -val

$bpath/klinearop -i1 $tmpdir/seq.$$ -i2 $dpath/kernel3D.viff -w -h -d -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -d0 0 -real 0 -imag 0 

report $test_num "$tmpdir/outc.$$" "./test3.results/dcconv3D_t_000.viff" "$descr"
/bin/rm -f $tmpdir/seq.$$

#------------------------------------------------------------------------
# Test 10: 3D-convolution data type Unsigned byte sweet spot (0,0,0) truncated
#-------------------------------------------------------------------------
test_num=10
descr="convolution Ubyte 3D sweet spot (0,0,0) truncated"

kconvert -i $dpath/seq3D.viff -o $tmpdir/seq.$$ -type 2 -val
kconvert -i $dpath/kernel3D.viff -o $tmpdir/kernel.$$ -type 2 -val

$bpath/klinearop -i1 $tmpdir/seq.$$ -i2 $tmpdir/kernel.$$ -w -h -d -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -d0 0 -real 0 -imag 0 

report $test_num "$tmpdir/outc.$$" "./test3.results/dconv3D_t_000.viff" "$descr"
/bin/rm -f $tmpdir/seq.$$
/bin/rm -f $tmpdir/kernel.$$
/bin/rm -f $tmpdir/*.$$

#------------------------------------------------------------------------
# Test 11: 3D-convolution data type Double sweet spot (0,0,0) truncated
#          (large set of data)
#-------------------------------------------------------------------------
#test_num=11
#descr="convolution Double 3D sweet spot (0,0,0) truncated (large set)"

#$bpath/klinearop -i1 $vdpath/sagittal.viff -i2 $dpath/kernel3D.viff -w -h -d -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -d0 0 -real 0 -imag 0 -upcast 

#report $test_num "$tmpdir/outc.$$" "$vdpath/sagittal.viff" "$descr"
#/bin/rm -f $tmpdir/*.$$

exit $status


