#! /bin/sh

echo "running test1.sh for kkmeans ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:   3x2x1x1x2 input, 2 clusters (unspecified), no output map
# ------------------------------------------------------------------------
test_num=1
descr="3x2x1x1x2 input, 2 clusters (unspecified), no output map"
cat <<EOF > $tmpdir/ascii.$$
1 2 1
2 4 2
5 5 4
4 3 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -esize 2 -type 11 -o $tmpdir/in1.$$
kkmeans -i1 $tmpdir/in1.$$ -o1 $tmpdir/out1.$$ -k 2 
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type 4 -o $tmpdir/result1.$$
report $test_num "$tmpdir/out1.$$" "$tmpdir/result1.$$" "$descr"
/bin/rm -f $tmpdir/in1.$$ $tmpdir/out1.$$ $tmpdir/result1.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2:   3x2x1x1x2 input, 2 clusters (specified), with output map
# ------------------------------------------------------------------------
test_num=2
descr="3x2x1x1x2 input, 2 clusters (specified), with output map"
cat <<EOF > $tmpdir/ascii.$$
1 2 1
2 4 2
5 5 4
4 3 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -esize 2 -type 11 -o $tmpdir/in1.$$
cat <<EOF > $tmpdir/ascii.$$
3 6
3 6
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -esize 2 -type 11 -o $tmpdir/in2.$$
kkmeans -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o1 $tmpdir/out1.$$ -k 2 -map
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type 4 -o $tmpdir/result1.$$
cat <<EOF > $tmpdir/ascii.$$
1.6 4
4 3
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result1.$$ -wsize 2 -hsize 2 -type 11 -o $tmpdir/result1.$$
report $test_num "$tmpdir/out1.$$" "$tmpdir/result1.$$" "$descr"
/bin/rm -f $tmpdir/in1.$$ $tmpdir/out1.$$ $tmpdir/result1.$$ $tmpdir/ascii.$$
/bin/rm -f $tmpdir/in2.$$ 

# ------------------------------------------------------------------------
# Test  3:   3x2x1x1x2 input, 3 clusters (unspecified), with spectrum map
# ------------------------------------------------------------------------
test_num=3
descr="3x2x1x1x2 input, 3 clusters (unspecified), with spectrum map"
cat <<EOF > $tmpdir/ascii.$$
1 2 1
2 4 2
5 5 4
4 3 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -esize 2 -type 11 -o $tmpdir/in1.$$
kkmeans -i1 $tmpdir/in1.$$ -o1 $tmpdir/out1.$$ -k 3 -spectrum -o2 $tmpdir/out2.$$ -o3 $tmpdir/out3.$$ -o4 $tmpdir/out4.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 1 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type 4 -o $tmpdir/result1.$$
cat <<EOF > $tmpdir/ascii.$$
1.5  4.5  4  0.25  0  0.25  
4  3  1  0  0  0  
2  2  1  0  0  0  
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result1.$$ -wsize 6 -hsize 3 -type 11 -o $tmpdir/result1.$$
report $test_num "$tmpdir/out1.$$" "$tmpdir/result1.$$" "$descr"
/bin/rm -f $tmpdir/in1.$$ $tmpdir/out1.$$ $tmpdir/result1.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  4:   3x2x1x1x2 input, 3 clusters (unspecified), cluster center output
# ------------------------------------------------------------------------
test_num=4
descr="3x2x1x1x2 input, 3 clusters (unspecified), cluster center output"
cat <<EOF > $tmpdir/ascii.$$
1.5 4.5
4 3
2 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 11 -o $tmpdir/result2.$$
report $test_num "$tmpdir/out2.$$" "$tmpdir/result2.$$" "$descr"
/bin/rm -f $tmpdir/out2.$$ $tmpdir/result2.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  5:   3x2x1x1x2 input, 3 clusters (unspecified), cluster variance output
# ------------------------------------------------------------------------
test_num=5
descr="3x2x1x1x2 input, 3 clusters (unspecified), cluster variance output"
cat <<EOF > $tmpdir/ascii.$$
0.5 0.5
0 0
0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 11 -o $tmpdir/result3.$$
report $test_num "$tmpdir/out3.$$" "$tmpdir/result3.$$" "$descr"
/bin/rm -f $tmpdir/out3.$$ $tmpdir/result3.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  6:   3x2x1x1x2 input, 3 clusters (unspecified), cluster membership count output
# ------------------------------------------------------------------------
test_num=6
descr="3x2x1x1x2 input, 3 clusters (unspecified), cluster membership count output"
cat <<EOF > $tmpdir/ascii.$$
4 1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -type 6 -o $tmpdir/result4.$$
report $test_num "$tmpdir/out4.$$" "$tmpdir/result4.$$" "$descr"
/bin/rm -f $tmpdir/out4.$$ $tmpdir/result4.$$ $tmpdir/ascii.$$

exit $status

