#! /bin/sh

echo "running test1.sh for khisto ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  float input, no mask, no map, whole 
# ------------------------------------------------------------------------
test_num=1
descr="float input, no mask, no map, whole"
cat <<EOF > $tmpdir/ascii.$$
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
1.2 2.2 3.2 4.2 5.2 6.2 7.2 8.2 9.2 10.2
1.3 2.3 3.3 4.3 5.3 6.3 7.3 8.3 9.3 10.3
1.4 2.4 3.4 4.4 5.4 6.4 7.4 8.4 9.4 10.4
1.5 2.5 3.5 4.5 5.5 6.5 7.5 8.5 9.5 10.5
1.6 2.6 3.6 4.6 5.6 6.6 7.6 8.6 9.6 10.6
1.7 2.7 3.7 4.7 5.7 6.7 7.7 8.7 9.7 10.7
1.8 2.8 3.8 4.8 5.8 6.8 7.8 8.8 9.8 10.8
1.9 2.9 3.9 4.9 5.9 6.9 7.9 8.9 9.9 10.9
1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 11 -type 10 -o $tmpdir/ascii.$$
khisto -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -min 0 -binwidth 1 -bins 11 -whole
cat <<EOF > $tmpdir/ascii.$$
0 11 11 11 11 11 11 11 11 11 11
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 11 -type 9 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2:  float input with mask, no map, whole
# ------------------------------------------------------------------------
test_num=2
descr="float input with mask, no map, whole"
cat <<EOF > $tmpdir/ascii.$$
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
1.2 2.2 3.2 4.2 5.2 6.2 7.2 8.2 9.2 10.2
1.3 2.3 3.3 4.3 5.3 6.3 7.3 8.3 9.3 10.3
1.4 2.4 3.4 4.4 5.4 6.4 7.4 8.4 9.4 10.4
1.5 2.5 3.5 4.5 5.5 6.5 7.5 8.5 9.5 10.5
1.6 2.6 3.6 4.6 5.6 6.6 7.6 8.6 9.6 10.6
1.7 2.7 3.7 4.7 5.7 6.7 7.7 8.7 9.7 10.7
1.8 2.8 3.8 4.8 5.8 6.8 7.8 8.8 9.8 10.8
1.9 2.9 3.9 4.9 5.9 6.9 7.9 8.9 9.9 10.9
1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 11 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 0 1 0 0 0 0
0 0 0 0 1 0 1 0 0 0
0 0 0 1 0 1 0 1 0 0
0 0 0 0 0 0 0 0 0 0
1 0 0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0 0 1
1 1 1 1 1 1 1 1 1 1
1 0 1 0 1 0 1 0 1 0
0 1 0 1 0 1 0 1 0 1
0 1 1 1 1 1 1 1 1 0
1 0 0 0 0 0 0 0 0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 10 -hsize 11 -type 10 -o $tmpdir/in.$$
khisto -i $tmpdir/in.$$ -o $tmpdir/out.$$ -min 0 -binwidth 1 -bins 11 -whole
cat <<EOF > $tmpdir/ascii.$$
0 4 3 3 4 4 5 4 4 3 4
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 11 -type 9 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/ascii.$$ $tmpdir/in.$$ $tmpdir/result.$$

# ------------------------------------------------------------------------
# Test  3:  float input, no mask, no map, rows
# ------------------------------------------------------------------------
test_num=3
descr="float input, no mask, no map, rows"
cat <<EOF > $tmpdir/ascii.$$
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
1.2 2.2 3.2 4.2 5.2 6.2 7.2 8.2 9.2 10.2
1.3 2.3 3.3 4.3 5.3 6.3 7.3 8.3 9.3 10.3
1.4 2.4 3.4 4.4 5.4 6.4 7.4 8.4 9.4 10.4
1.5 2.5 3.5 4.5 5.5 6.5 7.5 8.5 9.5 10.5
1.6 2.6 3.6 4.6 5.6 6.6 7.6 8.6 9.6 10.6
1.7 2.7 3.7 4.7 5.7 6.7 7.7 8.7 9.7 10.7
1.8 2.8 3.8 4.8 5.8 6.8 7.8 8.8 9.8 10.8
1.9 2.9 3.9 4.9 5.9 6.9 7.9 8.9 9.9 10.9
1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 11 -type 10 -o $tmpdir/ascii.$$
khisto -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -min 0 -binwidth 1 -bins 11 -w
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 0 0 0 0 0 0 0
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1 1 1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 11 -hsize 11 -type 9 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  4:  float input, no mask, no map, cols
# ------------------------------------------------------------------------
test_num=4
descr="float input, no mask, no map, cols"
cat <<EOF > $tmpdir/ascii.$$
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
1.2 2.2 3.2 4.2 5.2 6.2 7.2 8.2 9.2 10.2
1.3 2.3 3.3 4.3 5.3 6.3 7.3 8.3 9.3 10.3
1.4 2.4 3.4 4.4 5.4 6.4 7.4 8.4 9.4 10.4
1.5 2.5 3.5 4.5 5.5 6.5 7.5 8.5 9.5 10.5
1.6 2.6 3.6 4.6 5.6 6.6 7.6 8.6 9.6 10.6
1.7 2.7 3.7 4.7 5.7 6.7 7.7 8.7 9.7 10.7
1.8 2.8 3.8 4.8 5.8 6.8 7.8 8.8 9.8 10.8
1.9 2.9 3.9 4.9 5.9 6.9 7.9 8.9 9.9 10.9
1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 11 -type 10 -o $tmpdir/ascii.$$
khisto -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -min 0 -binwidth 1 -bins 11 -h
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 0 0 0 0 0 0
11 0 0 0 0 0 0 0 0 0
0 11 0 0 0 0 0 0 0 0
0 0 11 0 0 0 0 0 0 0
0 0 0 11 0 0 0 0 0 0
0 0 0 0 11 0 0 0 0 0
0 0 0 0 0 11 0 0 0 0
0 0 0 0 0 0 11 0 0 0
0 0 0 0 0 0 0 11 0 0
0 0 0 0 0 0 0 0 11 0
0 0 0 0 0 0 0 0 0 11
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 11 -type 9 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  5:  float input, no mask, no map, whole, gate
# ------------------------------------------------------------------------
test_num=5
descr="float input, no mask, no map, whole, gate"
cat <<EOF > $tmpdir/ascii.$$
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
1.2 2.2 3.2 4.2 5.2 6.2 7.2 8.2 9.2 10.2
1.3 2.3 3.3 4.3 5.3 6.3 7.3 8.3 9.3 10.3
1.4 2.4 3.4 4.4 5.4 6.4 7.4 8.4 9.4 10.4
1.5 2.5 3.5 4.5 5.5 6.5 7.5 8.5 9.5 10.5
1.6 2.6 3.6 4.6 5.6 6.6 7.6 8.6 9.6 10.6
1.7 2.7 3.7 4.7 5.7 6.7 7.7 8.7 9.7 10.7
1.8 2.8 3.8 4.8 5.8 6.8 7.8 8.8 9.8 10.8
1.9 2.9 3.9 4.9 5.9 6.9 7.9 8.9 9.9 10.9
1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 11 -type 10 -o $tmpdir/data.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 0 0 0 0 0 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 0 0 0 1 1 1 1 0
1 1 0 0 0 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 11 -type 10 -o $tmpdir/gate.$$
khisto -i $tmpdir/data.$$ -o $tmpdir/out.$$ -min 0 -binwidth 1 -bins 11 -whole -igate $tmpdir/gate.$$
cat <<EOF > $tmpdir/ascii.$$
0 10 10 8 8 8 10 10 10 10 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 11 -type 9 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/data.$$ $tmpdir/gate.$$

# ------------------------------------------------------------------------
# Test  6:  float input with mask, no map, whole, gate
# ------------------------------------------------------------------------
test_num=6
descr="float input with mask, no map, whole, gate"
cat <<EOF > $tmpdir/ascii.$$
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
1.2 2.2 3.2 4.2 5.2 6.2 7.2 8.2 9.2 10.2
1.3 2.3 3.3 4.3 5.3 6.3 7.3 8.3 9.3 10.3
1.4 2.4 3.4 4.4 5.4 6.4 7.4 8.4 9.4 10.4
1.5 2.5 3.5 4.5 5.5 6.5 7.5 8.5 9.5 10.5
1.6 2.6 3.6 4.6 5.6 6.6 7.6 8.6 9.6 10.6
1.7 2.7 3.7 4.7 5.7 6.7 7.7 8.7 9.7 10.7
1.8 2.8 3.8 4.8 5.8 6.8 7.8 8.8 9.8 10.8
1.9 2.9 3.9 4.9 5.9 6.9 7.9 8.9 9.9 10.9
1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0
1.1 2.1 3.1 4.1 5.1 6.1 7.1 8.1 9.1 10.1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 11 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 0 1 0 0 0 0
0 0 0 0 1 0 1 0 0 0
0 0 0 1 0 1 0 1 0 0
0 0 0 0 0 0 0 0 0 0
1 0 0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0 0 1
1 1 1 1 1 1 1 1 1 1
1 0 1 0 1 0 1 0 1 0
0 1 0 1 0 1 0 1 0 1
0 1 1 1 1 1 1 1 1 0
1 0 0 0 0 0 0 0 0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 10 -hsize 11 -type 10 \
-o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 0 0 0 0 0 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 0 0 0 1 1 1 1 0
1 1 0 0 0 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
1 1 1 1 1 1 1 1 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 11 -type 10 -o $tmpdir/gate.$$
khisto -i $tmpdir/in.$$ -o $tmpdir/out.$$ -min 0 -binwidth 1 -bins 11 -whole \
-igate $tmpdir/gate.$$
cat <<EOF > $tmpdir/ascii.$$
0 4 3 3 4 4 4 4 4 3 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 11 -type 9 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/ascii.$$ $tmpdir/in.$$ $tmpdir/result.$$ $tmpdir/gate.$$ $tmpdir/out.$$
 
exit $status

