#! /bin/sh

echo "running test1.sh for kgate ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
bpath=`kecho -tb DATAMANIP -echo path`/bin
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  value data, different sized objects, logic = 1
# ------------------------------------------------------------------------
test_num=1
descr="value data, different sized objects, logic = 1"
$bpath/kgate -i1 $dpath/2x3.float.xv -i2 $dpath/3x4.int.viff \
      -igate $dpath/2x3gate.byte.viff -o $tmpdir/out.$$
report $test_num "$tmpdir/out.$$" "test1.results/2x3_3x4_2x3g_L1" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2:  value data, different sized objects, logic = 0
# ------------------------------------------------------------------------
test_num=2
descr="value data, different sized objects, logic = 0"
$bpath/kgate -i1 $dpath/2x3.float.xv -i2 $dpath/3x4.int.viff \
      -igate $dpath/2x3gate.byte.viff -o $tmpdir/out.$$ -logic 0
report $test_num "$tmpdir/out.$$" "test1.results/2x3_3x4_2x3g_L0" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  value data, different sized objects, logic = 0, gval = 1
# ------------------------------------------------------------------------
test_num=3
descr="value data, different sized objects, logic = 0, gval = 1"
$bpath/kgate -i1 $dpath/2x3.float.xv -i2 $dpath/3x4.int.viff \
      -igate $dpath/2x3gate.byte.viff -o $tmpdir/out.$$ -logic 0 -gval 1
report $test_num "$tmpdir/out.$$" "test1.results/2x3_3x4_2x3g_L1" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  4:  value data, different sized objects, logic = 1, gval = -7
# ------------------------------------------------------------------------
test_num=4
descr="value data, different sized objects, logic = 1, gval = -7"
$bpath/kgate -i1 $dpath/2x3.float.xv -i2 $dpath/3x4.int.viff \
      -igate $dpath/2x3gate.byte.viff -o $tmpdir/out.$$ -logic 1 -gval -7
report $test_num "$tmpdir/out.$$" "test1.results/2x3_3x4_2x3g_L1-7" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  5: value, map, and mask data, different sized objects, logic = 0
# ------------------------------------------------------------------------
test_num=5
descr="value, map, and mask data, different sized objects, logic = 0"
$bpath/kgate -i1 $dpath/2x3ival_6x3fmap.viff -i2 $dpath/3x4masked.byte.viff \
      -igate $dpath/4x2gate.byte.xv -o $tmpdir/out.$$ -logic 0
report $test_num "$tmpdir/out.$$" "test1.results/2x3vmp_3x4vmk_4x2g_L0" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run on command line:
# kgate -i1 ~/datamanip/data/testdata/2x3ival_6x3fmap.viff -i2 ~/datamanip/data/testdata/3x4masked.byte.viff -igate ~/datamanip/data/testdata/4x2gate.byte.xv -o junk -logic 0

exit $status
