#! /bin/sh

echo "running test2.sh for kflip ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set data path for image data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/images"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  bit value data flipped along width
# ------------------------------------------------------------------------
test_num=1
descr="bit value data flipped along width"
cat <<EOF > $tmpdir/ascii.$$
1 0 1 0 1 0 1 0
1 1 0 1 0 1 0 1
1 0 1 0 1 0 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 8 -hsize 3 -type 1 -o $tmpdir/ascii.$$
kflip -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -w
cat <<EOF > $tmpdir/ascii.$$
0 1 0 1 0 1 0 1
1 0 1 0 1 0 1 1
0 1 0 1 0 1 0 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 8 -hsize 3 -type 1 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

exit $status
