#! /bin/sh

echo "running test1.sh for kbitwise ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num="$1"
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  or - signed short value data with no map
# ------------------------------------------------------------------------
test_num=1
descr="or - signed short value data with no map"
cat <<EOF > $tmpdir/ascii.$$
1 2 4 8
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 1 -type 4 -o $tmpdir/in1.$$
cat <<EOF > $tmpdir/ascii.$$
2 4 8 16
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 1 -type 4 -o $tmpdir/in2.$$
kbitwise -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o $tmpdir/out.$$ -or
cat <<EOF > $tmpdir/ascii.$$
3 6 12 24
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 1 -type 4 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in1.$$
/bin/rm -f $tmpdir/in2.$$

# ------------------------------------------------------------------------
# Test  2:  or - bit value data with no map
# ------------------------------------------------------------------------
test_num=2
descr="or - bit value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1 0 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 1 -type 1 -o $tmpdir/in1.$$
cat <<EOF > $tmpdir/ascii.$$
0 1 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 1 -type 1 -o $tmpdir/in2.$$
kbitwise -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o $tmpdir/out.$$ -or
cat <<EOF > $tmpdir/ascii.$$
0 1 1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 1 -type 1 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in1.$$
/bin/rm -f $tmpdir/in2.$$

# ------------------------------------------------------------------------
# Test  3:  and - bit value data with no map
# ------------------------------------------------------------------------
test_num=3
descr="and - bit value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 20 -hsize 1 -type 1 -o $tmpdir/in1.$$
cat <<EOF > $tmpdir/ascii.$$
0 1 1 0 0 1 1 0 0 1 1 0 0 1 1 0 0 1 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 20 -hsize 1 -type 1 -o $tmpdir/in2.$$
kbitwise -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o $tmpdir/out.$$ -and
cat <<EOF > $tmpdir/ascii.$$
0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 20 -hsize 1 -type 1 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in1.$$
/bin/rm -f $tmpdir/in2.$$

# ------------------------------------------------------------------------
# Test  4:  xor - bit value data with no map
# ------------------------------------------------------------------------
test_num=4
descr="xor - bit value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1 0 1 0 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 7 -hsize 1 -type 1 -o $tmpdir/in1.$$
cat <<EOF > $tmpdir/ascii.$$
0 1 1 0 0 1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 7 -hsize 1 -type 1 -o $tmpdir/in2.$$
kbitwise -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o $tmpdir/out.$$ -xor
cat <<EOF > $tmpdir/ascii.$$
0 0 1 1 0 0 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 7 -hsize 1 -type 1 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in1.$$
/bin/rm -f $tmpdir/in2.$$

# ------------------------------------------------------------------------
# Test  5:  nand - bit value data with no map
# ------------------------------------------------------------------------
test_num=5
descr="nand - bit value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1 0 1 0 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 7 -type 1 -o $tmpdir/in1.$$
cat <<EOF > $tmpdir/ascii.$$
0 1 1 0 0 1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 7 -type 1 -o $tmpdir/in2.$$
kbitwise -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o $tmpdir/out.$$ -nand
cat <<EOF > $tmpdir/ascii.$$
1 0 1 1 1 0 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 7 -type 1 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in1.$$
/bin/rm -f $tmpdir/in2.$$


exit $status

