#! /bin/sh

echo "running test1.sh for karith2 ... process ($$)"


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
bpath=`kecho -tb DATAMANIP -echo path`/bin
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  add - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=1
descr="add - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.short.xv -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_add_4x2s" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2:  add - 2 input: both have masks
# ------------------------------------------------------------------------
test_num=2
descr="add - 2 input: both have masks"
$bpath/karith2 -i1 $dpath/3x4masked.byte.viff -i2 $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/3x4mb_add_4x2mf" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  add - 2 input: both have masks
# ------------------------------------------------------------------------
test_num=3
descr="add - 2 input: both have masks"
$bpath/karith2 -i2 $dpath/3x4masked.byte.viff -i1 $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/3x4mb_add_4x2mf" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  4:  add - 2 input: i1 has mask, i2 does not
# ------------------------------------------------------------------------
test_num=4
descr="add - 2 input: i1 has mask, i2 does not"
$bpath/karith2 -i1 $dpath/4x2masked.float.viff -i2 $dpath/3x4.int.viff -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/4x2mf_add_3x4i" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  5:  add - 2 input: i2 has mask, i1 does not
# ------------------------------------------------------------------------
test_num=5
descr="add - 2 input: i2 has mask, i1 does not"
$bpath/karith2 -i2 $dpath/4x2masked.float.viff -i1 $dpath/3x4.int.viff -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/4x2mf_add_3x4i" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  6:  add - 1 input byte
# ------------------------------------------------------------------------
test_num=6
descr="add - 1 input byte"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -real 1.4 -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_add_1.4" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  7:  add - 1 input int
# ------------------------------------------------------------------------
test_num=7
descr="add - 1 input int"
$bpath/karith2 -i1 $dpath/3x4.int.viff -real 1.4 -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/3x4i_add_1.4" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  8:  add - 1 input float
# ------------------------------------------------------------------------
test_num=8
descr="add - 1 input float"
$bpath/karith2 -i1 $dpath/2x3.float.xv -real 1.4 -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/2x3f_add_1.4" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  9:  add - 1 input double with mask
# ------------------------------------------------------------------------
test_num=9
descr="add - 1 input double with mask"
$bpath/karith2 -i1 $dpath/3x4masked.double.viff -real 1.4 -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/2x3md_add_1.4" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  10:  sub - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=10
descr="sub - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.short.xv -o $tmpdir/out.$$ -sub
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_sub_4x2s" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  11:  mul - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=11
descr="mul - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.short.xv -o $tmpdir/out.$$ -mul
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_mul_4x2s" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  12:  div - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=12
descr="div - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.float.xv -o $tmpdir/out.$$ -div
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_div_4x2f" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  13:  div - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=13
descr="div - 2 input: no masks, no maps"
$bpath/karith2 -i2 $dpath/3x4.byte.xv -i1 $dpath/4x2.float.xv -o $tmpdir/out.$$ -div
report $test_num "$tmpdir/out.$$" "test1.results/4x2f_div_3x4b" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  14:  absdiff - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=14
descr="absdiff - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.float.xv -o $tmpdir/out.$$ -absdiff
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_absdiff_4x2f" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  15:  hypot - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=15
descr="hypot - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.float.xv -o $tmpdir/out.$$ -hypot
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_hypot_4x2f" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  16:  hypot - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=16
descr="hypot - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.short.xv -o $tmpdir/out.$$ -hypot
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_hypot_4x2s" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  17:  min - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=17
descr="min - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.float.xv -o $tmpdir/out.$$ -min
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_min_4x2f" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  18:  max - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=18
descr="max - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.short.xv -o $tmpdir/out.$$ -max
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_max_4x2s" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  19:  ldexp - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=19
descr="ldexp - 2 input: no masks, no maps"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.float.xv -o $tmpdir/out.$$ -ldexp
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_ldexp_4x2f" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  20:  pow - 2 input: no masks, no maps
# ------------------------------------------------------------------------
kclipbelow -i $dpath/3x4.byte.xv -o $tmpdir/temp1.$$ -lc 1 -fval 1
kclipin -i $dpath/4x2.float.xv -o $tmpdir/temp2.$$ -lc 1 -uc -1 -fval 1

test_num=20
descr="pow - 2 input: no masks, no maps"
$bpath/karith2 -i1 $tmpdir/temp1.$$ -i2 $tmpdir/temp2.$$ -o $tmpdir/out.$$ -pow
report $test_num "$tmpdir/out.$$" "test1.results/3x4b_pow_4x2f" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  21:  pow - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=21
descr="pow - 2 input: no masks, no maps"
$bpath/karith2 -i2 $tmpdir/temp1.$$ -i1 $tmpdir/temp2.$$ -o $tmpdir/out.$$ -pow
report $test_num "$tmpdir/out.$$" "test1.results/4x2f_pow_3x4b" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/temp1.$$ $tmpdir/temp2.$$

# ------------------------------------------------------------------------
# Test  22:  atan2 - 2 input: no masks, no maps
# ------------------------------------------------------------------------
test_num=22
descr="atan2 - 2 input: no masks, no maps"
$bpath/karith2 -i2 $dpath/3x4.byte.xv -i1 $dpath/4x2.float.xv -o $tmpdir/out.$$ -atan2
report $test_num "$tmpdir/out.$$" "test1.results/4x2f_atan2_3x4b" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  23:  add - 2 input: i1 has map, i2 no map, different sizes
# ------------------------------------------------------------------------
test_num=23
descr="add - 2 input: i1 has map, i2 no map, different sizes"
$bpath/karith2 -i1 $dpath/2x3ival_6x3fmap.viff -i2 $dpath/3x4.int.viff -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/2x3iv_6x3fmp_add_3x4iv" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  24:  subfrom - 2 input: i1 has mask, no maps
# ------------------------------------------------------------------------
test_num=24
descr="subfrom - 2 input: i2 has mask, no maps"
$bpath/karith2 -i2 $dpath/3x4masked.double.viff -i1 $dpath/4x2gate.byte.xv -o $tmpdir/out.$$ -subfrom
report $test_num "$tmpdir/out.$$" "test1.results/3x4md_subfrom_4x2b" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  25:  subfrom - 1 input, has mask, subtract from constant
# ------------------------------------------------------------------------
test_num=25
descr="subfrom - 1 input, has mask, subtract from constant"
$bpath/karith2 -i1 $dpath/3x4masked.double.viff -o $tmpdir/out.$$ -subfrom -real 5
report $test_num "$tmpdir/out.$$" "test1.results/3x4md_subfrom_5" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  26:  divinto - 1 input, has mask, divide into constant
# ------------------------------------------------------------------------
test_num=26
descr="divinto - 1 input, has mask, divide into constant"
$bpath/karith2 -i1 $dpath/3x4masked.double.viff -o $tmpdir/out.$$ -divinto -real 5
report $test_num "$tmpdir/out.$$" "test1.results/3x4md_divinto_5" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  27:  add - constant added to value data with a map
# ------------------------------------------------------------------------
test_num=27
descr="add - constant added to value data with a map"
$bpath/karith2 -i1 $dpath/2x3ival_6x3fmap.viff -o $tmpdir/out.$$ -add -real 5
report $test_num "$tmpdir/out.$$" "test1.results/2x3vm_add_5" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  28:  divinto - 2 input, results should be same as test 13
# ------------------------------------------------------------------------
test_num=28
descr="divinto - 2 input, results should be same as test 13"
$bpath/karith2 -i1 $dpath/3x4.byte.xv -i2 $dpath/4x2.float.xv -o $tmpdir/out.$$ -divinto
report $test_num "$tmpdir/out.$$" "test1.results/4x2f_div_3x4b" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  29:  add - 2 input: i2 has map, i1 no map, different sizes
# ------------------------------------------------------------------------
test_num=29
descr="add - 2 input: i2 has map, i1 no map, different sizes"
$bpath/karith2 -i2 $dpath/2x3ival_6x3fmap.viff -i1 $dpath/3x4.int.viff -o $tmpdir/out.$$ -add
report $test_num "$tmpdir/out.$$" "test1.results/2x3iv_6x3fmp_add_3x4iv" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run from the command line
# karith2 -i1 ~/datamanip/data/testdata/3x4.int.viff -i2 ~/datamanip/data/testdata/2x3ival_6x3fmap.viff -o junk -add

exit $status
