#! /bin/sh

echo "running test1b.sh for karith1 ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num="$1"
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
tolerance="$5"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tolerance" -sat 1 -s -rt 1 -all 
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  16:  abs - unsigned long value data with no map
# ------------------------------------------------------------------------
test_num=16
descr="abs - unsigned long (32 bit only) value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
127 127
32767 32767
65535 65535
2147483647 4294967295
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 5 -type 9 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
0 1
127 127
32767 32767
65535 65535
2147483647 4294967295
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 5 -type 9 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  17:  abs - double value data with no map
# ------------------------------------------------------------------------
test_num=17
descr="abs - double value data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1.12345678901234567890e-38 1.12345678901234567890e-38
-1.12345678901234567890e38 1.12345678901234567890e38
-3.14159265358979323846 3.14159265358979323846
-0.49 0.49
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1.12345678901234567890e-38 1.12345678901234567890e-38
1.12345678901234567890e38 1.12345678901234567890e38
3.14159265358979323846 3.14159265358979323846
0.49 0.49
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  18:  abs - double value data with mask
# ------------------------------------------------------------------------
test_num=18
descr="abs - double value data with mask"
cat <<EOF > $tmpdir/ascii.$$
-1.12345678901234567890e-38 1.12345678901234567890e-38
-1.12345678901234567890e38 1.12345678901234567890e38
-3.14159265358979323846 3.14159265358979323846
-0.49 0.49
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1.12345678901234567890e-38 1.12345678901234567890e-38
1.12345678901234567890e38 1.12345678901234567890e38
3.14159265358979323846 3.14159265358979323846
0.49 0.49
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  19:  abs - signed int value data with mask
# ------------------------------------------------------------------------
test_num=19
descr="abs - signed int value data with mask"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 127
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1 1
127 127
32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  20:  abs - signed byte value data with mask
# ------------------------------------------------------------------------
test_num=20
descr="abs - signed byte value data with mask"
cat <<EOF > $tmpdir/ascii.$$
1 1
127 127
32 32
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 2 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 3 -type 2 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1 1
127 127
32 32
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 2 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 3 -type 2 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  21:  abs - signed short value data with mask
# ------------------------------------------------------------------------
test_num=21
descr="abs - signed short value data with mask"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 127
-32 32
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 4 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 4 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1 1
127 127
32 32
32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 4 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 4 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  22:  abs - signed short value data with signed short map
# ------------------------------------------------------------------------
test_num=22
descr="abs - signed short value data with signed short map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
2 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 4 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 127
-32 32
-32767 32767
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 4 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
-1 1
2 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 4 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
1 1
127 127
32 32
32767 32767
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 4 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  23:  abs - signed byte value data with signed byte map
# ------------------------------------------------------------------------
test_num=23
descr="abs - signed byte value data with signed byte map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
2 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 2 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 127
-32 32
-57 57
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 2 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
-1 1
2 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 2 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
1 1
127 127
32 32
57 57
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 2 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  24:  abs - float value data with float map
# ------------------------------------------------------------------------
test_num=24
descr="abs - float value data with float map"
cat <<EOF > $tmpdir/ascii.$$
0 1.57
2.02 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
-1.12345e-38 1.12345e-38
-1.12345e38 1.123456e38
-3.14159 3.14159
-0.49 0.49
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
0 1.57
2.02 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 10 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
1.12345e-38 1.12345e-38
1.12345e38 1.123456e38
3.14159 3.14159
0.49 0.49
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  25:  abs - double value data with double map
# ------------------------------------------------------------------------
test_num=25
descr="abs - double value data with double map"
cat <<EOF > $tmpdir/ascii.$$
0 1.57
2.02 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 11 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
-1.12345678901234567890e-38 1.12345678901234567890e-38
-1.12345678901234567890e38 1.12345678901234567890e38
-3.14159265358979323846 3.14159265358979323846
-0.49 0.49
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
0 1.57
2.02 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 11 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
1.12345678901234567890e-38 1.12345678901234567890e-38
1.12345678901234567890e38 1.12345678901234567890e38
3.14159265358979323846 3.14159265358979323846
0.49 0.49
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  26:  abs - double value data with double map and double mask
# ------------------------------------------------------------------------
test_num=26
descr="abs - double value data with double map and double mask"
cat <<EOF > $tmpdir/ascii.$$
0 1.57
2.02 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 11 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
-1.12345678901234567890e-38 1.12345678901234567890e-38
-1.12345678901234567890e38 1.12345678901234567890e38
-3.14159265358979323846 3.14159265358979323846
-0.49 0.49
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 2 -type 11 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
0 1.57
2.02 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 11 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
1.12345678901234567890e-38 1.12345678901234567890e-38
1.12345678901234567890e38 1.12345678901234567890e38
3.14159265358979323846 3.14159265358979323846
0.49 0.49
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 11 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 2 -type 11 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  27:  abs - float data with float map and float mask
# ------------------------------------------------------------------------
test_num=27
descr="abs - float value data with float map and float mask"
cat <<EOF > $tmpdir/ascii.$$
0 1.57
2.02 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
-1.123456e-38 1.123456e-38
-1.123456e38 1.123456e38
-3.1415926 3.1415926
-0.49 0.49
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 2 -type 10 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
0 1.57
2.02 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 10 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
1.123456e-38 1.123456e-38
1.123456e38 1.123456e38
3.1415926 3.1415926
0.49 0.49
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 2 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$

# ------------------------------------------------------------------------
# Test  28:  sqrt - float value data with no map
# ------------------------------------------------------------------------
test_num=28
descr="sqrt - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
57 1e20
65536 1.12345e-38
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -sqrt
cat <<EOF > $tmpdir/ascii.$$
0 1
7.5498344 1e10
256 1.059929e-19
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  29:  cbrt - float value data with no map
# added negative test values 8-30-94 - dk
# ------------------------------------------------------------------------
test_num=29a
descr="cbrt - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
57 57
65536 1.12345e-38
-1 -2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -cbrt
cat <<EOF > $tmpdir/ascii.$$
0 1
3.8485011 3.8485011
40.317474 2.239672e-13
-1 -1.25992105
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

test_num=29b
descr="cbrt - float value data with no map - very large number"
cat <<EOF > $tmpdir/ascii.$$
1e20
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -cbrt
cat <<EOF > $tmpdir/ascii.$$
4641588.8
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-1"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  30:  neg - float value data with no map
# ------------------------------------------------------------------------
test_num=30
descr="neg - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
57 -1e20
-65536 1.12345e-38
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -neg
cat <<EOF > $tmpdir/ascii.$$
0 -1
-57 1e20
65536 -1.12345e-38
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

exit $status

