 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for kinsertseg
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkinsertseg
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkinsertseg - insert segment(s) from one object into another
* 
*       Purpose: This routine will insert a segment(s) specified by
*		 segment_list from source_object1 into source_obj2
*		 and return the resulting object in destination_object.
*		 Each segment's attributes and data will be copied
*		 into the destination_object.  If segment_list is
*		 NULL it will copy all the segments in the object.
*		 The segment_list is a string that contains each segment
*     		 name separated by space(s).
*
*        !     lkinsertseg(source_object1, source_object2,
*        !                      "segment1 segment2", destination_object);
*
*		 If source_object2 is not NULL it will be copied
*		 using kdms_copy_object() into the destination_object
*		 then the segment(s) inserted.  If source_object2 is
*		 NULL, the segment(s) will be inserted into the
*		 destination_object directly.  This is the same as
*		 calling lkcpseg() as follows:
*
*        !     lkcpseg(source_object1, "segment1 segment2",
*        !                    destination_object);
*
*		 This routine will actually call lkcpseg() to
*		 insert the segment source_obj2 to the destination_object.
*
*         Input: source_object1 - object to get the segment to insert
*		 source_object2 - object to insert the segment into
*                segment_list   - list of segment(s) to insert
*
*        Output: destination_object - object after the segment was inserted
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: John M. Salas & Donna Koechner
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int 
lkinsertseg(
   kobject source_object1,
   kobject source_object2,
   char   *segment_list,
   kobject destination_object)
/* -library_def_end */

/* -library_code */
{
   if (source_object2 &&
       !kdms_copy_object(source_object2, destination_object, TRUE, TRUE))
   {

      kerror("ksegops", "lkinsertseg", 
	     "Can not copy source object2 to destination_object.");
      return (FALSE);
   }

   if (!lkcpseg(source_object1, segment_list, destination_object))
   {
      return (FALSE);
   }

   return (TRUE);
}
/* -library_code_end */
