 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for kimportraw
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkimportraw
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
#include "internals.h"
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkimportraw - import raw binary data into a data segment
* 
*       Purpose: lkimport_raw can be used to read raw binary data and import
*		 it to a data segment.  lkimport will either create an 
*		 object with the new segment in it or append the new 
*		 segment to the optionally supplied add_obj object.
*
*		 Valid arch types are: KMACH_UNKNOWN, KMACH_LOCAL, 
*                KMACH_I80x86, KMACH_SPARC, KMACH_MIPSEL, KMACH_IBMRT,
*                KMACH_RS6000, KMACH_POWERPC, KMACH_MC680x0,
*                KMACH_M88x00,KMACH_MIPSEB, KMACH_PARISC,
*                KMACH_CONVEX, KMACH_APOLLO, KMACH_ALPHA,
*                KMACH_CYBER, KMACH_CRAY, KMACH_VAX, and KMACH_I860.
*
*		 Valid data types are: KBIT, KBYTE, KUBYTE, KSHORT, KUSHORT, 
*		 KINT, KUINT, KLONG, KULONG, KFLOAT, KDOUBLE, KCOMPLEX,
*		 and KDCOMPLEX
*
*         Input: raw_obj - raw source data
*		 add_obj - optional object to import the data into
*		 arch - source architecture of the raw data
*		 type - data type of the raw data
*		 seg - string defining which data segment to insert data into
*		 w, h, d, t, e - size of raw data
*
*        Output: out_obj - resulting destination object
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Scott Wilson, Jeremy Worley
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int 
lkimportraw(
kobject raw_obj,
kobject add_obj,
int arch,
int type,
char *seg,
int w,
int h,
int d,
int t,
int e,
kobject out_obj)
/* -library_def_end */

/* -library_code */
  {
    char *lib = "ksegops", *rtn = "lkimportraw";
    int dim;
    int size[5];
    int order[5];
    char *format;
    
    /*
     * sanity check.  if data services recognized the file, then its
     * not raw.  Don't allow continuation.
     */
    if (!kdms_get_attribute(raw_obj, NULL, KDMS_FORMAT, &format))
    {
       kerror(lib, rtn, "Unable to get the format attribute from the raw"
	      " object.");
       return (FALSE);
    }

    if (kstrcmp(KRAW, format) != 0)
    {
       kerror(lib, rtn, "This is not a raw file.  This is a '%s' file.  "
	      "This routine cannot import formatted data files as raw data.  "
	      "If you want to change the file format of this file, then "
	      "you should use the kformats program.", format);
       return (FALSE);
    }
    
    
    if (add_obj != KOBJECT_INVALID)
    {
       if ((add_obj = kpds_reference_object(add_obj)) == KOBJECT_INVALID)
       {
	  kerror(lib, rtn, "Failed to reference add object");
	  return(FALSE);
       }
    }

    if (!kdms_set_attribute(raw_obj,NULL, KDMS_ARCHITECTURE, arch))
      {
        kerror(lib, rtn, "Unable to set architecture on raw object.");
        kdms_close(raw_obj);
        kdms_close(out_obj);
        return(FALSE);
      }

    /*
     * Tricky use of a new function.  Rename the segment.
     */
    if (kstrcmp(KDMS_SEGMENT_VALUE, seg) != 0)
       kdms_rename_segment(raw_obj, KDMS_SEGMENT_VALUE, seg);

    /*
     * change the dimensionality, and index order as well.
     */
    if (kstrcmp(seg, KDMS_SEGMENT_VALUE) == 0)
    {
       size[0] = w;
       size[1] = h;
       size[2] = d;
       size[3] = t;
       size[4] = e;

       order[0] = KWIDTH;
       order[1] = KHEIGHT;
       order[2] = KDEPTH;
       order[3] = KTIME;
       order[4] = KELEMENTS;

       dim = 5;
    }
    else if (kstrcmp(seg, KDMS_SEGMENT_MASK) == 0)
    {
       size[0] = w;
       size[1] = h;
       size[2] = d;
       size[3] = t;
       size[4] = e;

       order[0] = KWIDTH;
       order[1] = KHEIGHT;
       order[2] = KDEPTH;
       order[3] = KTIME;
       order[4] = KELEMENTS;

       dim = 5;
    }
    else if (kstrcmp(seg, KDMS_SEGMENT_MAP) == 0)
    {
       size[0] = w;
       size[1] = h;
       size[2] = d;
       size[3] = t;
       size[4] = e;

       order[0] = KMAP_WIDTH;
       order[1] = KMAP_HEIGHT;
       order[2] = KMAP_DEPTH;
       order[3] = KMAP_TIME;
       order[4] = KMAP_ELEMENTS;

       dim = 5;
    }
    else if (kstrcmp(seg, KDMS_SEGMENT_LOCATION) == 0)
    {
       size[0] = w;
       size[1] = h;
       size[2] = d;
       size[3] = e;

       order[0] = KWIDTH;
       order[1] = KHEIGHT;
       order[2] = KDEPTH;
       order[3] = KDIMENSION;

       dim = 4;
    }
    else if (kstrcmp(seg, KDMS_SEGMENT_TIME) == 0)
    {
       size[0] = t;

       order[0] = KTIME;

       dim = 1;
    }
    else
    {
       kerror ("ksegops","lkimportraw",
	       "Non-polymorphic or bogus segment '%s' specified.", seg);
       return (FALSE);
    }
    
    kdms_set_attributes(raw_obj, seg, KDMS_DIMENSION, dim, 
			KDMS_INDEX_ORDER, order, KDMS_SIZE, size, 
			KDMS_DATA_TYPE, type, 
			NULL);

    if (add_obj != KOBJECT_INVALID)
       kdms_copy_object(add_obj, out_obj, TRUE, TRUE);
    
    kdms_copy_segment_data(raw_obj, seg, out_obj, seg);
    
    return TRUE;
  }
/* -library_code_end */
