 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for kcptoval
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkcptoval
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkcptoval - copy data from specified segment into value segment
* 
*       Purpose: This routine copies a segment from the source_object and
*		 put it into the destination_object's value segment.
*		 The higher dimensions will be rolled into the
*		 elements dimension of the value segment.  If the
*		 dimension is less than 5, the data will be copied
*		 into the lowest order dimension of the value segment
*		 first, then the next, etc. and the higher dimensions
*		 ignored.  If the value segment exists in the source
*		 object it will be replaced.
*
*                Only the size and data type attribute will be changed
*                in the value segment, all others will not be
*                transferred.  If the value does not yet exist, then
*                the dimension and index order of the value segment
*                will be set to the defaults: 5 and width, height,
*                depth, time, and elements.  If it does exist the
*                index order will not be changed.
*
*         Input: source_object - object to copy the segment from
*                segment_name  - segment name for segment to copy
*
*        Output: destination_object - object to put the segment into
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Results guaranteed only if dimension of destination
*		 segment is 5.  Other dimensions are not tested and 
*		 may produce poor results.
*    Written By: John M. Salas & Donna Koechner
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int 
lkcptoval(
   kobject source_object,
   char    *segment_name,
   kobject destination_object)
/* -library_def_end */

/* -library_code */
{
   klist *objlist=NULL;
   char  *lib = "ksegops", *rtn = "lkcptoval";
   int   i;
   int   dim;
   int   ndim;
   int   size;
   int   data_type;
   int  *size_vect;
   int  *nsize_vect;
   int  *begin;
   int  *end;
   int  *nbegin;
   int  *nend;
   int  *copy_size;
   int   value_data = FALSE;
   int   mask_data = FALSE;
   int   map_data = FALSE;
   int   time_data = FALSE;
   int   location_data = FALSE;
   kaddr data;

   /*
    * See if the segment exists in the source object.
    */
   if (!kdms_query_segment(source_object, segment_name))
   {
      kerror(lib, rtn, "Segment %s does not exist in source object.", 
		segment_name);
      return (FALSE);
   }

   /*
    * Determine the dimension of the segment.  If it is greater than
    * 5 then exit (JMAS). 
    */
   KCALL(kdms_get_attribute(source_object, segment_name, KDMS_DIMENSION, &dim));

   if (dim > 5)
   {
      kerror(lib, rtn, 
	     "Data Services does not yet support dimensions greater than "
	     "five.  Sorry for the inconvenience.");
      return (FALSE);
   }

   /*
    * If it is polymorphic segment, then make sure on a close that the
    * polymorphic model is obeyed.
    */
   if (!kstrcmp(segment_name, KDMS_SEGMENT_VALUE))
   {
      value_data = TRUE;
   }
   else if (!kstrcmp(segment_name, KDMS_SEGMENT_MASK))
   {
      mask_data = TRUE;
   }
   else if (!kstrcmp(segment_name, KDMS_SEGMENT_MAP))
   {
      map_data = TRUE;
   }
   else if (!kstrcmp(segment_name, KDMS_SEGMENT_TIME))
   {
      time_data = TRUE;
   }
   else if (!kstrcmp(segment_name, KDMS_SEGMENT_LOCATION))
   {
      location_data = TRUE;
   }

   /*
    * Get the dimension, size and data type of the value segment.
    */
   KCALL(kdms_get_attributes(source_object, segment_name,
		       KDMS_SIZE, &size_vect,
		       KDMS_DATA_TYPE, &data_type,
		       NULL));

   if (!kdms_query_segment(destination_object, KDMS_SEGMENT_VALUE))
   {
      KCALL(kpds_create_value(destination_object));
   }

   KCALL(kdms_get_attribute(destination_object, KDMS_SEGMENT_VALUE,
		      KDMS_DIMENSION, &ndim));

   copy_size = (int *)kmalloc(dim * sizeof(int));
   objlist = klist_add(objlist,copy_size,"KMALLOC");
   nsize_vect = (int *)kmalloc(ndim * sizeof(int));
   objlist = klist_add(objlist,nsize_vect,"KMALLOC");

   if (!copy_size || !nsize_vect)
   {
      kerror(lib, rtn, 
	     "(1) Could not allocate memory for temporary variable.");
      (void)klist_free(objlist,(kfunc_void)lkcall_free);
      return (FALSE);
   }

   /*
    * Adjust the size vector.  If the dimension of the value segment
    * is < the source segment roll the higher order dimensions into the
    * highest dimension of the value segment, the elements.  But, first
    * copy the the size vector because it is the source segments actual
    * size data and we do not want to change it.
    */
   for (i = 0; i < dim; i++)
   {
      copy_size[i] = size_vect[i];
   }

   if (ndim < dim)
   {
      for (i = 0; i < ndim; i++)
      {
	 nsize_vect[i] = copy_size[i];
      }

      for (i = ndim, size = copy_size[ndim - 1]; i < dim; i++)
      {
	 size *= copy_size[i];
	 nsize_vect[i] = 1;
      }
      nsize_vect[ndim - 1] = size;
   }
   /*
    * If the dimension of the value segment is > the source segment
    * copy the lower order dimensions and set the higher ones to 1.
    */
   else if (ndim > dim)
   {
      for (i = 0; i < dim; i++)
      {
	 nsize_vect[i] = copy_size[i];
      }

      for (i = dim; i < ndim; i++)
      {
	 nsize_vect[i] = 1;
      }
   }
   else
   {
      for (i = 0; i < dim; i++)
      {
	 nsize_vect[i] = copy_size[i];
      }
   }

   /*
    * Set the data type and size of the value segment.
    */
   KCALL(kdms_set_attributes(destination_object, KDMS_SEGMENT_VALUE,
		       KDMS_SIZE, nsize_vect,
		       KDMS_DATA_TYPE, data_type,
		       NULL));

   /*
    * Copy the data from the value to the destination segment.  If the
    * dimensions are the same just do a kdms_copy_data().
    */
   if (ndim == dim &&
       !kdms_copy_segment_data(source_object, segment_name,
			       destination_object, KDMS_SEGMENT_VALUE))
   {
      kerror(lib, rtn, "Failed to copy segment to value segment.");
      (void)klist_free(objlist,(kfunc_void)lkcall_free);
      return (FALSE);
   }
   /*
    * If not, copy the data with kdms_get_data() and then put it with
    * kdms_put_data().  First figure at the begin and end region first.
    */
   else if (ndim != dim)
   {
      begin = (int *)kmalloc(dim * sizeof(int *));
      objlist = klist_add(objlist,begin,"KMALLOC");
      end = (int *)kmalloc(dim * sizeof(int *));
      objlist = klist_add(objlist,end,"KMALLOC");
      nbegin = (int *)kmalloc(kmax(ndim, 5) * sizeof(int *));
      objlist = klist_add(objlist,nbegin,"KMALLOC");
      nend = (int *)kmalloc(kmax(ndim, 5) * sizeof(int *));
      objlist = klist_add(objlist,nend,"KMALLOC");

      if (!begin || !end || !nbegin || !nend)
      {
	 kerror(lib, rtn, 
		"(2) Could not allocate memory for temporary variable.");
         (void)klist_free(objlist,(kfunc_void)lkcall_free);
	 return (FALSE);
      }

      for (i = 0; i < dim; i++)
      {
	 begin[i] = 0;
	 end[i] = size_vect[i] - 1;
      }

      for (i = 0; i < kmax(ndim, 5); i++)
      {
	 nbegin[i] = 0;
	 nend[i] = nsize_vect[i] - 1;
      }

      data = kdms_get_data(source_object, segment_name,
			   begin, end, NULL);
      kdms_put_data(destination_object, KDMS_SEGMENT_VALUE,
		    nbegin, nend, data);

   }

   (void)klist_free(objlist,(kfunc_void)lkcall_free);
   return (TRUE);
}
/* -library_code_end */
