 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for kcpseg
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkcpseg
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkcpseg - copy segments from source to destination object
* 
*       Purpose: This routine will copy from the source_object the
*		 segments specified by segment_list into the
*		 destination_object.  Each segment's attributes and
*		 data will be copied into the destination_object.
*                If segment_list is NULL it will copy all the
*                segments in the object.  The segment_list is a
*		 string that contains each segment name separated
*		 by space(s).
*
*        !     lkcpseg(source_object, "segment1 segment2",
*        !                    destination_object);
*               
*		 If the segment does not exist an error message is
*		 printed, but will not return until an attempt to
*		 copy all the segments specified has been done.
*
*         Input: source_object - object to copy the segment(s) from
*                segment_list  - list of segment to copy
*
*        Output: destination_object - object to put the segment(s) into
*
*       Returns: TRUE (1) if one copied, FALSE (0) if none copied
*
*  Restrictions: 
*    Written By: John M. Salas & Donna Koechner
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int 
lkcpseg(
   kobject source_object,
   char   *segment_list,
   kobject destination_object)
/* -library_def_end */

/* -library_code */
{
   char **segment_names;
   int count;
   int failure = TRUE;
   int i;

   /*
    * If segment_list is NULL copy all the segments and their
    * attributes, using kdms_copy_object() to copy all the
    * segments and attributes contained within the source object. 
    */
   if (!segment_list)
   {
      if (!kdms_copy_object(source_object, destination_object, TRUE, TRUE))
      {
	 kerror("ksegops", "lkcpseg", 
		"Failed to copy source object to destination.");
      }
      else
      {
	 failure = FALSE;
      }
   }
   /*
    * If segment_list not NULL parse out the segment names using
    * kparse_string_delimit() and copy them one at a time.  Print
    * a message if a copy fails, but continue to copy segments until
    * attempts to copy all the segments have been done.
    */
   else
   {
      segment_names =
	 kparse_string_delimit(segment_list, " ", KDELIM_CLEAN, &count);

      for (i = 0; i < count; i++)
      {
	 /* copy the segment attributes */
	 if (!kdms_copy_segment_attributes(source_object, segment_names[i],
				      destination_object, segment_names[i]))
	 {
	    kerror("ksegops", "lkcpseg", "Failed to copy segment \
'%s' from source object to destination object.", segment_names[i]);
	 }
	 else
	 {
	    failure = FALSE;
	 }

	 /* copy the segment data */
	 if (!kdms_copy_segment_data(source_object, segment_names[i],
				     destination_object, segment_names[i]))
	 {

	    kerror("ksegops", "lkcpseg", "Failed to copy segment \
'%s' from source object to destination object.", segment_names[i]);
	 }
	 else
	 {
	    failure = FALSE;
	 }

      }
   }

   /*
    * If one of the segments were successfully copied return !failure.
    */
   return (!failure);
}
/* -library_code_end */
