 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for kmsquish
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkmsquish
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkmsquish - compress map to one column by means of Average, RMS or MAX
* 
*       Purpose: lkmsquish compresses a map down to one column, effectively
*                converting the map to a "greyscale" map. An example of
*                this operation is encountered when trying to print a
*                pseudocolor RGB image on a B/W laser printer: the RGB
*                color information must be somehow converted to greyscale
*                in order for the printer to know how to dither the image
*                during printing.
*
*                lkmsquish is very happy to operate on simple 3-column
*                maps, such as would be encountered when processing a
*                color image in any of the standard coordinate systems
*                (ntscRGB, etc). However, lkmsquish is not limited to 3 column
*                maps - it will operate on maps with any number of cloumns.
*
*                The conversion from multiple columns to a single column
*                is done by computing a grey level for each row of the map,
*                one at a time.  For type=1, the grey level for a row is the 
*                average of the columns in the row. For type=2, the grey 
*                level is the RMS value of the columns in the row. For type=3,
*                the grey level is the maximum value found in the colums of
*                the row.  Clearly, these schemes are not optimal in any 
*                sense, but one of them will usually give an acceptable result.
*
*                Ordinarily (map_flag=0), the map is the only part of the input
*                object that is modified. The value data is not touched; it
*                still points to various rows in the map just as before the
*                compression. If map_flag=1, the value data is pulled thru the
*                map and the map segment itself is removed. If mask data
*                is present, then this operation proceeds as described in
*                the man page for kmapdata(1).
*
*         Input: in_obj - input data object
*                map_flag - Pull value data thru resultant map (1), or update
*                           only the map segment (0)
*                type - Compute the grey level as the average (1),
*                       RMS (2), or MAX (3) of the components of each row
*                       in the existing map
*
*        Output: out_obj - output data object
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: Scott Wilson (stolen from K1.5 vmsquish, which was written by  Tom Sauer)
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lkmsquish(kobject in_obj, int map_flag, int type, kobject out_obj)
/* -library_def_end */

/* -library_code */
{
        char *lib = "kdatamanip", *rtn = "lkmsquish";
        klist *objlist=NULL;
        int itype,otype;
        int map_exists,mask_exists;
        unsigned int w,h,d,t,e; /* Dimensions of input data set */
        long *idata,*ii,*io;
        unsigned long *ldata,*li,*lo;
        double *ddata,*di,*dout;
        kobject tmp_obj,tmp_ref;
        int j,k;
        double sum,max;

        /* Make sure we have valid objects */
        if (in_obj == KOBJECT_INVALID || out_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus input or output object");
            return(FALSE);
          }
 
        mask_exists=kpds_query_mask(in_obj);
        map_exists=kpds_query_map(in_obj);

        if (!map_exists)
          {
            /* Nothing to do! */
            return(TRUE);
          }

        if (type <1 || type > 3)
          {
            kerror(lib,rtn, "Unknown squishing scheme: %d.",type);
            return(FALSE);
          }

        /* See if the data type of the input object map is real or complex */
        KCALL(kpds_get_attribute(in_obj,KPDS_MAP_DATA_TYPE,&itype));
        if (itype == KCOMPLEX || itype == KDCOMPLEX)
          {
            kerror(lib,rtn, "Can't handle complex map data types (yet).");
            return(FALSE);
          }
 
        /* Reference the input object to avoid side effects, then add the
           reference to the list of goodies to be automatically free'd on
           error. */
        KCALL((in_obj = kpds_reference_object(in_obj)));
        objlist = klist_add(objlist,in_obj,"KOBJECT");
 
        /* Fix up a tmp object */
        KCALL(tmp_obj = kpds_create_object());
        objlist = klist_add(objlist,tmp_obj,"KOBJECT");
         
        /* Fix up the data type for presentation */
        if (itype == KUBYTE || itype == KBYTE || itype == KBIT ||
            itype == KINT || itype == KLONG ) otype = KLONG;
        else if (itype == KUINT || itype == KULONG ) otype == KULONG;
        else if (itype == KFLOAT || itype == KDOUBLE) otype = KDOUBLE;
        else otype = KDOUBLE;
        KCALL(kpds_set_attribute(in_obj,KPDS_MAP_DATA_TYPE,otype));

        /* See how big the map is */
        KCALL(kpds_get_attribute(in_obj,KPDS_MAP_SIZE,&w,&h,&d,&t,&e));

        /* Set output map size and colorspace model */
        KCALL(kpds_copy_object(in_obj,tmp_obj));
/* Jer - if you delete the following two lines you will get odd behavior
         even though it should work correctly anyway. SRW 8-Feb-95 */
        KCALL(kpds_destroy_map(tmp_obj));
        KCALL(kpds_create_map(tmp_obj));
        KCALL(kcolor_set_attribute(tmp_obj,KCOLOR_COLORSPACE,KNONE));
        KCALL(kpds_set_attribute(tmp_obj,KPDS_MAP_SIZE,1,h,d,t,e));
        KCALL(kpds_set_attribute(tmp_obj,KPDS_MAP_DATA_TYPE,itype));
        KCALL((tmp_ref = kpds_reference_object(tmp_obj)));
        objlist = klist_add(objlist,tmp_ref,"KOBJECT");
        KCALL(kpds_set_attribute(tmp_ref,KPDS_MAP_DATA_TYPE,otype));

        /* Force the read position to the origin for input */
        KCALL(kpds_set_attribute(in_obj,KPDS_MAP_POSITION,0,0,0,0,0));

        /* Do the actual processing differently depending on the type of
           data we have to work with */
        if (otype == KLONG)
          {
            /* Allocate space for the input map data and output map data */
            KCALL(!((ii=(long *)kmalloc(w*sizeof(long)))== NULL));
            objlist = klist_add(objlist,ii,"KMALLOC");
            KCALL(!((io=(long *)kmalloc(1*sizeof(long)))== NULL));
            objlist = klist_add(objlist,io,"KMALLOC");

            /* Read the map, convert it, and spit it out */
            for (j=0; j<h*d*t*e; j++)
              {
                KCALL(kpds_get_data(in_obj,KPDS_MAP_LINE,(kaddr)ii));
                switch(t)
                  {
                    case 1:
                            sum = 0;
                            for (k=0; k<w; k++) sum += ii[k];
                            io[0] = sum/w;
                    case 2:
                            sum = 0;
                            for (k=0; k<w; k++) sum += ii[k]*ii[k];
                            io[0] = sqrt(sum/w);
                    case 3:
                            max = ii[0];
                            for (k=0; k<w; k++) if (ii[k]>max) max = ii[k];
                            io[0] = max;
                  }
                KCALL(kpds_put_data(tmp_ref,KPDS_MAP_LINE,(kaddr)io));
              }
          }
        else if (otype == KULONG)
          {
            /* Allocate space for the input map data and output map data */
            KCALL(!((li=(unsigned long *)kmalloc(w*sizeof(unsigned long)))== NULL)); 
            objlist = klist_add(objlist,li,"KMALLOC");
            KCALL(!((lo=(unsigned long *)kmalloc(1*sizeof(unsigned long)))== NULL));
            objlist = klist_add(objlist,lo,"KMALLOC");
 
            /* Read the map, convert it, and spit it out */
            for (j=0; j<h*d*t*e; j++)
              {
                KCALL(kpds_get_data(in_obj,KPDS_MAP_LINE,(kaddr)li));
                switch(t)
                  {
                    case 1:
                            sum = 0;
                            for (k=0; k<w; k++) sum += li[k];
                            lo[0] = sum/w;
                    case 2:
                            sum = 0;
                            for (k=0; k<w; k++) sum += li[k]*li[k];
                            lo[0] = sqrt(sum/w);
                    case 3:
                            max = li[0];
                            for (k=0; k<w; k++) if (li[k]>max) max = li[k];
                            lo[0] = max;
                  }
                KCALL(kpds_put_data(tmp_ref,KPDS_MAP_LINE,(kaddr)lo));
              }
          }
        else if (otype == KDOUBLE)
          {
            /* Allocate space for the input map data and output map data */
            KCALL(!((di=(double *)kmalloc(w*sizeof(double)))== NULL));
            objlist = klist_add(objlist,di,"KMALLOC");
            KCALL(!((dout=(double *)kmalloc(1*sizeof(double)))== NULL));
            objlist = klist_add(objlist,dout,"KMALLOC");
 
            /* Read the map, convert it, and spit it out */
            for (j=0; j<h*d*t*e; j++)
              {
                KCALL(kpds_get_data(in_obj,KPDS_MAP_LINE,(kaddr)di));
                switch(t)
                  {
                    case 1:
                            sum = 0;
                            for (k=0; k<w; k++) sum += di[k];
                            dout[0] = sum/w;
                    case 2:
                            sum = 0;
                            for (k=0; k<w; k++) sum += di[k]*di[k];
                            dout[0] = sqrt(sum/w);
                    case 3:
                            max = di[0];
                            for (k=0; k<w; k++) if (di[k]>max) max = di[k];
                            dout[0] = max;
                  }
                KCALL(kpds_put_data(tmp_ref,KPDS_MAP_LINE,(kaddr)dout));
              }
          }

        /* Force the data thru the map if the map flag is turned on. Note
           that this will remove the map, too! */
        if (map_flag)
          {
            KCALL(kpds_set_attribute(tmp_obj,KPDS_MAPPING_MODE, KMAPPED));
            KCALL(kpds_copy_object(tmp_obj,out_obj));
          }
        else
          {
            KCALL(kpds_copy_object(tmp_obj,out_obj));
          }

        (void)klist_free(objlist,(kfunc_void)lkcall_free);
	return TRUE;
}
/* -library_code_end */
