 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for karith1
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkarith1
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/*
 * Function structure declaration
 */
struct _function
{
        char    *name;
	kfunc_void routine;
};


/*
 * Function declaration list
 */
static struct _function functions[] =
{
    { "abs",    (kfunc_void) kfabs },
    { "sqrt",   (kfunc_void) ksqrt },
    { "cbrt",   (kfunc_void) kcbrt },
    { "neg",    (kfunc_void) kneg },
    { "recip",  (kfunc_void) krecip },
    { "not",    (kfunc_void) knot },
    { "clear",  (kfunc_void) kclear },
    { "set",    (kfunc_void) kset },
    { "sin",    (kfunc_void) ksin  },
    { "asin",   (kfunc_void) kasin },
    { "cos",    (kfunc_void) kcos  },
    { "acos",   (kfunc_void) kacos },
    { "tan",    (kfunc_void) ktan  },
    { "atan",   (kfunc_void) katan },
    { "sinh",   (kfunc_void) ksinh },
    { "cosh",   (kfunc_void) kcosh },
    { "tanh",   (kfunc_void) ktanh },
    { "asinh",  (kfunc_void) kasinh },
    { "acosh",  (kfunc_void) kacosh },
    { "atanh",  (kfunc_void) katanh },
    { "sinc",   (kfunc_void) ksinc },
    { "ceil",   (kfunc_void) kceil },
    { "floor",  (kfunc_void) kfloor },
    { "trunc",  (kfunc_void) ktrunc },
    { "fract",  (kfunc_void) kfraction },
    { "trunc",  (kfunc_void) ktrunc },
    { "erf",    (kfunc_void) kerf },
    { "erfc",   (kfunc_void) kerfc },
    { "lgamma",  (kfunc_void) kgamma },
};

/*
static int numfuncs = knumber(functions);
*/
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkarith1 - perform single operand arithmetic on data object
* 
*       Purpose: The following is the library routine that performs
*		 a unary function on a data object.  The routine takes
*		 an input data object, a function name, and an output
*		 data object in which to store the result of the
*		 function.
*
*		 The supported functions are:
*                .TS
*                center tab(:) ;
*                l l .
*		 abs   :  Output is Absolute Value of input
*		 sqrt  :  Output is Square Root of input
*		 cbrt  :  Output is Cube Root of input
*		 neg   :  Output is Negative of input
*		 recip :  Output is Reciprocal of input
*		 not   :  Bitwise NOT operation
*		 clear :  Bitwise CLEAR - set all valid bits to 0
*		 set   :  Bitwise SET - set all valid bits to 1
*		 sin   :  Output is the sine() of the input
*		 asin  :  Output is the arc sine() of the input
*		 cos   :  Output is the cosine() of the input
*		 acos  :  Output is arc cosine() of the input
*		 tan   :  Output is tangent() of the input
*		 atan  :  Output is arc tangent() of the input
*		 sinh  :  Output is hyperbolic sine() of the input
*		 asinh :  Output is hyperbolic arc sine() of the input
*		 cosh  :  Output is hyperbolic cosine() of the input
*		 acosh :  Output is arc hyperbolic cosine() of the input
*		 tanh  :  Output is hyperbolic tangent() of the input
*		 atanh :  Output is hyperbolic tangent() of the input
*		 sinc  :  Output is sin(x)/x of the input
*		 ceil  :  Output is ceiling of the input
*		 floor :  Output is floor of the input
*		 trunc :  Output is interger truncate of the input
*		 fract :  Output is fractional part of the input
*		 lgamma:  Output is the lgamma function of the input
*		 erfc  :  Output is 1.0-erf(x)
*		 erf   :  Output is error function of x where 
*		       :  erf(x)=2/sqrt(pi)*integralfrom0
*                .TE
*
*		 Therefore if lkarith1() were called with:
*
*		 !    lkarith1(i, "sin", o);
*
*		 then the following would be performed:
*
*		 !    o = sin(i);
*
*         Input: src_obj  - the input object to be processed
*		 function   - the function to be applied
*        Output: dst_obj - the output object
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*  Restrictions: 
*    Written By: Scott Wilson, Donna Koechner, Mark Young, Ashish Malhotra
*          Date: Apr 12, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lkarith1(
   kobject src_obj,
   char    *function,
   kobject dst_obj)
/* -library_def_end */

/* -library_code */
{
	kfunc_long   lroutine;  /* set, clear, and not functions are long */
	kfunc_double routine;   /* all other functions are double */
	char *lib = "kdatamanip", *rtn = "lkarith1";
	long  num_pts;
        int   num_rgns, w,h,d,t,e,type,in_type;
        int   j, num, error = FALSE;
	int   map_exists, val_exists;
	char *region, *opt_region, *datasize, *datatype, *region_size;
	double *data = NULL;	 	/* array for non-complex data */
	unsigned long *ldata = NULL; 	/* array for long data */
	int   func;			/* function number (converted from 
					   function string variable) */

	/*
	 *  Check which segments (VALUE, MAP) are available for lkarith1.
	 *
	 *  If there is a MAP, operate directly on the map (Don't worry 
	 *  about VALUE data).  
	 *
	 *  If there is no map, operate on the VALUE data.  If operating on 
	 *  VALUE data and there is a MASK, ignore the MASK.  
	 *
	 *  If there is no MAP or VALUE data, fail.
	 */
	map_exists  = kpds_query_map(src_obj);
	val_exists  = kpds_query_value(src_obj);

	if (!map_exists && !val_exists)
	{
	   kerror(lib, rtn,
		  "Input data object must have either Value or Map data.");
	   return(FALSE);
	}

	/* 
	 *  Create a reference to the source data object passed in, so
	 *  that the library (lkarith1) will have no unexpected side
	 *  effects on it (such as changing the position attribute.
	 */
	if ((src_obj = kpds_reference_object(src_obj)) == KOBJECT_INVALID)
	{
	   kerror(lib, rtn, "Failed to reference input object");
	   return(FALSE);
	}

	for (num = 0, func = -1; num < knumber(functions) && func == -1; num++)
	{
	   if (kstrcmp(function, functions[num].name) == 0)
	   {
	      func = num;
	      break;
	   }
	}

	if (func == -1)
	{
	   kerror(lib, rtn, "Sorry, but the function '%s' is not in the \
list of callable functions", function);
	   (void) kpds_close_object(src_obj); 
	   return(FALSE);
	}
	else if (!functions[func].routine)
	{
	   kerror(lib, rtn, "Sorry, but karith1 is unable to run the \
function '%s' on data objects at this time.", function);
	   (void) kpds_close_object(src_obj); 
	   return(FALSE);
	}
	else
	{
	   routine = (kfunc_double) functions[func].routine;
	   lroutine = (kfunc_long)  functions[func].routine;
	}

	kinfo(KVERBOSE, "function = %s (%s, %d)", function, functions[func].name, func);

	/*
	 *  Because operations in karith1 are pointwise, if there
	 *  is a map, we can work on it directly without having to
	 *  map the value data first.  Set val_exists and mask_exists
	 *  to false since they should not be use.
	 */
	if (map_exists)
	{
	   region       = KPDS_MAP_REGION;
	   region_size  = KPDS_MAP_REGION_SIZE;
	   opt_region   = KPDS_MAP_OPTIMAL_REGION_SIZE;
	   datasize     = KPDS_MAP_SIZE;
	   datatype     = KPDS_MAP_DATA_TYPE;
	   val_exists   = FALSE;
	}
	else
	{
	   region       = KPDS_VALUE_REGION;
	   region_size  = KPDS_VALUE_REGION_SIZE;
	   opt_region   = KPDS_VALUE_OPTIMAL_REGION_SIZE;
	   datasize     = KPDS_VALUE_SIZE;
	   datatype     = KPDS_VALUE_DATA_TYPE;
	}

        if (!kpds_get_attributes(src_obj, datasize, &w,&h,&d,&t,&e, 
				     datatype, &type, NULL))
	{
	   kerror(lib, rtn, "Unable to get attributes on src_object.");
           (void) kpds_close_object(src_obj);
           return(FALSE);
	}
        in_type = type;
	/*
	 *  Complex processing not supported at this time, so if the 
	 *  data type of the source object is double complex, print
	 *  message and return.
	 */
	if ( (type == KCOMPLEX) || (type == KDCOMPLEX) ) 
	{
	   kerror(lib, rtn, "Sorry, but karith1 operations are not defined for \
complex data at this time.");
	   (void) kpds_close_object(src_obj); 
	   return(FALSE);
	}

	/*
	 *  Set the size and datatype of the output data object to be 
	 *  the same as the input data object.
	 */
	if (map_exists)	
	{
	   if (!kpds_query_map(dst_obj))
	   {
	      if (!kpds_create_map(dst_obj))
	      {
	         kerror(lib, rtn, "Unable to create destination object map.");
                 (void) kpds_close_object(src_obj);
                 return(FALSE);
	      }
	   }
	}	
	else
	{
	   if (!kpds_query_value(dst_obj))
	   {
	      if (!kpds_create_value(dst_obj))
	      {
	         kerror(lib, rtn, "Unable to create destination value data.");
                 (void) kpds_close_object(src_obj);
                 return(FALSE);
	      }
	   }
	}	
	if (!kpds_set_attributes(dst_obj,datasize,w,h,d,t,e,datatype,type,NULL))
	{
	   kerror(lib, rtn, "Unable to set destination object attributes.");
	   (void) kpds_close_object(src_obj);
	   return(FALSE);
	}
	
	/* 
	 *  After all of the segments and attributes that need to be 
	 *  transferred to the destination object have been set or created, 
	 *  make a reference to the object so that further attribute changes 
	 *  will only affect how the data is presented.
	 */
	if ((dst_obj = kpds_reference_object(dst_obj)) == KOBJECT_INVALID)
        {
           kerror(lib, rtn, "Failed to duplicate output object");
	   (void) kpds_close_object(src_obj); 
           return(FALSE);
        }

        /*
         *  Set source and destination presentation data types as either
	 *  KDOUBLE or KULONG (KULONG only if the operator chosen is a 
	 *  bitwise operator.
         */

        type = kdatatype_cast_process(type, type, (KULONG | KDOUBLE));
	if ( (kstrcmp(function, "set") == 0) || 
	     (kstrcmp(function, "not") == 0) ||
	     (kstrcmp(function, "clear") == 0) )
	{
	   if (type == KDOUBLE)
	   {
	      kinfo(KSTANDARD, 
		"Warning: lkarith1 casts floating point input data to unsigned \
long before performing bitwise operation - precision may be lost.");
	   }
	   type = KULONG;
	}
	else
	   type = KDOUBLE;

	if (!kpds_set_attribute(src_obj, datatype, type))
	{
	   kerror(lib, rtn, "Unable to set source object datatype attribute.");
	   (void) kpds_close_object(src_obj);
	   (void) kpds_close_object(dst_obj);
	   return(FALSE);
	}
	if (!kpds_set_attribute(dst_obj, datatype, type))
	{
	   kerror(lib, rtn, "Unable to set destination datatype.");
	   (void) kpds_close_object(src_obj);
	   (void) kpds_close_object(dst_obj);
	   return(FALSE);
	}

        /*
         *  We will process the data by optimal regions, so get the optimal
	 *  region size and the number of optimal regions in src_obj.
	 *  Do this after setting the data type because data type is a 
	 *  in determining optimal region size.
         */
        if (!kpds_get_attribute(src_obj, opt_region, &w,&h,&d,&t,&e, &num_rgns))
	{
	   kerror(lib, rtn, "Unable to get source optimal region size.");
	   (void) kpds_close_object(src_obj);
	   (void) kpds_close_object(dst_obj);
	   return(FALSE);
	}
	num_pts = w*h*d*t*e;
        if (! (kpds_set_attribute(src_obj, region_size, w,h,d,t,e)) ||
            ! (kpds_set_attribute(dst_obj, region_size, w,h,d,t,e)))
	{
	   kerror(lib, rtn, "Unable to set object value region sizes.");
	   (void) kpds_close_object(src_obj);
	   (void) kpds_close_object(dst_obj);
	   return(FALSE);
	}

	/*
	 *  Do the processing by requesting regions of data from src_obj, 
	 *  evaluating the expression, and then storing the result into 
	 *  the destination object.
	 */
	if (type == KDOUBLE)
	{
	   for (num = 0; num < num_rgns; num++)
	   {
	      if ((data=(double *)kpds_get_data(src_obj, region, (kaddr) data))
			 == NULL)
	      {
	         kerror(lib, rtn, "failed to get region from source object");
	         error = TRUE;
                 break;
	      }

              for (j = 0; j < num_pts; j++) data[j] = routine(data[j]);
   
              if (!kpds_put_data(dst_obj, region, (kaddr) data))
	      {
	         kerror(lib, rtn, "failed to put region in destination object");
	         error = TRUE;
                 break;
	      }
	   }
	}
	else if (type == KULONG)
	{ 
	   /* type should only be KULONG if a bitwise function (set, 
	    * clear, or not) is called.
	    */
	   for (num = 0; num < num_rgns; num++)
	   {
	      if ((ldata=(unsigned long *)kpds_get_data(src_obj, region, (kaddr) ldata))
			== NULL)
	      {
	         kerror(lib, rtn, "failed to get region from source object");
	         error = TRUE;
                 break;
	      }
	      for (j = 0; j < num_pts; j++) ldata[j] = lroutine(ldata[j]);
              /* If original data was BIT, need to trim off all but bit0
                 so that the output cast works */
              if (in_type == KBIT)
                {
	          for (j = 0; j < num_pts; j++)
                    {
                      ldata[j] = ldata[j] & 0x1;
                    }
                }
 
              if (!kpds_put_data(dst_obj, region, (kaddr) ldata))
	      {
	         kerror(lib, rtn, "failed to put line in output object");
	         error = TRUE;
                 break;
	      }
	   }
	}
	else 
	{
	   kerror(lib, rtn, "Unrecognized processing datatype %d",type);
	   error = TRUE;
	}
	
	(void) kpds_close_object(src_obj);
        (void) kpds_close_object(dst_obj);

	kfree(data);

        if (error)
	   return(FALSE);
        else
           return(TRUE);
}
/* -library_code_end */
