 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kstats
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kstats.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compute Statistics of Data Object
|
|       Purpose: main program for kstats
|
|         Input:
|		char *clui_info->i_file; {Input object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->igate_file; {Gating input data object}
|		int   clui_info->igate_flag; {TRUE if -igate specified}
|
|		char *clui_info->f_file; {Formatted ASCII output file}
|		int   clui_info->f_flag; {TRUE if -f specified}
|
|		char *clui_info->o_file; {Binary output statistics file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Optional M.E. group:
|		    int clui_info->whole_flag; {TRUE if -whole specified}
|
|		    Loose group:
|			int clui_info->w_flag; {TRUE if -w specified}
|
|			int clui_info->h_flag; {TRUE if -h specified}
|
|			int clui_info->d_flag; {TRUE if -d specified}
|
|			int clui_info->t_flag; {TRUE if -t specified}
|
|			int clui_info->e_flag; {TRUE if -e specified}
|
|		Optional M.E. group:
|		    int clui_info->all_flag; {TRUE if -all specified}
|
|		    Loose group:
|			int clui_info->mean_flag; {TRUE if -mean specified}
|
|			int clui_info->sum_flag; {TRUE if -sum specified}
|
|			int clui_info->var_flag; {TRUE if -var specified}
|
|			int clui_info->wmin_flag; {TRUE if -wmin specified}
|
|			int clui_info->psum_flag; {TRUE if -psum specified}
|
|			int clui_info->sd_flag; {TRUE if -sd specified}
|
|			int clui_info->hmin_flag; {TRUE if -hmin specified}
|
|			int clui_info->nsum_flag; {TRUE if -nsum specified}
|
|			int clui_info->rms_flag; {TRUE if -rms specified}
|
|			int clui_info->dmin_flag; {TRUE if -dmin specified}
|
|			int clui_info->pts_flag; {TRUE if -pts specified}
|
|			int clui_info->skew_flag; {TRUE if -skew specified}
|
|			int clui_info->tmin_flag; {TRUE if -tmin specified}
|
|			int clui_info->ppts_flag; {TRUE if -ppts specified}
|
|			int clui_info->kur_flag; {TRUE if -kur specified}
|
|			int clui_info->emin_flag; {TRUE if -emin specified}
|
|			int clui_info->npts_flag; {TRUE if -npts specified}
|
|			int clui_info->minval_flag; {TRUE if -minval specified}
|
|			int clui_info->zpts_flag; {TRUE if -zpts specified}
|
|			int clui_info->maxval_flag; {TRUE if -maxval specified}
|
|			int clui_info->wmax_flag; {TRUE if -wmax specified}
|
|			int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|			int clui_info->hmax_flag; {TRUE if -hmax specified}
|
|			int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|			int clui_info->dmax_flag; {TRUE if -dmax specified}
|
|			int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|			int clui_info->tmax_flag; {TRUE if -tmax specified}
|
|			int clui_info->tsize_flag; {TRUE if -tsize specified}
|
|			int clui_info->emax_flag; {TRUE if -emax specified}
|
|			int clui_info->esize_flag; {TRUE if -esize specified}
|
|        Output:
|       Returns:
|
|    Written By: Ashish Malhotra & Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject       in_obj=NULL, gate_obj=NULL, stats_obj=NULL;
        kfile         *ascii_out=NULL;
        char          *filename=NULL;
        unsigned long stats_flag=0;
        unsigned long auxinfo_flag=0;
        unsigned long stats_region=0;
	int	      output_ascii;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kstats_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kstats",
		kstats_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kstats_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/* Open input data and gating objects 
	 */
	in_obj = kpds_open_input_object(clui_info->i_file);
        if (in_obj == KOBJECT_INVALID) {
            kerror("kstats", "main", "Cannot Open Input Object.");
            kexit(KEXIT_FAILURE);
        }

        if (clui_info->igate_flag) {
           gate_obj = kpds_open_input_object(clui_info->igate_file);
	   if (gate_obj == KOBJECT_INVALID) {
              kerror("kstats", "main", "Cannot Open Gating Input Object.");
              kexit(KEXIT_FAILURE);
           }
	}
	
	/* If a binary output object was specified, open it and pass it
         * to lkstats as stats_obj.  Otherwise, create stats_obj (kobject).  
	 * If an output ascii file was specified, the information printed 
	 * to it will be acquired from the stats_obj that lkstats returns.
	 * The library will check if the stats_obj has a value segment,
	 * and will create one there if it does not exist, along with the
	 * appropriate attributes.  lkstats will not alter other existing 
	 * segments in stats_obj.
	 */

        if (clui_info->o_flag) 
           stats_obj = kpds_open_output_object(clui_info->o_file);
	else 
	   stats_obj = kpds_create_object();

	if (stats_obj == KOBJECT_INVALID) {
           kerror("kstats", "main", "Cannot Open Ouput Object.");
           kexit(KEXIT_FAILURE);
        }
 
        /* Combine all flags into stats_flag by left shifting and adding. 
	 */
        stats_flag |= (clui_info->mean_flag)   ? KSTATS_MEAN     : 0; 
        stats_flag |= (clui_info->var_flag)    ? KSTATS_VAR      : 0;
        stats_flag |= (clui_info->sd_flag)     ? KSTATS_STDDEV   : 0;
        stats_flag |= (clui_info->rms_flag)    ? KSTATS_RMS      : 0;
        stats_flag |= (clui_info->skew_flag)   ? KSTATS_SKEW     : 0; 
        stats_flag |= (clui_info->kur_flag)    ? KSTATS_KURT     : 0;
        stats_flag |= (clui_info->minval_flag) ? KSTATS_MIN      : 0; 
        stats_flag |= (clui_info->maxval_flag) ? KSTATS_MAX      : 0; 
        stats_flag |= (clui_info->sum_flag)    ? KSTATS_SUM      : 0; 
        stats_flag |= (clui_info->psum_flag)   ? KSTATS_POSSUM   : 0; 
        stats_flag |= (clui_info->nsum_flag)   ? KSTATS_NEGSUM   : 0; 
        stats_flag |= (clui_info->pts_flag)    ? KSTATS_PTS      : 0;
        stats_flag |= (clui_info->ppts_flag)   ? KSTATS_POSPTS   : 0;
        stats_flag |= (clui_info->npts_flag)   ? KSTATS_NEGPTS   : 0;
        stats_flag |= (clui_info->zpts_flag)   ? KSTATS_ZEROPTS  : 0; 

	/* Set up the auxiliary information flags.  If any are set,
	 */
        auxinfo_flag |= (clui_info->wmin_flag)  ? KSTATS_WMIN  : 0;
        auxinfo_flag |= (clui_info->hmin_flag)  ? KSTATS_HMIN  : 0;
        auxinfo_flag |= (clui_info->dmin_flag)  ? KSTATS_DMIN  : 0;
        auxinfo_flag |= (clui_info->tmin_flag)  ? KSTATS_TMIN  : 0;
	auxinfo_flag |= (clui_info->emin_flag)  ? KSTATS_EMIN  : 0;
        auxinfo_flag |= (clui_info->wmax_flag)  ? KSTATS_WMAX  : 0;
        auxinfo_flag |= (clui_info->hmax_flag)  ? KSTATS_HMAX  : 0;
        auxinfo_flag |= (clui_info->dmax_flag)  ? KSTATS_DMAX  : 0;
        auxinfo_flag |= (clui_info->tmax_flag)  ? KSTATS_TMAX  : 0;
        auxinfo_flag |= (clui_info->emax_flag)  ? KSTATS_EMAX  : 0;
        auxinfo_flag |= (clui_info->wsize_flag) ? KSTATS_WSIZE : 0; 
        auxinfo_flag |= (clui_info->hsize_flag) ? KSTATS_HSIZE : 0; 
        auxinfo_flag |= (clui_info->dsize_flag) ? KSTATS_DSIZE : 0; 
        auxinfo_flag |= (clui_info->tsize_flag) ? KSTATS_TSIZE : 0; 
        auxinfo_flag |= (clui_info->esize_flag) ? KSTATS_ESIZE : 0; 

        /* Since the "all" flag and the individual statistics flags are 
         * optional, and therefore must be specified on the command line 
         * in order to take effect, if *none* of them are set, we'll assume
         * that the user want them all and just forgot to enter -all on
         * the command line (otherwise, there would be no output).  
         * If clui_info->all_flag is set, decrement KSTATS_ALL_STATS and 
	 * KSTATS_ALL_AUXINFO. It will fill all the lower bits with 1.
         */ 
        if (stats_flag == 0 && auxinfo_flag == 0)
           clui_info->all_flag = TRUE;
        stats_flag = (clui_info->all_flag) ? (KSTATS_ALL_STATS-1) : stats_flag;
        auxinfo_flag = (clui_info->all_flag) ? (KSTATS_ALL_AUXINFO-1) : auxinfo_flag;

        /* If none of the processing region flags are set, set the
	 * the whole flag as the default region.
         */
        if ( (!clui_info->whole_flag) && (!clui_info->w_flag) &&
	     (!clui_info->h_flag) && (!clui_info->d_flag) &&
	     (!clui_info->t_flag) && (!clui_info->e_flag) )
	{
	   clui_info->whole_flag = TRUE;
	}

	/* Combine all dimensions into process_dimen. 
	 */
        if (clui_info->whole_flag)
        {
           stats_region = KSTATS_WIDTH | KSTATS_HEIGHT | KSTATS_DEPTH | 
			  KSTATS_TIME | KSTATS_ELEMENT;
        }
	else 
	{
           stats_region |= (clui_info->w_flag) ? KSTATS_WIDTH   : 0;
           stats_region |= (clui_info->h_flag) ? KSTATS_HEIGHT  : 0;
           stats_region |= (clui_info->d_flag) ? KSTATS_DEPTH   : 0;
           stats_region |= (clui_info->t_flag) ? KSTATS_TIME    : 0;
           stats_region |= (clui_info->e_flag) ? KSTATS_ELEMENT : 0;
	}


	/* Open the ASCII output file if it was specified.  If neither
	 * an ASCII nor a binary output file was specified by the user,
	 * print the requested statistical information to kstdout.
 	 */
        output_ascii = TRUE;
        if (clui_info->f_flag)
           ascii_out = kfopen(clui_info->f_file, "w");
        else if (!clui_info->o_flag)
              ascii_out = (kfile *) kstdout;
        else
          output_ascii = FALSE;

        if (output_ascii)
        {
           filename = kbasename(clui_info->i_file, NULL);
           kfprintf(ascii_out, "FILE:  %s\n",filename);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!(lkstats(in_obj, gate_obj, stats_obj, 
		      stats_flag, auxinfo_flag, stats_region,
		      ascii_out, output_ascii)))
        {
           kpds_close_object(in_obj);
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        if (in_obj) kpds_close_object(in_obj);
        if (gate_obj) kpds_close_object(gate_obj);
        if (stats_obj) 
	{
	   /* add history to the output object */
	   if (!kpds_set_attribute(stats_obj, 
				   KPDS_HISTORY, kpds_history_string()))
	   {
	      kerror("kstats", "main", 
		     "Unable to	 set history on the destination object");
	      kexit(KEXIT_FAILURE);
	   }

	   kpds_close_object(stats_obj);
	}
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kstats_usage_additions
| 
|       Purpose: Prints usage additions in kstats_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kstats
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kstats_usage_additions(void)
{
	kfprintf(kstderr, "\tCompute Statistics of Data Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kstats_free_args
| 
|       Purpose: Frees CLUI struct allocated in kstats_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kstats
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kstats_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->igate_file);
	kfree(clui_info->f_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
