 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kshot
   >>>> 
   >>>>    Written By: Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kshot_h_
#define _kshot_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kshot/uis/kshot.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input File (required infile)
 */
char	*i_file;	/* Input File FILENAME */
int	 i_flag;	/* Input File FLAG */

/*
 *  Percentage of spikes in the output (required double)
 */
double	 spikes_double;	/* Percentage of spikes in the output DOUBLE */
int	 spikes_flag;   	/* Percentage of spikes in the output FLAG */

/*
 *  Output File (required outfile)
 */
char	*o_file;	/* Output File FILENAME */
int	 o_flag;	/* Output File FLAG */

/*
 *  Real value of spike  (optional double)
 */
double	 real_double;	/* Real value of spike  DOUBLE */
int	 real_flag;   	/* Real value of spike  FLAG */

/*
 *  Imaginary value of spike (optional double)
 */
double	 imag_double;	/* Imaginary value of spike DOUBLE */
int	 imag_flag;   	/* Imaginary value of spike FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kshot_get_args PROTO((kform *));
void kshot_usage_additions PROTO((void));
void kshot_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
