 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "ksampline.h"
/*-----------------------------------------------------------
| 
|  Routine Name: ksampline_get_args
| 
|       Purpose: Gets command line args for ksampline
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksampline
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ksampline_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for ksampline is out of sync with arguments specified in ksampline's *.pane file; please rerun ghostwriter on ksampline.";


	/*
	 * allocate the ksampline structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wc1",
			  &(clui_info->wc1_double),
			  &(clui_info->wc1_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wc2",
			  &(clui_info->wc2_double),
			  &(clui_info->wc2_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "hc1",
			  &(clui_info->hc1_double),
			  &(clui_info->hc1_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "hc2",
			  &(clui_info->hc2_double),
			  &(clui_info->hc2_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "dc1",
			  &(clui_info->dc1_double),
			  &(clui_info->dc1_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "dc2",
			  &(clui_info->dc2_double),
			  &(clui_info->dc2_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "tc1",
			  &(clui_info->tc1_double),
			  &(clui_info->tc1_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "tc2",
			  &(clui_info->tc2_double),
			  &(clui_info->tc2_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "ec1",
			  &(clui_info->ec1_double),
			  &(clui_info->ec1_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "ec2",
			  &(clui_info->ec2_double),
			  &(clui_info->ec2_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "n",
			  &(clui_info->n_int),
			  &(clui_info->n_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "nc",
			  &(clui_info->nc_int),
			  &(clui_info->nc_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "ksampline_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



