 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kresample
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kresample.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Resample Object Data
|
|       Purpose: main program for kresample
|
|         Input:
|		char *clui_info->i_file; {Input Object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting output object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		double clui_info->wmag_double; {Magnification in the width dimension}
|		int    clui_info->wmag_flag; {TRUE if -wmag specified}
|
|		double clui_info->hmag_double; {Magnification in the height dimension}
|		int    clui_info->hmag_flag; {TRUE if -hmag specified}
|
|		double clui_info->dmag_double; {Magnification in the depth dimension}
|		int    clui_info->dmag_flag; {TRUE if -dmag specified}
|
|		double clui_info->tmag_double; {Magnification in the time dimension}
|		int    clui_info->tmag_flag; {TRUE if -tmag specified}
|
|		double clui_info->emag_double; {Magnification in the elements dimension}
|		int    clui_info->emag_flag; {TRUE if -emag specified}
|
|		int   clui_info->inter_list; {Interpolation Type}
|		char *clui_info->inter_label;
|		int   clui_info->inter_flag; {TRUE if -inter specified}
|
|		int clui_info->resize_logic; {resize dimensions of object to the expanded/shrunk size}
|		int clui_info->resize_flag; {TRUE if -resize specified}
|
|		int clui_info->center_flag; {TRUE if -center specified}
|
|		int clui_info->wc_int; {Width coordinate for the center of action}
|		int clui_info->wc_flag; {TRUE if -wc specified}
|
|		int clui_info->hc_int; {Height coordinate for the center of action}
|		int clui_info->hc_flag; {TRUE if -hc specified}
|
|		int clui_info->dc_int; {Depth coordinate for the center of action}
|		int clui_info->dc_flag; {TRUE if -dc specified}
|
|		int clui_info->tc_int; {Time coordinate for the center of action}
|		int clui_info->tc_flag; {TRUE if -tc specified}
|
|		int clui_info->ec_int; {Elements coordinate for the center of action}
|		int clui_info->ec_flag; {TRUE if -ec specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner, Scott Wilson, & Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject i=NULL, o=NULL;
        int     resize, interpolate=KZERO_ORDER;
        double  wfactor, hfactor, dfactor, tfactor, efactor;
        int     wcenter, hcenter, dcenter, tcenter, ecenter;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kresample_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kresample",
		kresample_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kresample_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /* Open the input and output objects */
        if ((i = kpds_open_input_object(clui_info->i_file))==KOBJECT_INVALID)
	{
           kerror("kresample","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
	}

        if ((o = kpds_open_output_object(clui_info->o_file))==KOBJECT_INVALID)
	{
           kerror("kresample","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
	}
 
        /* Go get the magnification factors (even if default ) */
        wfactor = clui_info->wmag_double;
        hfactor = clui_info->hmag_double;
        dfactor = clui_info->dmag_double;
        tfactor = clui_info->tmag_double;
        efactor = clui_info->emag_double;

        /* See of a global shrink/expand factor has been selected. If so,
           set all of the individual magnifcations to the given factor if
           they weren't specifically set to something else. */
/* removed common factor option Jul 13 1994 - dk 
        if (clui_info->factor_flag)
        {
           if (!clui_info->wmag_flag) wfactor = clui_info->factor_double;
           if (!clui_info->hmag_flag) hfactor = clui_info->factor_double;
           if (!clui_info->dmag_flag) dfactor = clui_info->factor_double;
           if (!clui_info->tmag_flag) tfactor = clui_info->factor_double;
           if (!clui_info->emag_flag) efactor = clui_info->factor_double;
        }
*/

        /* Go get the COA positions (even if default) */
        wcenter = hcenter = dcenter = tcenter = ecenter = -1;
        if (clui_info->wc_flag) wcenter = clui_info->wc_int;
        if (clui_info->hc_flag) hcenter = clui_info->hc_int;
        if (clui_info->dc_flag) dcenter = clui_info->dc_int;
        if (clui_info->tc_flag) tcenter = clui_info->tc_int;
        if (clui_info->ec_flag) ecenter = clui_info->ec_int;

        /* If the global center option is selected, mark all dimension
           center of actions likewise unless they were specifically
           set to something else. */ 
        if (clui_info->center_flag)
        {
           if (!clui_info->wc_flag) wcenter = -1;
           if (!clui_info->hc_flag) hcenter = -1;
           if (!clui_info->dc_flag) dcenter = -1;
           if (!clui_info->tc_flag) tcenter = -1;
           if (!clui_info->ec_flag) ecenter = -1;
        }

        if (clui_info->inter_list == 0)
           interpolate = KZERO_ORDER;
        else if (clui_info->inter_list == 1)
           interpolate = KFIRST_ORDER;
        else
           kexit(KEXIT_FAILURE);
 
        /* See if we're supposed to resize the dimensions to fit the data set. */
        resize = clui_info->resize_logic;

        /* Make sure the output object is same. */
        if (!kpds_copy_object_attr(i, o))
	{
           kerror("kresample","main", 
		  "Cannot copy attributes from input object to output object.");
           kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkresample(i, wfactor, hfactor, dfactor, tfactor, efactor,
                      wcenter, hcenter, dcenter, tcenter, ecenter,
                      resize, interpolate, o))
           kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(o, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kresample", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_remaining_data(i, o))
	{
           kerror("kresample","main", 
		  "Cannot copy remaining data from input object to output.");
           kexit(KEXIT_FAILURE);
	}

        kpds_close_object(i);
        kpds_close_object(o);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kresample_usage_additions
| 
|       Purpose: Prints usage additions in kresample_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kresample
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kresample_usage_additions(void)
{
	kfprintf(kstderr, "\tResample Object Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kresample_free_args
| 
|       Purpose: Frees CLUI struct allocated in kresample_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kresample
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kresample_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->inter_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
