 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kreplace.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kreplace_get_args
| 
|       Purpose: Gets command line args for kreplace
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kreplace
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kreplace_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kreplace is out of sync with arguments specified in kreplace's *.pane file; please rerun ghostwriter on kreplace.";


	/*
	 * allocate the kreplace structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kreplace_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "oval",
			  &(clui_info->oval_double),
			  &(clui_info->oval_flag))))
	{
	    kerror(NULL, "kreplace_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "nval",
			  &(clui_info->nval_double),
			  &(clui_info->nval_flag))))
	{
	    kerror(NULL, "kreplace_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "utol",
			  &(clui_info->utol_double),
			  &(clui_info->utol_flag))))
	{
	    kerror(NULL, "kreplace_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "ltol",
			  &(clui_info->ltol_double),
			  &(clui_info->ltol_flag))))
	{
	    kerror(NULL, "kreplace_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kreplace_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



